/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTextArea;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Formula;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.UserColumn;
import jimm.datavision.field.SpecialField;
import jimm.datavision.source.Column;

public class DropListenerTextArea
extends JTextArea
implements DropTargetListener {
    protected Report report;

    public DropListenerTextArea(Report report, String string) {
        super(string);
        this.report = report;
        new DropTarget(this, 3, this);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (dropTargetDropEvent.isDataFlavorSupported(dataFlavor)) {
                String string = (String)transferable.getTransferData(dataFlavor);
                if (string.startsWith("column:")) {
                    Column column = this.report.findColumn(string.substring(7));
                    this.replaceSelection("{" + column.fullName() + "}");
                } else if (string.startsWith("parameter:")) {
                    Parameter parameter = this.report.findParameter(string.substring(10));
                    this.replaceSelection(parameter.designLabel());
                } else if (string.startsWith("formula:")) {
                    Formula formula = this.report.findFormula(string.substring(8));
                    this.replaceSelection(formula.designLabel());
                } else if (string.startsWith("usercol:")) {
                    UserColumn userColumn = this.report.findUserColumn(string.substring(8));
                    this.replaceSelection(userColumn.designLabel());
                } else if (string.startsWith("special:")) {
                    SpecialField specialField = new SpecialField(null, this.report, null, string.substring(8), false);
                    this.replaceSelection(specialField.formulaString());
                } else {
                    this.replaceSelection(string);
                }
                dropTargetDropEvent.acceptDrop(3);
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            ErrorHandler.error(exception);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

