/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import jimm.datavision.ErrorHandler;
import jimm.datavision.FieldWalker;
import jimm.datavision.Group;
import jimm.datavision.PaperFormat;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.UserCancellationException;
import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.AggregatesWin;
import jimm.datavision.gui.AskStringDialog;
import jimm.datavision.gui.BoundsWin;
import jimm.datavision.gui.Clipboard;
import jimm.datavision.gui.DescripWin;
import jimm.datavision.gui.DesignWin;
import jimm.datavision.gui.DesignWinLayout;
import jimm.datavision.gui.ExportWin;
import jimm.datavision.gui.FieldPickerWin;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.FieldWidgetWalker;
import jimm.datavision.gui.FormatWin;
import jimm.datavision.gui.GroupWin;
import jimm.datavision.gui.HelpWin;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.NewGroupWin;
import jimm.datavision.gui.ScriptingWin;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.SortWin;
import jimm.datavision.gui.StartupScriptEditor;
import jimm.datavision.gui.StatusDialog;
import jimm.datavision.gui.TextFieldWidget;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.CommandHistory;
import jimm.datavision.gui.cmd.CompoundCommand;
import jimm.datavision.gui.cmd.CutCommand;
import jimm.datavision.gui.cmd.DeleteCommand;
import jimm.datavision.gui.cmd.DeleteGroupCommand;
import jimm.datavision.gui.cmd.DeleteSectionCommand;
import jimm.datavision.gui.cmd.FieldAlignCommand;
import jimm.datavision.gui.cmd.FieldClipping;
import jimm.datavision.gui.cmd.FieldMoveCommand;
import jimm.datavision.gui.cmd.FieldResizeCommand;
import jimm.datavision.gui.cmd.FieldShowHideCommand;
import jimm.datavision.gui.cmd.FieldStretchCommand;
import jimm.datavision.gui.cmd.NewImageFieldCommand;
import jimm.datavision.gui.cmd.NewSectionCommand;
import jimm.datavision.gui.cmd.NewTextFieldCommand;
import jimm.datavision.gui.cmd.PaperSizeCommand;
import jimm.datavision.gui.cmd.PasteCommand;
import jimm.datavision.gui.sql.DbConnWin;
import jimm.datavision.gui.sql.SQLQueryWin;
import jimm.datavision.gui.sql.SubreportWin;
import jimm.datavision.gui.sql.VisTableWin;
import jimm.datavision.gui.sql.WhereClauseWin;
import jimm.datavision.layout.swing.SwingLE;
import jimm.datavision.source.DataSource;
import jimm.util.I18N;

public abstract class Designer
implements ActionListener,
Observer {
    public static final int GRID_SIZE = 8;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_BOTTOM = 2;
    public static final int ALIGN_LEFT = 3;
    public static final int ALIGN_CENTER = 4;
    public static final int ALIGN_RIGHT = 5;
    public static final int ALIGN_SNAP_TO_GRID = 6;
    public static final int SIZE_SAME_WIDTH = 0;
    public static final int SIZE_SAME_HEIGHT = 1;
    public static final int SIZE_SAME_SIZE = 2;
    protected static ArrayList designWindows = new ArrayList();
    protected static boolean exitWhenLastWindowClosed = true;
    protected static JFileChooser chooser;
    protected Report report;
    protected JFrame frame;
    protected RootPaneContainer rootPaneContainer;
    protected CommandHistory commandHistory;
    protected ArrayList sectionWidgets;
    protected String reportFilePath;
    protected JLayeredPane sectionContainer;
    protected ArrayList selectedFields;
    protected JScrollPane scroller;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem cutItem;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem delSelectionItem;
    protected JMenuItem delGroupItem;
    protected JMenuItem delSectionItem;
    protected JMenuItem aggrItem;
    protected JMenuItem groupItem;
    protected JMenuItem sectItem;
    protected JMenuItem formatItem;
    protected JMenuItem borderItem;
    protected JMenuItem boundsItem;
    protected JMenuItem defaultFormatItem;
    protected JMenuItem tableJoinItem;
    protected JMenuItem sqlQueryTextItem;
    protected JMenuItem connectionItem;
    protected JMenuItem selectRecordsItem;
    protected JMenuItem sortByItem;
    protected JMenuItem groupByItem;
    protected JMenuItem runItem;
    protected JMenuItem exportItem;
    protected JMenuItem subreportItem;
    protected JMenu alignSubmenu;
    protected JMenu sizeSubmenu;
    protected JMenu paperSizeSubmenu;
    protected boolean placingNewTextField;
    protected boolean ignoreKeys;

    public static void addWindow(Designer designer) {
        designWindows.add(designer);
    }

    public static Designer findWindowFor(Report report) {
        Iterator iterator = designWindows.iterator();
        while (iterator.hasNext()) {
            Designer designer = (Designer)iterator.next();
            if (designer.report != report) continue;
            return designer;
        }
        return null;
    }

    public static void setExitWhenLastWinClosed(boolean bl) {
        exitWhenLastWindowClosed = bl;
    }

    protected static void deleteWindow(Designer designer) {
        designWindows.remove(designer);
        if (designWindows.isEmpty() && exitWhenLastWindowClosed) {
            System.exit(0);
        }
    }

    protected static void maybeQuit() {
        ArrayList arrayList = (ArrayList)designWindows.clone();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((Designer)iterator.next()).maybeClose();
        }
    }

    public static JFileChooser getChooser() {
        if (chooser == null) {
            chooser = new JFileChooser();
        }
        return chooser;
    }

    public Designer(File file, String string, RootPaneContainer rootPaneContainer, JFrame jFrame) {
        this.frame = jFrame;
        this.rootPaneContainer = rootPaneContainer;
        if (this.frame != null && this.rootPaneContainer == null) {
            this.rootPaneContainer = this.frame;
        }
        ErrorHandler.useGUI(true);
        this.selectedFields = new ArrayList();
        this.commandHistory = new CommandHistory();
        StatusDialog statusDialog = new StatusDialog((Frame)this.frame, I18N.get("DesignWin.status_title"), false, file == null ? I18N.get("DesignWin.creating_empty") : I18N.get("DesignWin.reading_xml"));
        boolean bl = this.readReport(file, string);
        if (this.report == null || this.report.getDataSource() == null && !bl) {
            statusDialog.dispose();
            this.closeMe();
            Designer.deleteWindow(this);
            return;
        }
        if (bl) {
            this.openDbConnWin(true);
            if (this.report.getDataSource() == null) {
                statusDialog.dispose();
                this.closeMe();
                Designer.deleteWindow(this);
                return;
            }
        }
        statusDialog.update(I18N.get("DesignWin.building_win"));
        this.buildWindow();
        this.commandHistory.setMenuItems(this.undoItem, this.redoItem);
        this.enableMenuItems();
        Designer.addWindow(this);
        FormatWin.loadFontChoices();
        statusDialog.dispose();
    }

    protected void closeMe() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public void update(Observable observable, Object object) {
        this.enableMenuItems();
    }

    public void performCommand(Command command) {
        this.commandHistory.perform(command);
    }

    public void addCommand(Command command) {
        this.commandHistory.add(command);
    }

    protected boolean readReport(File file, String string) {
        if (file != null) {
            this.reportFilePath = file.getPath();
            this.report = new Report();
            this.report.setDatabasePassword(string);
            try {
                this.report.read(file);
                return false;
            }
            catch (UserCancellationException userCancellationException) {
                this.report = null;
                return true;
            }
            catch (Exception exception) {
                ErrorHandler.error(exception);
                this.report = new Report();
                return true;
            }
        }
        this.report = new Report();
        this.reportFilePath = null;
        return true;
    }

    public void setIgnoreKeys(boolean bl) {
        this.ignoreKeys = bl;
    }

    protected void buildWindow() {
        this.rootPaneContainer.getRootPane().setJMenuBar(this.buildMenuBar());
        this.buildSections();
    }

    protected JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildEditMenu());
        jMenuBar.add(this.buildInsertMenu());
        jMenuBar.add(this.buildFormatMenu());
        jMenuBar.add(this.buildDatabaseMenu());
        jMenuBar.add(this.buildReportMenu());
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.buildHelpMenu());
        return jMenuBar;
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_file");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_file_new");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_file_open");
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_file_save");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_file_save_as");
        jMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.paperSizeSubmenu = MenuUtils.buildPaperSizeMenu(this, this.report.getPaperFormat(), buttonGroup, buttonGroup2);
        jMenu.add(this.paperSizeSubmenu);
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_file_close");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_file_quit");
        return jMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_edit");
        this.undoItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_undo");
        this.redoItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_redo");
        jMenu.addSeparator();
        this.cutItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_cut");
        this.copyItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_copy");
        this.pasteItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_paste");
        jMenu.addSeparator();
        this.delSelectionItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_del_fields");
        jMenu.addSeparator();
        this.delGroupItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_del_group");
        this.delSectionItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_edit_del_section");
        return jMenu;
    }

    protected JMenu buildInsertMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_insert");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_column");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_text");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_formula");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_param");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_usercol");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_special");
        this.aggrItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_aggr");
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_image");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_line");
        jMenu.addSeparator();
        this.groupItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_group");
        this.sectItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_section");
        this.subreportItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_insert_subreport");
        return jMenu;
    }

    protected JMenu buildFormatMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_format");
        this.formatItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_format_format");
        this.borderItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_format_border");
        jMenu.addSeparator();
        this.boundsItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_format_bounds");
        this.alignSubmenu = MenuUtils.buildAlignMenu(this, null);
        jMenu.add(this.alignSubmenu);
        this.sizeSubmenu = MenuUtils.buildSizeMenu(this, null);
        jMenu.add(this.sizeSubmenu);
        jMenu.addSeparator();
        this.defaultFormatItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_format_default");
        return jMenu;
    }

    protected JMenu buildDatabaseMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_database");
        this.tableJoinItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_database_linker");
        jMenu.addSeparator();
        this.sqlQueryTextItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_database_sql");
        jMenu.addSeparator();
        this.connectionItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_connection");
        return jMenu;
    }

    protected JMenu buildReportMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_report");
        this.runItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_run");
        this.exportItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_export");
        jMenu.addSeparator();
        this.selectRecordsItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_select");
        this.sortByItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_sort");
        this.groupByItem = MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_group");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_start_formula");
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_scripting_langs");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_report_summary");
        return jMenu;
    }

    protected JMenu buildHelpMenu() {
        JMenu jMenu = MenuUtils.readMenu("DesignWin.menu_help");
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_help_help");
        jMenu.addSeparator();
        MenuUtils.addToMenu((ActionListener)this, jMenu, "DesignWin.menu_help_about");
        return jMenu;
    }

    protected void buildSections() {
        Group group;
        this.rootPaneContainer.getContentPane().setLayout(new BorderLayout());
        this.sectionWidgets = new ArrayList();
        this.sectionContainer = new JLayeredPane();
        this.sectionContainer.setLayout(new DesignWinLayout());
        this.buildSectionsInArea(this.report.headers());
        this.buildSectionsInArea(this.report.pageHeaders());
        Iterator iterator = this.report.groups();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            this.buildSectionsInArea(group.headers());
        }
        this.buildSectionsInArea(this.report.details());
        iterator = this.report.groupsReversed();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            this.buildSectionsInArea(group.footers());
        }
        this.buildSectionsInArea(this.report.footers());
        this.buildSectionsInArea(this.report.pageFooters());
        this.renameSectionWidgets();
        int n = 125 + (int)this.report.getPaperFormat().getWidth();
        this.scroller = new JScrollPane(this.sectionContainer);
        this.scroller.setPreferredSize(new Dimension(n + 4, 400));
        this.rootPaneContainer.getContentPane().add((Component)this.scroller, "Center");
    }

    protected void buildSectionsInArea(SectionArea sectionArea) {
        Iterator iterator = sectionArea.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            section.addObserver(this);
            SectionWidget sectionWidget = new SectionWidget(this, section, "");
            this.sectionWidgets.add(sectionWidget);
            this.sectionContainer.add((Component)sectionWidget, JLayeredPane.PALETTE_LAYER);
        }
    }

    protected void renameSectionWidgets() {
        Group group;
        this.renameSectionWidgetsIn(this.report.headers(), I18N.get("Report.report_header"), null);
        this.renameSectionWidgetsIn(this.report.pageHeaders(), I18N.get("Report.page_header"), null);
        int n = 1;
        Iterator iterator = this.report.groups();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            this.renameSectionWidgetsIn(group.headers(), I18N.get("DesignWin.group") + " #" + n + ' ' + I18N.get("DesignWin.header"), group);
            ++n;
        }
        this.renameSectionWidgetsIn(this.report.details(), I18N.get("Report.detail"), null);
        n = 1;
        iterator = this.report.groups();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            this.renameSectionWidgetsIn(group.footers(), I18N.get("DesignWin.group") + " #" + n + ' ' + I18N.get("DesignWin.footer"), group);
            ++n;
        }
        this.renameSectionWidgetsIn(this.report.footers(), I18N.get("Report.report_footer"), null);
        this.renameSectionWidgetsIn(this.report.pageFooters(), I18N.get("Report.page_footer"), null);
    }

    protected void renameSectionWidgetsIn(SectionArea sectionArea, String string, Group group) {
        SectionWidget sectionWidget = null;
        boolean bl = false;
        int n = 0;
        Iterator iterator = sectionArea.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            SectionWidget sectionWidget2 = this.findSectionWidgetFor(section);
            if (sectionWidget == null) {
                sectionWidget2.setDisplayName(string);
                sectionWidget = sectionWidget2;
            } else {
                if (!bl) {
                    sectionWidget.setDisplayName(string + " (a)");
                    bl = true;
                }
                sectionWidget2.setDisplayName(string + " (" + (char)(97 + n) + ")");
            }
            sectionWidget2.setPopupName(group == null ? string : group.getSelectableName());
            ++n;
        }
    }

    public void enableMenuItems() {
        int n = this.countSelectedFields();
        boolean bl = n > 0;
        boolean bl2 = n > 1;
        FieldWidget fieldWidget = bl ? (FieldWidget)this.selectedFields.get(0) : null;
        DataSource dataSource = this.report.getDataSource();
        Section section = fieldWidget == null ? null : fieldWidget.getSectionWidget().getSection();
        this.cutItem.setEnabled(bl);
        this.copyItem.setEnabled(bl);
        this.pasteItem.setEnabled(!Clipboard.instance().isEmpty());
        this.delSelectionItem.setEnabled(bl);
        this.delGroupItem.setEnabled(bl && this.report.isInsideGroup(section));
        this.delSectionItem.setEnabled(bl && !this.report.isOneOfAKind(section));
        if (n == 1) {
            this.aggrItem.setEnabled(fieldWidget.getField().canBeAggregated());
        } else {
            this.aggrItem.setEnabled(false);
        }
        this.sectItem.setEnabled(bl);
        this.subreportItem.setEnabled(dataSource.canJoinTables());
        if (bl) {
            boolean bl3 = this.someSelectedFieldUsesFormat();
            this.formatItem.setEnabled(bl3);
        } else {
            this.formatItem.setEnabled(false);
        }
        this.borderItem.setEnabled(bl);
        this.boundsItem.setEnabled(bl);
        this.alignSubmenu.setEnabled(bl2);
        this.sizeSubmenu.setEnabled(bl2);
        this.tableJoinItem.setEnabled(dataSource.canJoinTables());
        this.sqlQueryTextItem.setEnabled(dataSource.isSQLGenerated());
        this.connectionItem.setEnabled(dataSource.isConnectionEditable());
        this.runItem.setEnabled(dataSource.canRunReports());
        this.exportItem.setEnabled(dataSource.canRunReports());
        this.selectRecordsItem.setEnabled(dataSource.areRecordsSelectable());
        this.sortByItem.setEnabled(dataSource.areRecordsSortable());
        this.groupByItem.setEnabled(dataSource.canGroupRecords());
    }

    public boolean someSelectedFieldUsesFormat() {
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            if (!((FieldWidget)iterator.next()).usesFormat()) continue;
            return true;
        }
        return false;
    }

    String action(String string) {
        return I18N.get("menu", "DesignWin.menu_" + string + ".action");
    }

    String action(String string, String string2) {
        return I18N.get("menu", string + ".menu_" + string2 + ".action");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equals(this.action("file_new"))) {
            this.newReport();
        } else if (string.equals(this.action("file_open"))) {
            this.openReport();
        } else if (string.equals(this.action("file_save"))) {
            this.saveReport();
        } else if (string.equals(this.action("file_save_as"))) {
            this.saveReportAs();
        } else if (string.equals(this.action("file_close"))) {
            this.maybeClose();
        } else if (string.equals(this.action("file_quit"))) {
            Designer.maybeQuit();
        } else if (string.equals(this.action("edit_undo"))) {
            this.commandHistory.undo();
        } else if (string.equals(this.action("edit_redo"))) {
            this.commandHistory.redo();
        } else if (string.equals(this.action("edit_cut"))) {
            this.commandHistory.perform(new CutCommand(this, this.selectedFields));
        } else if (string.equals(this.action("edit_copy"))) {
            this.copySelectedFields();
        } else if (string.equals(this.action("edit_paste"))) {
            this.paste();
        } else if (string.equals(this.action("edit_del_fields"))) {
            this.deleteSelectedFields();
        } else if (string.equals(this.action("edit_del_group"))) {
            FieldWidget fieldWidget = (FieldWidget)this.selectedFields.get(0);
            this.deleteGroupContaining(fieldWidget.getSectionWidget().getSection());
        } else if (string.equals(this.action("edit_del_section"))) {
            FieldWidget fieldWidget = (FieldWidget)this.selectedFields.get(0);
            this.deleteSection(fieldWidget.getSectionWidget().getSection());
        } else if (string.equals(this.action("insert_column"))) {
            this.openFieldPickerWin(0);
        } else if (string.equals(this.action("insert_text"))) {
            this.placeNewTextField();
        } else if (string.equals(this.action("insert_formula"))) {
            this.openFieldPickerWin(1);
        } else if (string.equals(this.action("insert_usercol"))) {
            this.openFieldPickerWin(3);
        } else if (string.equals(this.action("insert_param"))) {
            this.openFieldPickerWin(2);
        } else if (string.equals(this.action("insert_aggr"))) {
            this.openAggregateWin();
        } else if (string.equals(this.action("insert_special"))) {
            this.openFieldPickerWin(4);
        } else if (string.equals(this.action("insert_image"))) {
            this.createImageField();
        } else if (string.equals(this.action("insert_group"))) {
            this.openNewGroupWin();
        } else if (string.equals(this.action("insert_section"))) {
            this.insertSection();
        } else if (string.equals(this.action("insert_subreport"))) {
            this.insertSubreport();
        } else if (string.equals(this.action("format_format"))) {
            this.openFormatWin(0);
        } else if (string.equals(this.action("format_border"))) {
            this.openFormatWin(1);
        } else if (string.equals(this.action("format_bounds"))) {
            this.openBoundsWin();
        } else if (string.equals(this.action("format_default"))) {
            this.openDefaultFormatWin();
        } else if (string.equals(this.action("Align", "tops"))) {
            this.align(0);
        } else if (string.equals(this.action("Align", "middles"))) {
            this.align(1);
        } else if (string.equals(this.action("Align", "bottoms"))) {
            this.align(2);
        } else if (string.equals(this.action("Align", "lefts"))) {
            this.align(3);
        } else if (string.equals(this.action("Align", "centers"))) {
            this.align(4);
        } else if (string.equals(this.action("Align", "rights"))) {
            this.align(5);
        } else if (string.equals(this.action("Align", "snap"))) {
            this.align(6);
        } else if (string.equals(this.action("Size", "same_width"))) {
            this.size(0);
        } else if (string.equals(this.action("Size", "same_height"))) {
            this.size(1);
        } else if (string.equals(this.action("Size", "same_size"))) {
            this.size(2);
        } else if (string.equals(this.action("database_linker"))) {
            this.openVisTableWin();
        } else if (string.equals(this.action("database_sql"))) {
            this.showSQL();
        } else if (string.equals(this.action("connection"))) {
            this.openDbConnWin(false);
        } else if (string.equals(this.action("report_run"))) {
            this.runReport();
        } else if (string.equals(this.action("report_export"))) {
            this.exportReport();
        } else if (string.equals(this.action("report_select"))) {
            this.openWhereClauseEditor();
        } else if (string.equals(this.action("report_sort"))) {
            this.openSortWin();
        } else if (string.equals(this.action("report_group"))) {
            this.openGroupWin();
        } else if (string.equals(this.action("report_start_formula"))) {
            this.openStartupScriptEditor();
        } else if (string.equals(this.action("report_scripting_langs"))) {
            this.openScriptingWin();
        } else if (string.equals(this.action("report_summary"))) {
            this.openDescripWin();
        } else if (string.equals(this.action("help_help"))) {
            this.help();
        } else if (string.equals(this.action("help_about"))) {
            this.about();
        } else if (string.equals(this.action("MenuUtils", "paper_size_portrait"))) {
            this.changePaperOrientation(0);
        } else if (string.equals(this.action("MenuUtils", "paper_size_landscape"))) {
            this.changePaperOrientation(1);
        } else {
            PaperFormat paperFormat = PaperFormat.get(this.report.getPaperFormat().getOrientation(), string);
            this.changePaperSize(paperFormat);
        }
    }

    protected void changePaperOrientation(int n) {
        this.changePaperSize(PaperFormat.get(n, this.report.getPaperFormat().getName()));
    }

    protected void changePaperSize(PaperFormat paperFormat) {
        if (paperFormat != null) {
            this.performCommand(new PaperSizeCommand(this.report, this, paperFormat));
        }
    }

    public void updatePaperSizeMenu(PaperFormat paperFormat) {
        this.paperSizeSubmenu.getItem(paperFormat.getOrientation() == 0 ? 0 : 1).setSelected(true);
        int n = 3;
        Iterator iterator = PaperFormat.names();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(paperFormat.getName())) {
                this.paperSizeSubmenu.getItem(n).setSelected(true);
            }
            ++n;
        }
    }

    public void paperSizeChanged(PaperFormat paperFormat) {
        Object object = this.sectionWidgets.iterator();
        while (object.hasNext()) {
            ((SectionWidget)object.next()).paperSizeChanged();
        }
        object = new Dimension(125 + (int)this.report.getPaperFormat().getWidth(), this.sectionContainer.getHeight());
        this.sectionContainer.setPreferredSize((Dimension)object);
        this.sectionContainer.invalidate();
        this.rootPaneContainer.getRootPane().validate();
        this.updatePaperSizeMenu(paperFormat);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void invalidate() {
        this.rootPaneContainer.getRootPane().invalidate();
    }

    public Report getReport() {
        return this.report;
    }

    protected void newReport() {
        new DesignWin(null);
    }

    protected void openReport() {
        int n = Designer.getChooser().showOpenDialog(this.frame);
        if (n == 0) {
            new DesignWin(Designer.getChooser().getSelectedFile());
        }
    }

    protected void saveReport() {
        if (this.reportFilePath == null) {
            this.saveReportAs();
        } else {
            this.writeReportFile(this.reportFilePath);
        }
    }

    protected void saveReportAs() {
        int n = Designer.getChooser().showSaveDialog(this.frame);
        if (n == 0) {
            this.reportFilePath = Designer.getChooser().getSelectedFile().getPath();
            this.writeReportFile(this.reportFilePath);
        }
    }

    protected void writeReportFile(String string) {
        this.report.writeFile(string);
        this.commandHistory.setBaseline();
    }

    protected void exportReport() {
        new ExportWin(this.getFrame(), this.report);
    }

    protected void maybeClose() {
        if (this.commandHistory.isChanged()) {
            String string = I18N.get("DesignWin.save_question");
            switch (JOptionPane.showConfirmDialog(this.frame, string)) {
                case 0: {
                    this.saveReport();
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.closeMe();
        Designer.deleteWindow(this);
    }

    protected void runReport() {
        this.report.setLayoutEngine(new SwingLE());
        this.report.run();
    }

    int countSelectedFields() {
        return this.selectedFields.size();
    }

    void withWidgetsDo(FieldWidgetWalker fieldWidgetWalker) {
        Iterator iterator = this.sectionWidgets.iterator();
        while (iterator.hasNext()) {
            SectionWidget sectionWidget = (SectionWidget)iterator.next();
            Component[] componentArray = sectionWidget.fieldPanel.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                FieldWidget fieldWidget = FieldWidget.findFieldWidgetOwning(componentArray[i]);
                if (fieldWidget == null) continue;
                fieldWidgetWalker.step(fieldWidget);
            }
        }
    }

    void withSelectedFieldsDo(FieldWalker fieldWalker) {
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            fieldWalker.step(((FieldWidget)iterator.next()).getField());
        }
    }

    void deleteGroupContaining(Section section) {
        Group group = this.report.findGroup(section);
        if (group != null) {
            this.commandHistory.perform(new DeleteGroupCommand(this, this.report, group));
        }
    }

    void insertSection() {
        Field field = this.firstSelectedFieldWidget().getField();
        if (field != null) {
            this.insertSectionBelow(field.getSection());
        }
    }

    void insertSectionBelow(Section section) {
        this.commandHistory.perform(new NewSectionCommand(this, this.report, section));
    }

    public void insertSectionWidgetAfter(SectionWidget sectionWidget, SectionWidget sectionWidget2) {
        int n = this.sectionWidgets.indexOf(sectionWidget2);
        this.sectionWidgets.add(n + 1, sectionWidget);
        this.sectionContainer.add(sectionWidget, JLayeredPane.PALETTE_LAYER, n + 1);
        sectionWidget.getSection().addObserver(this);
        this.renameSectionWidgets();
    }

    public void deleteSection(Section section) {
        if (section != null && !this.report.isOneOfAKind(section)) {
            this.commandHistory.perform(new DeleteSectionCommand(this, this.report, section));
        }
    }

    public SectionWidget doDeleteSection(Section section) {
        SectionWidget sectionWidget = this.findSectionWidgetFor(section);
        int n = this.sectionWidgets.indexOf(sectionWidget);
        SectionWidget sectionWidget2 = n == 0 ? null : (SectionWidget)this.sectionWidgets.get(n - 1);
        section.deleteObserver(this);
        this.report.removeSection(section);
        this.sectionContainer.remove(sectionWidget);
        this.sectionWidgets.remove(sectionWidget);
        this.renameSectionWidgets();
        return sectionWidget2;
    }

    protected void insertSubreport() {
        new SubreportWin(this, this.report);
    }

    public void rebuildGroups() {
        this.deselectAll();
        this.rootPaneContainer.getContentPane().remove(this.scroller);
        this.buildSections();
        if (this.frame != null) {
            this.frame.pack();
        }
    }

    public FieldWidget addTitleField(int n, int n2, String string) {
        Section section = this.report.getFirstSectionByArea(2);
        Field field = Field.create(null, this.report, section, "text", string, true);
        Rectangle rectangle = field.getBounds();
        rectangle.setBounds(n, 0.0, n2, 16.0);
        field.getFormat().setBold(true);
        field.getFormat().setUnderline(true);
        section.addField(field);
        TextFieldWidget textFieldWidget = new TextFieldWidget(null, field);
        textFieldWidget.moveToSection(this.findSectionWidgetFor(section));
        return textFieldWidget;
    }

    protected void align(int n) {
        if (this.selectedFields.isEmpty()) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand(I18N.get("FieldAlignCommand.name"));
        Field field = this.firstSelectedFieldWidget().getField();
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            compoundCommand.add(new FieldAlignCommand((FieldWidget)iterator.next(), n, field));
        }
        this.commandHistory.perform(compoundCommand);
    }

    protected void size(int n) {
        if (this.selectedFields.isEmpty()) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand(I18N.get("FieldResizeCommand.name"));
        Field field = this.firstSelectedFieldWidget().getField();
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            compoundCommand.add(new FieldResizeCommand((FieldWidget)iterator.next(), n, field));
        }
        this.commandHistory.perform(compoundCommand);
    }

    FieldWidget firstSelectedFieldWidget() {
        return this.selectedFields.isEmpty() ? null : (FieldWidget)this.selectedFields.get(0);
    }

    public void select(FieldWidget fieldWidget, boolean bl, boolean bl2) {
        if (bl2) {
            this.deselectAll();
        }
        fieldWidget.doSelect(bl);
        if (bl) {
            if (!this.selectedFields.contains(fieldWidget)) {
                this.selectedFields.add(fieldWidget);
            }
        } else {
            this.selectedFields.remove(fieldWidget);
        }
        this.enableMenuItems();
    }

    public void deselectAll() {
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            ((FieldWidget)iterator.next()).doSelect(false);
        }
        this.selectedFields.clear();
        this.enableMenuItems();
    }

    protected void copySelectedFields() {
        ArrayList<FieldClipping> arrayList = new ArrayList<FieldClipping>();
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new FieldClipping((FieldWidget)iterator.next()));
        }
        Clipboard.instance().setContents(arrayList);
        this.pasteItem.setEnabled(true);
    }

    protected void paste() {
        CompoundCommand compoundCommand = new CompoundCommand(I18N.get("PasteCommand.name"));
        if (this.selectedFields.size() > 0) {
            compoundCommand.add(new DeleteCommand(this, this.selectedFields));
        }
        compoundCommand.add(new PasteCommand(this));
        this.commandHistory.perform(compoundCommand);
    }

    protected void deleteSelectedFields() {
        this.deleteSelectedFieldsAnd(null);
    }

    protected void deleteSelectedFieldsAnd(FieldWidget fieldWidget) {
        ArrayList<FieldWidget> arrayList = new ArrayList<FieldWidget>(this.selectedFields);
        if (fieldWidget != null && !arrayList.contains(fieldWidget)) {
            arrayList.add(fieldWidget);
        }
        this.commandHistory.perform(new DeleteCommand(this, arrayList));
    }

    void setFieldVisibility(boolean bl, FieldWidget fieldWidget) {
        if (this.selectedFields.isEmpty() && fieldWidget == null) {
            return;
        }
        String string = bl ? "FieldShowCommand.name" : "FieldHideCommand.name";
        CompoundCommand compoundCommand = new CompoundCommand(I18N.get(string));
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            compoundCommand.add(new FieldShowHideCommand((FieldWidget)iterator.next(), string, bl));
        }
        if (fieldWidget != null && !this.selectedFields.contains(fieldWidget)) {
            compoundCommand.add(new FieldShowHideCommand(fieldWidget, string, bl));
        }
        this.commandHistory.perform(compoundCommand);
    }

    void createNewTextField(SectionWidget sectionWidget, MouseEvent mouseEvent) {
        this.commandHistory.perform(new NewTextFieldCommand(sectionWidget, mouseEvent));
        this.acceptNewTextField();
    }

    void pickUp(Point point) {
        Dimension dimension = this.sectionContainer.getBounds().getSize();
        this.sectionContainer.setPreferredSize(dimension);
        this.sectionContainer.setMinimumSize(dimension);
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            FieldWidget fieldWidget = (FieldWidget)iterator.next();
            fieldWidget.pickUp(point);
            this.sectionContainer.add((Component)fieldWidget.getComponent(), JLayeredPane.DRAG_LAYER);
            Rectangle rectangle = fieldWidget.getField().getBounds();
            rectangle.setBounds(rectangle.x + 125.0, rectangle.y + (double)fieldWidget.getSectionWidget().getBounds().y, rectangle.width, rectangle.height);
        }
    }

    void putDown(FieldWidget fieldWidget, Point point, Point point2) {
        Object object = this.selectedFields.iterator();
        while (object.hasNext()) {
            this.sectionContainer.setLayer(((FieldWidget)object.next()).getComponent(), JLayeredPane.DEFAULT_LAYER);
        }
        object = new CompoundCommand(I18N.get("FieldMoveCommand.name"));
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            FieldWidget fieldWidget2 = (FieldWidget)iterator.next();
            SectionWidget sectionWidget = this.getSectionWidgetUnder(fieldWidget2.getComponent().getLocationOnScreen());
            if (sectionWidget == null) {
                fieldWidget2.snapBack();
                continue;
            }
            ((CompoundCommand)object).add(new FieldMoveCommand(fieldWidget2, sectionWidget));
        }
        if (((CompoundCommand)object).numCommands() > 0) {
            this.commandHistory.perform((Command)object);
        }
    }

    void startStretching(Point point) {
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            FieldWidget fieldWidget = (FieldWidget)iterator.next();
            fieldWidget.startStretching(point);
        }
    }

    void stopStretching(FieldWidget fieldWidget, Rectangle rectangle) {
        CompoundCommand compoundCommand = new CompoundCommand(I18N.get("FieldStretchCommand.name"));
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            FieldWidget fieldWidget2 = (FieldWidget)iterator.next();
            compoundCommand.add(new FieldStretchCommand(fieldWidget2, rectangle));
            fieldWidget2.stopStretching();
        }
        if (compoundCommand.numCommands() > 0) {
            this.commandHistory.perform(compoundCommand);
        }
    }

    protected SectionWidget getSectionWidgetUnder(Point point) {
        Component component;
        Point point2 = this.sectionContainer.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        if (point3.x < 125) {
            return null;
        }
        for (component = this.sectionContainer.getComponentAt(point3); component != null && !(component instanceof SectionWidget); component = component.getParent()) {
        }
        return (SectionWidget)component;
    }

    protected void dragSelectedWidgets(int n, Point point) {
        Iterator iterator = this.selectedFields.iterator();
        while (iterator.hasNext()) {
            ((FieldWidget)iterator.next()).doDrag(n, point);
        }
    }

    protected void openFieldPickerWin(int n) {
        new FieldPickerWin(this, this.report, n);
    }

    protected void openAggregateWin() {
        new AggregatesWin(this, (FieldWidget)this.selectedFields.get(0));
    }

    protected void createImageField() {
        String string = new AskStringDialog((Frame)this.frame, I18N.get("DesignWin.image_url_title"), I18N.get("DesignWin.image_url_label")).getString();
        if (string != null) {
            Section section = this.report.getFirstSectionByArea(0);
            NewImageFieldCommand newImageFieldCommand = new NewImageFieldCommand(this.findSectionWidgetFor(section), string);
            this.commandHistory.perform(newImageFieldCommand);
        }
    }

    protected void openNewGroupWin() {
        new NewGroupWin(this, this.report);
    }

    protected void placeNewTextField() {
        this.placingNewTextField = true;
        this.rootPaneContainer.getRootPane().setCursor(Cursor.getPredefinedCursor(2));
    }

    boolean isPlacingNewTextField() {
        return this.placingNewTextField;
    }

    void acceptNewTextField() {
        this.placingNewTextField = false;
        this.rootPaneContainer.getRootPane().setCursor(null);
    }

    void rejectNewTextField() {
        this.acceptNewTextField();
    }

    protected void openFormatWin(int n) {
        FieldWidget fieldWidget = this.firstSelectedFieldWidget();
        if (fieldWidget != null) {
            new FormatWin(this, fieldWidget.getField(), n);
        }
    }

    protected void openDefaultFormatWin() {
        new FormatWin(this, this.report.getDefaultField(), 0);
    }

    protected void openBoundsWin() {
        FieldWidget fieldWidget = this.firstSelectedFieldWidget();
        if (fieldWidget != null) {
            new BoundsWin(this, fieldWidget.getField());
        }
    }

    protected void openVisTableWin() {
        new VisTableWin(this, this.report);
    }

    protected void openWhereClauseEditor() {
        new WhereClauseWin(this, this.report);
    }

    protected void openSortWin() {
        new SortWin(this, this.report);
    }

    protected void openGroupWin() {
        new GroupWin(this, this.report);
    }

    protected void openStartupScriptEditor() {
        new StartupScriptEditor(this, this.report);
    }

    protected void openScriptingWin() {
        new ScriptingWin(this, this.report.getScripting());
    }

    protected void openDescripWin() {
        new DescripWin(this, this.report);
    }

    protected void help() {
        HelpWin helpWin = HelpWin.instance();
        helpWin.setState(0);
        helpWin.setVisible(true);
        helpWin.toFront();
    }

    protected void about() {
        String string = I18N.get("DesignWin.about_1") + "1.0.0" + "\n" + I18N.get("DesignWin.about_2") + "\n" + "http://datavision.sourceforge.net" + "\n\n" + "Copyright (c) 2001-2005 Jim Menard, jimm@io.com" + ".\n\n" + I18N.get("DesignWin.about_3");
        JOptionPane.showMessageDialog(null, string, I18N.get("DesignWin.about_title"), -1);
    }

    protected void openDbConnWin(boolean bl) {
        new DbConnWin(this, this.report, bl);
    }

    protected void showSQL() {
        new SQLQueryWin((Frame)this.frame, this.report.getDataSource().getQuery().toString());
    }

    public SectionWidget findSectionWidgetFor(Section section) {
        Iterator iterator = this.sectionWidgets.iterator();
        while (iterator.hasNext()) {
            SectionWidget sectionWidget = (SectionWidget)iterator.next();
            if (sectionWidget.section != section) continue;
            return sectionWidget;
        }
        return null;
    }

    public void snapToGrid(Rectangle rectangle) {
        int n = (int)rectangle.x;
        int n2 = n % 8;
        if (n2 != 0) {
            if (n2 <= 4) {
                rectangle.setX(n - n2);
            } else {
                rectangle.setX(n + 8 - n2);
            }
        }
        if ((n2 = (n = (int)rectangle.y) % 8) != 0) {
            if (n2 < 4) {
                rectangle.setY(n - n2);
            } else {
                rectangle.setY(n + 8 - n2);
            }
        }
    }
}

