/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditFieldLayout;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.cmd.SummaryCommand;
import jimm.util.I18N;

public class DescripWin
extends EditWin {
    protected static final int TEXT_FIELD_COLS = 32;
    protected static final int TEXT_AREA_ROWS = 6;
    protected static final int TEXT_AREA_COLS = 32;
    protected Report report;
    protected JTextField nameField;
    protected JTextField titleField;
    protected JTextField authorField;
    protected JTextArea descriptionField;

    public DescripWin(Designer designer, Report report) {
        super(designer, I18N.get("DescripWin.title"), "SummaryCommand.name");
        this.report = report;
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        JPanel jPanel = this.buildEditor();
        JPanel jPanel2 = this.closeButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
    }

    protected JPanel buildEditor() {
        EditFieldLayout editFieldLayout = new EditFieldLayout();
        this.nameField = editFieldLayout.addTextField(I18N.get("DescripWin.report_name"), this.report.getName(), 32);
        this.titleField = editFieldLayout.addTextField(I18N.get("DescripWin.report_title"), this.report.getTitle(), 32);
        this.authorField = editFieldLayout.addTextField(I18N.get("DescripWin.author_name"), this.report.getAuthor(), 32);
        this.descriptionField = editFieldLayout.addTextArea(I18N.get("DescripWin.description"), this.report.getDescription(), 6, 32);
        return editFieldLayout.getPanel();
    }

    protected void fillEditFields() {
        this.nameField.setText(this.report.getName());
        this.titleField.setText(this.report.getTitle());
        this.authorField.setText(this.report.getAuthor());
        this.descriptionField.setText(this.report.getDescription());
    }

    protected void doSave() {
        SummaryCommand summaryCommand = new SummaryCommand(this.report, this.nameField.getText(), this.titleField.getText(), this.authorField.getText(), this.descriptionField.getText());
        summaryCommand.perform();
        this.commands.add(summaryCommand);
    }

    protected void doRevert() {
        this.fillEditFields();
    }
}

