/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.DropListenerTextArea;
import jimm.datavision.gui.FocusSetter;
import jimm.datavision.gui.cmd.Command;
import jimm.util.I18N;

public abstract class CodeEditorWin
extends JDialog
implements ActionListener {
    protected static final Dimension EDIT_SIZE = new Dimension(400, 225);
    protected Designer designer;
    protected JTextArea codeField;
    protected Command command;
    protected String errorSuffix;
    protected String errorTitle;

    public CodeEditorWin(Designer designer, Report report, String string, String string2, String string3, String string4) {
        super(designer.getFrame(), string2);
        this.designer = designer;
        this.errorSuffix = string3 == null ? null : I18N.get(string3);
        this.errorTitle = string4 == null ? null : I18N.get(string4);
        this.buildWindow(report, string);
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow(Report report, String string) {
        this.codeField = new DropListenerTextArea(report, string == null ? "" : string);
        JScrollPane jScrollPane = new JScrollPane(this.codeField);
        jScrollPane.setPreferredSize(EDIT_SIZE);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        new FocusSetter(this.codeField);
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("GUI.ok"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        jButton = new JButton(I18N.get("GUI.cancel"));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (I18N.get("GUI.ok").equals(string)) {
                this.save(this.codeField.getText());
                if (this.command != null) {
                    this.designer.performCommand(this.command);
                }
                this.dispose();
            } else if (I18N.get("GUI.cancel").equals(string)) {
                this.dispose();
            }
        }
        catch (Exception exception) {
            String string2 = exception.toString();
            if (this.errorSuffix != null) {
                string2 = string2 + "\n" + this.errorSuffix;
            }
            ErrorHandler.error(string2, this.errorTitle);
            this.command = null;
        }
    }

    public abstract void save(String var1);
}

