/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jimm.datavision.FieldWalker;
import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.cmd.BoundsCommand;
import jimm.util.I18N;

public class BoundsWin
extends EditWin
implements FieldWalker {
    protected static final int TEXT_FIELD_COLS = 8;
    protected Field field;
    protected Rectangle origBounds;
    protected Rectangle fieldBounds;
    protected JTextField x_text;
    protected JTextField y_text;
    protected JTextField w_text;
    protected JTextField h_text;

    public BoundsWin(Designer designer, Field field) {
        super(designer, I18N.get("BoundsWin.title"), "BoundsCommand.name");
        this.field = field;
        this.origBounds = this.field.getBounds();
        this.fieldBounds = new Rectangle(this.origBounds);
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        JPanel jPanel = this.buildBoundsEditor();
        JPanel jPanel2 = this.closeButtonPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
    }

    protected JPanel buildBoundsEditor() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.x_text = this.addCoord(jPanel, I18N.get("BoundsWin.x"), this.fieldBounds.x, "West");
        this.y_text = this.addCoord(jPanel, I18N.get("BoundsWin.y"), this.fieldBounds.y, "North");
        this.w_text = this.addCoord(jPanel, I18N.get("BoundsWin.width"), this.fieldBounds.width, "East");
        this.h_text = this.addCoord(jPanel, I18N.get("BoundsWin.height"), this.fieldBounds.height, "South");
        return jPanel;
    }

    protected JTextField addCoord(JPanel jPanel, String string, double d, String string2) {
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(string));
        JTextField jTextField = new JTextField("" + d, 8);
        jPanel2.add(jTextField);
        jPanel.add((Component)jPanel2, string2);
        return jTextField;
    }

    protected void fillCoords(Rectangle rectangle) {
        this.x_text.setText("" + rectangle.x);
        this.y_text.setText("" + rectangle.y);
        this.w_text.setText("" + rectangle.width);
        this.h_text.setText("" + rectangle.height);
    }

    protected void doSave() {
        this.fieldBounds.setBounds(Double.parseDouble(this.x_text.getText()), Double.parseDouble(this.y_text.getText()), Double.parseDouble(this.w_text.getText()), Double.parseDouble(this.h_text.getText()));
        if (this.designer.countSelectedFields() == 0 || this.field == this.field.getReport().getDefaultField()) {
            this.step(this.field);
        } else {
            this.designer.withSelectedFieldsDo(this);
        }
    }

    public void step(Field field) {
        BoundsCommand boundsCommand = new BoundsCommand(field, this.fieldBounds);
        boundsCommand.perform();
        this.commands.add(boundsCommand);
    }

    protected void doRevert() {
        this.fillCoords(this.origBounds);
    }
}

