/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jimm.datavision.Group;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.Writeable;
import jimm.datavision.field.AggregateField;
import jimm.datavision.field.Field;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.FieldWidgetWalker;
import jimm.datavision.gui.cmd.AbstractAggregateCommand;
import jimm.datavision.gui.cmd.CommandAdapter;
import jimm.datavision.gui.cmd.DeleteAggregateCommand;
import jimm.datavision.gui.cmd.EditAggregateFuncCommand;
import jimm.datavision.gui.cmd.NewAggregateCommand;
import jimm.util.I18N;

public class AggregatesWin
extends EditWin {
    protected static final int TEXT_FIELD_COLS = 8;
    protected Report report;
    protected FieldWidget fieldWidget;
    protected HashMap slots;

    public AggregatesWin(Designer designer, FieldWidget fieldWidget) {
        super(designer, I18N.get("AggregatesWin.title_prefix") + ' ' + fieldWidget, "AggregatesWin.command_name");
        FieldWidget[] fieldWidgetArray;
        Cloneable cloneable;
        this.fieldWidget = fieldWidget;
        this.report = designer.report;
        if (this.fieldWidget.getField() instanceof AggregateField) {
            cloneable = this.getAggregateField().getField();
            fieldWidgetArray = new FieldWidget[1];
            designer.withWidgetsDo(new FieldWidgetWalker((Field)cloneable, fieldWidgetArray){
                private final /* synthetic */ Field val$fieldToAggregate;
                private final /* synthetic */ FieldWidget[] val$list;
                {
                    this.val$fieldToAggregate = field;
                    this.val$list = fieldWidgetArray;
                }

                public void step(FieldWidget fieldWidget) {
                    Field field = fieldWidget.getField();
                    if (field == this.val$fieldToAggregate) {
                        this.val$list[0] = fieldWidget;
                    }
                }
            });
            this.fieldWidget = fieldWidgetArray[0];
            this.setTitle(I18N.get("AggregatesWin.title_prefix") + ' ' + this.fieldWidget);
        }
        cloneable = new HashMap();
        fieldWidgetArray = designer.report.getAggregateFieldsFor(this.fieldWidget.getField());
        designer.withWidgetsDo(new FieldWidgetWalker((AbstractList)fieldWidgetArray, (HashMap)cloneable){
            private final /* synthetic */ AbstractList val$subs;
            private final /* synthetic */ HashMap val$aggregates;
            {
                this.val$subs = abstractList;
                this.val$aggregates = hashMap;
            }

            public void step(FieldWidget fieldWidget) {
                Field field = fieldWidget.getField();
                if (this.val$subs.contains(field)) {
                    Writeable writeable = ((AggregateField)field).getGroup();
                    if (writeable == null) {
                        writeable = fieldWidget.getField().getSection();
                    }
                    this.val$aggregates.put(writeable, fieldWidget);
                }
            }
        });
        this.buildWindow((HashMap)cloneable);
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow(HashMap hashMap) {
        JPanel jPanel = this.buildAggregatesEditor(hashMap);
        JPanel jPanel2 = this.closeButtonPanel();
        this.getContentPane().add((Component)new JLabel(I18N.get("AggregatesWin.title_prefix") + ' ' + this.fieldWidget), "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
    }

    protected JPanel buildAggregatesEditor(HashMap hashMap) {
        Object object;
        Object object2;
        Object[] objectArray = AggregateField.functionNameArray();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JCheckBox jCheckBox = null;
        JComboBox<Object> jComboBox = null;
        this.slots = new HashMap();
        int n = this.report.countGroups();
        Iterator iterator = this.report.groupsReversed();
        while (iterator.hasNext()) {
            object2 = (Group)iterator.next();
            object = (FieldWidget)hashMap.get(object2);
            jCheckBox = new JCheckBox(I18N.get("AggregatesWin.group") + " #" + n + " (" + ((Group)object2).getSelectableName() + ")");
            jPanel.add(jCheckBox);
            jComboBox = new JComboBox<Object>(objectArray);
            jPanel.add(jComboBox);
            if (object != null) {
                jCheckBox.setSelected(true);
                jComboBox.setSelectedItem(this.getAggregateField((FieldWidget)object).getFunction());
            }
            this.slots.put(object2, new Slot((FieldWidget)object, jCheckBox, jComboBox));
            --n;
        }
        jCheckBox = new JCheckBox(I18N.get("AggregatesWin.grand_total"));
        jPanel.add(jCheckBox);
        jComboBox = new JComboBox<Object>(objectArray);
        jPanel.add(jComboBox);
        boolean bl = false;
        object2 = this.report.footers().iterator();
        while (object2.hasNext() && !bl) {
            object = (Section)object2.next();
            FieldWidget fieldWidget = (FieldWidget)hashMap.get(object);
            if (fieldWidget == null) continue;
            jCheckBox.setSelected(true);
            jComboBox.setSelectedItem(this.getAggregateField(fieldWidget).getFunction());
            this.slots.put(null, new Slot(fieldWidget, jCheckBox, jComboBox));
            bl = true;
        }
        if (!bl) {
            this.slots.put(null, new Slot(null, jCheckBox, jComboBox));
        }
        object2 = new JButton(I18N.get("GUI.all"));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = AggregatesWin.this.slots.values().iterator();
                while (iterator.hasNext()) {
                    ((Slot)iterator.next()).checkBox.setSelected(true);
                }
            }
        });
        object = new JPanel();
        ((Container)object).add((Component)object2);
        jPanel.add((Component)object);
        return jPanel;
    }

    protected AggregateField getAggregateField() {
        return this.getAggregateField(this.fieldWidget);
    }

    protected AggregateField getAggregateField(FieldWidget fieldWidget) {
        return (AggregateField)fieldWidget.getField();
    }

    protected void doSave() {
        Iterator iterator = this.slots.keySet().iterator();
        while (iterator.hasNext()) {
            CommandAdapter commandAdapter;
            String string;
            Object k = iterator.next();
            Slot slot = (Slot)this.slots.get(k);
            if (slot.checkBox.isSelected()) {
                string = slot.functionMenu.getSelectedItem().toString();
                if (slot.aggregate == null) {
                    commandAdapter = new NewAggregateCommand(this.report, this.fieldWidget, (Group)k, string);
                    ((NewAggregateCommand)commandAdapter).perform();
                    this.commands.add(commandAdapter);
                    slot.aggregate = ((AbstractAggregateCommand)commandAdapter).getAggregateWidget();
                    continue;
                }
                commandAdapter = new EditAggregateFuncCommand(this.getAggregateField(slot.aggregate), string);
                ((EditAggregateFuncCommand)commandAdapter).perform();
                this.commands.add(commandAdapter);
                this.getAggregateField(slot.aggregate).setFunction(string);
                continue;
            }
            if (slot.aggregate == null) continue;
            string = this.getAggregateField(slot.aggregate).getFunction();
            commandAdapter = new DeleteAggregateCommand(this.report, this.fieldWidget, slot.aggregate, string, (Group)k);
            ((DeleteAggregateCommand)commandAdapter).perform();
            this.commands.add(commandAdapter);
            slot.aggregate = null;
        }
    }

    protected void doRevert() {
        Iterator iterator = this.slots.keySet().iterator();
        while (iterator.hasNext()) {
            Slot slot = (Slot)this.slots.get(iterator.next());
            Container container = slot.aggregate.getComponent().getParent();
            if (slot.existedAlready) {
                slot.aggregate.getComponent().setVisible(true);
                slot.checkBox.setSelected(true);
            } else {
                if (slot.aggregate != null) {
                    slot.aggregate.doDelete();
                    slot.aggregate = null;
                }
                slot.checkBox.setSelected(false);
            }
            container.repaint();
        }
    }

    static class Slot {
        FieldWidget aggregate;
        boolean existedAlready;
        JCheckBox checkBox;
        JComboBox functionMenu;

        Slot(FieldWidget fieldWidget, JCheckBox jCheckBox, JComboBox jComboBox) {
            this.existedAlready = fieldWidget != null;
            this.aggregate = fieldWidget;
            this.checkBox = jCheckBox;
            this.functionMenu = jComboBox;
        }
    }
}

