/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.UserColumn;
import jimm.datavision.field.Field;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.datavision.gui.UserColumnWidget;

public class UserColumnField
extends Field
implements Observer {
    protected UserColumn usercol;

    public UserColumnField(Long l, Report report, Section section, Object object, boolean bl) {
        super(l, report, section, object, bl);
        this.usercol = report.findUserColumn(object);
        this.usercol.addObserver(this);
    }

    protected void finalize() throws Throwable {
        this.usercol.deleteObserver(this);
        super.finalize();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public FieldWidget makeWidget(SectionWidget sectionWidget) {
        return new UserColumnWidget(sectionWidget, this);
    }

    public String dragString() {
        return this.typeString() + ":" + this.usercol.getId();
    }

    public UserColumn getUserColumn() {
        return this.usercol;
    }

    public void setUserColumn(UserColumn userColumn) {
        if (this.usercol != userColumn) {
            this.usercol.deleteObserver(this);
            this.usercol = userColumn;
            this.usercol.addObserver(this);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String typeString() {
        return "usercol";
    }

    public String designLabel() {
        return this.usercol.designLabel();
    }

    public String formulaString() {
        return this.usercol.formulaString();
    }

    public boolean refersTo(Field field) {
        return this.usercol.refersTo(field);
    }

    public boolean refersTo(Parameter parameter) {
        return this.usercol.refersTo(parameter);
    }

    public boolean canBeAggregated() {
        return this.section != null && this.section.isDetail();
    }

    public Object getValue() {
        return this.getReport().columnValue(this.usercol);
    }

    public Collection columnsUsed() {
        return this.usercol.columnsUsed();
    }
}

