/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.Date;
import java.util.HashMap;
import jimm.datavision.Group;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.util.I18N;

public class SpecialField
extends Field {
    public static final String TYPE_STRING = "special";

    public static HashMap specialFieldNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("report.title", I18N.get("SpecialField.report.title"));
        hashMap.put("report.name", I18N.get("SpecialField.report.name"));
        hashMap.put("report.author", I18N.get("SpecialField.report.author"));
        hashMap.put("report.description", I18N.get("SpecialField.report.description"));
        hashMap.put("report.date", I18N.get("SpecialField.report.date"));
        hashMap.put("report.row", I18N.get("SpecialField.report.row"));
        hashMap.put("page.number", I18N.get("SpecialField.page.number"));
        hashMap.put("group.count", I18N.get("SpecialField.group.count"));
        return hashMap;
    }

    public static Object value(Field field, String string, Report report) {
        if ("report.title".equals(string)) {
            return report.getTitle();
        }
        if ("report.name".equals(string)) {
            return report.getName();
        }
        if ("report.author".equals(string)) {
            return report.getAuthor();
        }
        if ("report.description".equals(string)) {
            return report.getDescription();
        }
        if ("report.date".equals(string)) {
            return new Date();
        }
        if ("report.row".equals(string)) {
            return new Integer(report.rowNumber());
        }
        if ("page.number".equals(string)) {
            return new Integer(report.pageNumber());
        }
        if ("group.count".equals(string)) {
            return SpecialField.groupCount(field);
        }
        return I18N.get("SpecialField.unknown");
    }

    protected static Integer groupCount(Field field) {
        if (field == null) {
            return new Integer(0);
        }
        Report report = field.getReport();
        Group group = report.findGroup(field.getSection());
        if (group == null && field.getSection().isDetail()) {
            group = report.innermostGroup();
        }
        return new Integer(group == null ? report.rowNumber() : group.getRecordCount());
    }

    public SpecialField(Long l, Report report, Section section, Object object, boolean bl) {
        super(l, report, section, object, bl);
    }

    public String dragString() {
        return this.typeString() + ":" + this.value;
    }

    public String typeString() {
        return TYPE_STRING;
    }

    public String designLabel() {
        return "{" + this.value + "}";
    }

    public String formulaString() {
        return "{%" + this.value + "}";
    }

    public Object getValue() {
        return SpecialField.value(this, (String)this.value, this.section.getReport());
    }
}

