/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.ParameterWidget;
import jimm.datavision.gui.SectionWidget;

public class ParameterField
extends Field
implements Observer {
    protected Parameter parameter;

    public ParameterField(Long l, Report report, Section section, Object object, boolean bl) {
        super(l, report, section, object, bl);
        this.parameter = report.findParameter(object);
        this.parameter.addObserver(this);
    }

    protected void finalize() throws Throwable {
        this.parameter.deleteObserver(this);
        super.finalize();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public FieldWidget makeWidget(SectionWidget sectionWidget) {
        return new ParameterWidget(sectionWidget, this);
    }

    public String dragString() {
        return this.typeString() + ":" + this.parameter.getId();
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        if (this.parameter != parameter) {
            this.parameter.deleteObserver(this);
            this.parameter = parameter;
            this.parameter.addObserver(this);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String typeString() {
        return "parameter";
    }

    public String designLabel() {
        return this.parameter.designLabel();
    }

    public String formulaString() {
        return this.parameter.formulaString();
    }

    public boolean refersTo(Parameter parameter) {
        return this.parameter == parameter;
    }

    public boolean canBeAggregated() {
        return this.section != null && this.section.isDetail() && this.getParameter().getType() == 2;
    }

    public Object getValue() {
        return this.parameter.getValue();
    }
}

