/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.ImageFieldWidget;
import jimm.datavision.gui.SectionWidget;

public class ImageField
extends Field {
    public static final String TYPE_STRING = "image";
    protected URL imageURL;
    protected ImageIcon imageIcon;
    protected ImageIcon hiddenImageIcon;

    public ImageField(Long l, Report report, Section section, Object object, boolean bl) {
        super(l, report, section, null, bl);
        this.setValue(object);
    }

    public double getOutputHeight() {
        return this.bounds.height;
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public ImageIcon getImageIcon() {
        if (this.isVisible()) {
            return this.getVisibleImageIcon();
        }
        return this.getHiddenImageIcon();
    }

    public ImageIcon getVisibleImageIcon() {
        if (this.imageIcon == null && this.value != null) {
            this.imageIcon = new ImageIcon(this.getImageURL());
        }
        return this.imageIcon;
    }

    public ImageIcon getHiddenImageIcon() {
        ImageIcon imageIcon;
        if (this.hiddenImageIcon == null && this.value != null && this.canLoad() && (imageIcon = this.getVisibleImageIcon()) != null) {
            this.hiddenImageIcon = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
        }
        return this.hiddenImageIcon;
    }

    public void setValue(Object object) {
        this.imageIcon = null;
        String string = object.toString();
        if (string.indexOf(":/") == -1 && !string.startsWith("file:")) {
            string = "file:" + string;
        }
        try {
            this.imageURL = string == null || string.length() == 0 ? null : new URL(string);
            super.setValue(object);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorHandler.error(malformedURLException);
        }
    }

    public boolean canLoad() {
        return this.getVisibleImageIcon() != null && this.getVisibleImageIcon().getImageLoadStatus() == 8;
    }

    public FieldWidget makeWidget(SectionWidget sectionWidget) {
        return new ImageFieldWidget(sectionWidget, this);
    }

    public String dragString() {
        return this.typeString() + ":" + this.value;
    }

    public String typeString() {
        return TYPE_STRING;
    }

    public String formulaString() {
        return "{" + this.value + "}";
    }

    public String toString() {
        if (!this.visible) {
            return null;
        }
        Object object = this.getValue();
        return object == null ? "" : object.toString();
    }
}

