/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Formula;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.UserColumn;
import jimm.datavision.field.Field;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.FormulaWidget;
import jimm.datavision.gui.SectionWidget;

public class FormulaField
extends Field
implements Observer {
    protected Formula formula;

    public FormulaField(Long l, Report report, Section section, Object object, boolean bl) {
        super(l, report, section, object, bl);
        this.formula = report.findFormula(object);
        this.formula.addObserver(this);
    }

    protected void finalize() throws Throwable {
        this.formula.deleteObserver(this);
        super.finalize();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public FieldWidget makeWidget(SectionWidget sectionWidget) {
        return new FormulaWidget(sectionWidget, this);
    }

    public String dragString() {
        return this.typeString() + ":" + this.formula.getId();
    }

    public Formula getFormula() {
        return this.formula;
    }

    public void setFormula(Formula formula) {
        if (this.formula != formula) {
            this.formula.deleteObserver(this);
            this.formula = formula;
            this.formula.addObserver(this);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String typeString() {
        return "formula";
    }

    public String designLabel() {
        return this.formula.designLabel();
    }

    public String formulaString() {
        return this.formula.formulaString();
    }

    public boolean refersTo(Field field) {
        return this.formula.refersTo(field);
    }

    public boolean refersTo(Formula formula) {
        return formula == this.formula || this.formula.refersTo(formula);
    }

    public boolean refersTo(UserColumn userColumn) {
        return this.formula.refersTo(userColumn);
    }

    public boolean refersTo(Parameter parameter) {
        return this.formula.refersTo(parameter);
    }

    public boolean canBeAggregated() {
        return this.section != null && this.section.isDetail();
    }

    public Object getValue() {
        return this.formula.eval(this);
    }

    public Collection columnsUsed() {
        return this.formula.columnsUsed();
    }

    public Collection userColumnsUsed() {
        return this.formula.userColumnsUsed();
    }
}

