/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.util.StringUtils;

class FormattedValueCache
implements Observer {
    protected static final double LINE_SIZE_FUDGE_FACTOR = 1.2;
    protected static final HashMap decimalFormatters = new HashMap();
    protected static final HashMap dateFormatters = new HashMap();
    protected static JLabel wrappingCalculationsLabel;
    protected Field field;
    protected Object value;
    protected String formatted;
    protected double height;

    FormattedValueCache(Field field) {
        this.field = field;
        if (this.field != null) {
            this.field.addObserver(this);
            if (this.field.getFormat() != null) {
                this.field.getFormat().addObserver(this);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.field != null) {
            this.field.deleteObserver(this);
            if (this.field.getFormat() != null) {
                this.field.getFormat().deleteObserver(this);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (this.field != null && this.field.getFormat() != null) {
            this.value = null;
        }
    }

    String getFormattedString(Object object) {
        if (this.notSameAs(object)) {
            this.value = object;
            this.calcValues();
        }
        return this.formatted;
    }

    double getOutputHeight(Object object) {
        if (this.notSameAs(object)) {
            this.value = object;
            this.calcValues();
        }
        return this.height;
    }

    protected boolean notSameAs(Object object) {
        if (this.value == null) {
            return object != null;
        }
        return !this.value.equals(object);
    }

    void calcValues() {
        double d;
        Object object;
        if (this.value == null) {
            this.formatted = null;
            this.height = 0.0;
            return;
        }
        Format format = this.field.getFormat();
        String string = format.getFormat();
        if (this.value instanceof Number) {
            this.formatted = string == null ? this.value.toString() : this.getNumberFormatterFor(string).format((Number)this.value);
        } else if (this.value instanceof Date) {
            this.formatted = string == null ? this.value.toString() : this.getDateFormatterFor(string).format((Date)this.value);
        } else {
            this.formatted = this.value.toString();
            if (format.isWrap()) {
                object = FormattedValueCache.getWrappingCalcsLabel().getFontMetrics(format.getFont());
                this.formatted = StringUtils.join(StringUtils.wrap(this.formatted, (FontMetrics)object, (int)this.field.getBounds().width), "\n");
            }
        }
        this.height = this.field.bounds.height;
        if (this.formatted.length() != 0 && (d = (double)(object = StringUtils.splitIntoLines(this.formatted)).size() * format.getSize() * 1.2) > this.height) {
            this.height = d;
        }
    }

    protected DecimalFormat getNumberFormatterFor(String string) {
        DecimalFormat decimalFormat = (DecimalFormat)decimalFormatters.get(string);
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat(string);
            decimalFormatters.put(string, decimalFormat);
        }
        return decimalFormat;
    }

    protected SimpleDateFormat getDateFormatterFor(String string) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormatters.get(string);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(string);
            dateFormatters.put(string, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    protected static JLabel getWrappingCalcsLabel() {
        if (wrappingCalculationsLabel == null) {
            wrappingCalculationsLabel = new JLabel();
        }
        return wrappingCalculationsLabel;
    }
}

