/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.awt.Color;
import java.awt.Font;
import java.util.Observable;
import jimm.datavision.Writeable;
import jimm.datavision.field.DefaultFormat;
import jimm.datavision.field.Field;
import jimm.util.XMLWriter;

public class Format
extends Observable
implements Writeable,
Cloneable {
    protected static final String DEFAULT_FONT_FAMILY_NAME = "Times New Roman";
    protected static final int DEFAULT_SIZE = 11;
    protected static final Color DEFAULT_COLOR = Color.black;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    protected Field field;
    protected String fontFamilyName;
    protected Double size;
    protected Boolean bold;
    protected Boolean italic;
    protected Boolean underline;
    protected Boolean wrap;
    protected Integer align;
    protected String format;
    protected Color color;
    protected Font font;

    public static int alignFromString(String string) {
        if (string == null) {
            return 0;
        }
        String string2 = string.toLowerCase();
        if ("center".equals(string2)) {
            return 1;
        }
        if ("right".equals(string2)) {
            return 2;
        }
        return 0;
    }

    public static String alignToString(int n) {
        switch (n) {
            case 2: {
                return "right";
            }
            case 1: {
                return "center";
            }
        }
        return "left";
    }

    public static Format createEmptyFormat() {
        return new Format();
    }

    public static Format createDefaultFormat() {
        return new DefaultFormat();
    }

    Format() {
    }

    void setField(Field field) {
        this.field = field;
    }

    public Object clone() {
        Format format = new Format();
        this.fillClonedField(format);
        return format;
    }

    protected void fillClonedField(Format format) {
        format.field = this.field;
        format.setFontFamilyName(this.getFontFamilyName());
        format.setSize(this.getSize());
        format.setBold(this.isBold());
        format.setItalic(this.isItalic());
        format.setUnderline(this.isUnderline());
        format.setWrap(this.isWrap());
        format.setAlign(this.getAlign());
        format.setFormat(this.getFormat());
        format.setColor(this.getColor());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Format)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Format format = (Format)object;
        return this.getSize() == format.getSize() && this.isBold() == format.isBold() && this.isItalic() == format.isItalic() && this.isUnderline() == format.isUnderline() && this.isWrap() == format.isWrap() && this.getAlign() == format.getAlign() && (this.format == format.getFormat() || this.format != null && this.format.equals(format.getFormat())) && this.getColor().equals(format.getColor());
    }

    public int hashCode() {
        return (this.color == null ? 0 : this.color.hashCode()) + this.getFormat().hashCode() + (int)this.getSize() + (this.isBold() ? 101 : 100) + (this.isItalic() ? 501 : 500) + (this.isUnderline() ? 1001 : 1000) + (this.isWrap() ? 5001 : 5000) + (this.getAlign() + 10000);
    }

    public Format getDefaultFormat() {
        return this.field.getReport().getDefaultField().getFormat();
    }

    public String getFontFamilyName() {
        return this.fontFamilyName == null ? this.getDefaultFormat().getFontFamilyName() : this.fontFamilyName;
    }

    public void setFontFamilyName(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        if (!(this.fontFamilyName == string || this.fontFamilyName != null && this.fontFamilyName.equals(string))) {
            this.fontFamilyName = string;
            this.font = null;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Font getFont() {
        if (this.font == null) {
            String string = this.getFontFamilyName();
            int n = 0;
            if (this.isBold()) {
                n = 1;
            }
            if (this.isItalic()) {
                n |= 2;
            }
            if (n == 0) {
                n = 0;
            }
            this.font = new Font(string, n, (int)this.getSize());
        }
        return this.font;
    }

    public void clearFontCache() {
        this.font = null;
    }

    public double getSize() {
        return this.size == null ? this.getDefaultFormat().getSize() : this.size.doubleValue();
    }

    public void setSize(double d) {
        Double d2 = new Double(d);
        if (!(this.size == d2 || this.size != null && this.size.equals(d2))) {
            this.size = d2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isBold() {
        return this.bold == null ? this.getDefaultFormat().isBold() : this.bold.booleanValue();
    }

    public void setBold(boolean bl) {
        Boolean bl2;
        Boolean bl3 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (!(this.bold == bl2 || this.bold != null && this.bold.equals(bl2))) {
            this.bold = bl2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isItalic() {
        return this.italic == null ? this.getDefaultFormat().isItalic() : this.italic.booleanValue();
    }

    public void setItalic(boolean bl) {
        Boolean bl2;
        Boolean bl3 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (!(this.italic == bl2 || this.italic != null && this.italic.equals(bl2))) {
            this.italic = bl2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isUnderline() {
        return this.underline == null ? this.getDefaultFormat().isUnderline() : this.underline.booleanValue();
    }

    public void setUnderline(boolean bl) {
        Boolean bl2;
        Boolean bl3 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (!(this.underline == bl2 || this.underline != null && this.underline.equals(bl2))) {
            this.underline = bl2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isWrap() {
        return this.wrap == null ? this.getDefaultFormat().isWrap() : this.wrap.booleanValue();
    }

    public void setWrap(boolean bl) {
        Boolean bl2;
        Boolean bl3 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (!(this.wrap == bl2 || this.wrap != null && this.wrap.equals(bl2))) {
            this.wrap = bl2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int getAlign() {
        return this.align == null ? this.getDefaultFormat().getAlign() : this.align.intValue();
    }

    public void setAlign(int n) {
        Integer n2 = new Integer(n);
        if (!(this.align == n2 || this.align != null && this.align.equals(n2))) {
            this.align = n2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String getFormat() {
        return this.format == null ? this.getDefaultFormat().getFormat() : this.format;
    }

    public void setFormat(String string) {
        if (!(this.format == string || this.format != null && this.format.equals(string))) {
            this.format = string;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Color getColor() {
        return this.color == null ? this.getDefaultFormat().getColor() : this.color;
    }

    public void setColor(Color color) {
        if (this.color != color) {
            this.color = color;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String toString() {
        return "Format[size=" + this.size + ", bold=" + this.bold + ", italic=" + this.italic + ", underline=" + this.underline + ", wrap=" + this.wrap + ", align=" + (this.align == null ? "null" : Format.alignToString(this.align)) + ", format=" + this.format + ", color=" + this.color + ", font=" + this.fontFamilyName + "]";
    }

    public void writeXML(XMLWriter xMLWriter) {
        Format format = this.getDefaultFormat();
        if (this.equals(format)) {
            return;
        }
        xMLWriter.startElement("format");
        if (this.fontFamilyName != null && !format.getFontFamilyName().equals(this.fontFamilyName)) {
            xMLWriter.attr("font", this.fontFamilyName);
        }
        if (this.size != null && this.size.doubleValue() != format.getSize()) {
            xMLWriter.attr("size", this.size);
        }
        if (this.bold != null && this.bold.booleanValue() != format.isBold()) {
            xMLWriter.attr("bold", this.bold);
        }
        if (this.italic != null && this.italic.booleanValue() != format.isItalic()) {
            xMLWriter.attr("italic", this.italic);
        }
        if (this.underline != null && this.underline.booleanValue() != format.isUnderline()) {
            xMLWriter.attr("underline", this.underline);
        }
        if (this.wrap != null && this.wrap.booleanValue() != format.isWrap()) {
            xMLWriter.attr("wrap", this.wrap);
        }
        if (this.align != null && this.align.intValue() != format.getAlign()) {
            xMLWriter.attr("align", Format.alignToString(this.align));
        }
        if (this.color != null && !this.color.equals(format.getColor())) {
            xMLWriter.attr("color", this.color);
        }
        if (this.format != null && !this.format.equals(format.getFormat()) && this.format.length() > 0) {
            xMLWriter.attr("format", this.format);
        }
        xMLWriter.endElement();
    }
}

