/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.Observable;
import jimm.datavision.Draggable;
import jimm.datavision.Element;
import jimm.datavision.Formula;
import jimm.datavision.Identity;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.UserColumn;
import jimm.datavision.field.AggregateField;
import jimm.datavision.field.Border;
import jimm.datavision.field.ColumnField;
import jimm.datavision.field.Format;
import jimm.datavision.field.FormattedValueCache;
import jimm.datavision.field.FormulaField;
import jimm.datavision.field.ImageField;
import jimm.datavision.field.ParameterField;
import jimm.datavision.field.Rectangle;
import jimm.datavision.field.SpecialField;
import jimm.datavision.field.SubreportField;
import jimm.datavision.field.TextField;
import jimm.datavision.field.UserColumnField;
import jimm.datavision.gui.FieldWidget;
import jimm.datavision.gui.SectionWidget;
import jimm.util.I18N;
import jimm.util.XMLWriter;

public abstract class Field
extends Element
implements Identity,
Draggable,
Cloneable {
    public static final double DEFAULT_WIDTH = 120.0;
    public static final double DEFAULT_HEIGHT = 16.0;
    static Long maxIdSeen = new Long(0L);
    protected Long id;
    protected Rectangle bounds;
    protected Format format;
    protected Border border;
    protected Object value;
    protected FormattedValueCache cache;

    public static Field create(Long l, Report report, Section section, String string, Object object, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(I18N.get("Field.field_cap") + " " + l + ": " + I18N.get("Field.need_type"));
        }
        if ((string = string.toLowerCase()).equals("special")) {
            return new SpecialField(l, report, section, object, bl);
        }
        if (string.equals("text")) {
            return new TextField(l, report, section, object, bl);
        }
        if (string.equals("column")) {
            return new ColumnField(l, report, section, object, bl);
        }
        if (string.equals("formula")) {
            return new FormulaField(l, report, section, object, bl);
        }
        if (string.equals("parameter")) {
            return new ParameterField(l, report, section, object, bl);
        }
        if (string.equals("image")) {
            return new ImageField(l, report, section, object, bl);
        }
        if (string.equals("usercol")) {
            return new UserColumnField(l, report, section, object, bl);
        }
        if (string.equals("subreport")) {
            return new SubreportField(l, report, section, object, bl);
        }
        if (AggregateField.isAggregateFunctionName(string)) {
            return new AggregateField(l, report, section, object, bl, string);
        }
        throw new IllegalArgumentException(I18N.get("Field.field_cap") + " " + l + ": " + I18N.get("Field.unknown") + " \"" + string + "\"");
    }

    public static Field createFromDragString(Report report, String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Field.create(null, report, null, string2, string3, true);
    }

    protected Field(Long l, Report report, Section section, Object object, boolean bl) {
        super(report, section, bl);
        if (l == null) {
            l = new Long(maxIdSeen + 1L);
        }
        if (l.compareTo(maxIdSeen) == 1) {
            maxIdSeen = new Long(l);
        }
        this.id = l;
        this.format = Format.createEmptyFormat();
        this.format.setField(this);
        this.format.addObserver(this);
        Field field = report.getDefaultField();
        this.value = object;
        this.cache = new FormattedValueCache(this);
        this.bounds = field != null ? new Rectangle(0.0, 0.0, field.getBounds().width, field.getBounds().height) : new Rectangle(0.0, 0.0, 120.0, 16.0);
        this.bounds.addObserver(this);
        if (field != null) {
            field.addObserver(this);
        }
    }

    public Object clone() {
        Field field = Field.create(null, this.report, this.section, this.typeString(), this.value, true);
        field.bounds = new Rectangle(this.bounds);
        field.format = (Format)this.format.clone();
        field.format.setField(field);
        if (this.border == null) {
            field.border = null;
        } else {
            field.border = (Border)this.border.clone();
            field.border.setField(field);
        }
        return field;
    }

    protected void finalize() throws Throwable {
        this.bounds.deleteObserver(this);
        if (this.format != null) {
            this.format.deleteObserver(this);
        }
        if (this.border != null) {
            this.border.deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (this.format != null) {
            this.format.clearFontCache();
        }
    }

    public Object getId() {
        return this.id;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rectangle) {
        if (this.bounds != rectangle) {
            this.bounds.deleteObserver(this);
            this.bounds = rectangle;
            this.bounds.addObserver(this);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public double getOutputHeight() {
        return this.cache.getOutputHeight(this.getValue());
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        if (this.format != format) {
            if (this.format != null) {
                this.format.deleteObserver(this);
            }
            this.format = format;
            this.format.setField(this);
            if (this.format != null) {
                this.format.addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Border getBorderOrDefault() {
        if (this.border != null) {
            return this.border;
        }
        Border border = (Border)this.report.getDefaultField().getBorder().clone();
        border.setField(this);
        return border;
    }

    public void setBorder(Border border) {
        if (this.border != border) {
            if (this.border != null) {
                this.border.deleteObserver(this);
            }
            this.border = border;
            if (this.border != null) {
                this.border.addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (this.value != object) {
            this.value = object;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public FieldWidget makeWidget(SectionWidget sectionWidget) {
        return new FieldWidget(sectionWidget, this);
    }

    public abstract String typeString();

    public abstract String dragString();

    public String designLabel() {
        return this.formulaString();
    }

    public abstract String formulaString();

    public boolean refersTo(Field field) {
        return false;
    }

    public boolean refersTo(Formula formula) {
        return false;
    }

    public boolean refersTo(UserColumn userColumn) {
        return false;
    }

    public boolean refersTo(Parameter parameter) {
        return false;
    }

    public boolean canBeAggregated() {
        return false;
    }

    public String toString() {
        if (!this.visible) {
            return null;
        }
        return this.cache.getFormattedString(this.getValue());
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("field");
        xMLWriter.attr("id", this.id);
        xMLWriter.attr("type", this.typeString());
        xMLWriter.attr("value", this.value);
        if (!this.visible) {
            xMLWriter.attr("visible", this.visible);
        }
        this.writeFieldGuts(xMLWriter);
        xMLWriter.endElement();
    }

    protected void writeFieldGuts(XMLWriter xMLWriter) {
        this.bounds.writeXML(xMLWriter);
        if (this.format != null) {
            this.format.writeXML(xMLWriter);
        }
        if (this.border != null) {
            this.border.writeXML(xMLWriter);
        }
    }
}

