/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.source.Column;
import jimm.util.I18N;

public class ColumnField
extends Field {
    protected Column column;

    public ColumnField(Long l, Report report, Section section, Object object, boolean bl) {
        super(l, report, section, object, bl);
        this.column = report.findColumn((String)object);
        if (this.column == null) {
            String string = I18N.get("UnknownColumn.the_column") + ' ' + (String)object + ' ' + I18N.get("UnknownColumn.column_unknown");
            throw new IllegalArgumentException(string);
        }
    }

    public String dragString() {
        return this.typeString() + ":" + this.column.getId();
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        if (this.column != column) {
            this.column = column;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String typeString() {
        return "column";
    }

    public String formulaString() {
        return "{" + this.value + "}";
    }

    public Object getValue() {
        return this.getReport().columnValue(this.column);
    }

    public boolean canBeAggregated() {
        return this.section != null && this.section.isDetail() && this.getColumn().isNumeric();
    }
}

