/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.Observable;
import jimm.util.XMLWriter;

public class BorderEdge
extends Observable
implements Cloneable {
    public static final int STYLE_LINE = 0;
    public static final int STYLE_DASH = 1;
    public static final int STYLE_DOT = 2;
    public static final int DEFAULT_STYLE = 0;
    public static final int DEFAULT_NUMBER = 1;
    public static final double DEFAULT_THICKNESS = 1.0;
    protected int style;
    protected double thickness;
    protected int number;

    public static int styleFromString(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        string = string.toLowerCase();
        int n = 0;
        if (string.equals("line")) {
            n = 0;
        } else if (string.equals("dash")) {
            n = 1;
        } else if (string.equals("dot")) {
            n = 2;
        }
        return n;
    }

    public BorderEdge() {
        this(0, 1.0, 1);
    }

    public BorderEdge(int n) {
        this(n, 1.0, 1);
    }

    public BorderEdge(int n, double d) {
        this(n, d, 1);
    }

    public BorderEdge(int n, double d, int n2) {
        this.style = n;
        this.thickness = d;
        this.number = n2;
    }

    public Object clone() {
        BorderEdge borderEdge = new BorderEdge(this.style, this.thickness, this.number);
        return borderEdge;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BorderEdge)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        BorderEdge borderEdge = (BorderEdge)object;
        return this.number == borderEdge.number && this.thickness == borderEdge.thickness && this.style == borderEdge.style;
    }

    public int hashCode() {
        return this.style + this.number * 10 + (int)(this.thickness * 1000.0);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        if (this.style != n) {
            this.style = n;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double d) {
        if (this.thickness != d) {
            this.thickness = d;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        if (this.number != n) {
            this.number = n;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void writeXML(XMLWriter xMLWriter, String string) {
        String string2 = null;
        if (this.style != 0) {
            switch (this.style) {
                case 0: {
                    string2 = "line";
                    break;
                }
                case 1: {
                    string2 = "dash";
                    break;
                }
                case 2: {
                    string2 = "dot";
                }
            }
        }
        xMLWriter.startElement("edge");
        xMLWriter.attr("location", string);
        if (this.number != 1) {
            xMLWriter.attr("number", this.number);
        }
        if (this.thickness != 1.0) {
            xMLWriter.attr("thickness", this.thickness);
        }
        if (string2 != null) {
            xMLWriter.attr("style", string2);
        }
        xMLWriter.endElement();
    }

    public String toString() {
        return "BorderEdge[style=" + this.style + ", thickness=" + this.thickness + ", number=" + this.number + "]";
    }
}

