/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Line;
import jimm.datavision.Point;
import jimm.datavision.Section;
import jimm.datavision.Writeable;
import jimm.datavision.field.BorderEdge;
import jimm.datavision.field.Field;
import jimm.datavision.field.Rectangle;
import jimm.datavision.layout.LineDrawer;
import jimm.util.XMLWriter;

public class Border
extends Observable
implements Writeable,
Cloneable,
Observer {
    protected static final int BORDER_LINE_SPACE_MULT = 3;
    protected static final Color DEFAULT_COLOR = Color.black;
    protected Field field;
    protected BorderEdge top;
    protected BorderEdge left;
    protected BorderEdge bottom;
    protected BorderEdge right;
    protected Color color;

    public Border(Field field) {
        this.field = field;
    }

    public Object clone() {
        Border border = new Border(this.field);
        BorderEdge borderEdge = this.getTop();
        if (borderEdge == null || borderEdge.getNumber() == 0) {
            border.setTop(null);
        } else {
            border.setTop((BorderEdge)borderEdge.clone());
        }
        borderEdge = this.getBottom();
        if (borderEdge == null || borderEdge.getNumber() == 0) {
            border.setBottom(null);
        } else {
            border.setBottom((BorderEdge)borderEdge.clone());
        }
        borderEdge = this.getLeft();
        if (borderEdge == null || borderEdge.getNumber() == 0) {
            border.setLeft(null);
        } else {
            border.setLeft((BorderEdge)borderEdge.clone());
        }
        borderEdge = this.getRight();
        if (borderEdge == null || borderEdge.getNumber() == 0) {
            border.setRight(null);
        } else {
            border.setRight((BorderEdge)borderEdge.clone());
        }
        border.setColor(this.getColor());
        return border;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof Border)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Border border = (Border)object;
        if (this.color == null && border.color != null) {
            return false;
        }
        if (this.color != null && !this.color.equals(border.color)) {
            return false;
        }
        BorderEdge borderEdge = this.top;
        BorderEdge borderEdge2 = border.top;
        int n2 = borderEdge == null ? 0 : borderEdge.number;
        int n3 = n = borderEdge2 == null ? 0 : borderEdge2.number;
        if (n2 != n) {
            return false;
        }
        borderEdge = this.left;
        borderEdge2 = border.left;
        n2 = borderEdge == null ? 0 : borderEdge.number;
        int n4 = n = borderEdge2 == null ? 0 : borderEdge2.number;
        if (n2 != n) {
            return false;
        }
        borderEdge = this.bottom;
        borderEdge2 = border.bottom;
        n2 = borderEdge == null ? 0 : borderEdge.number;
        int n5 = n = borderEdge2 == null ? 0 : borderEdge2.number;
        if (n2 != n) {
            return false;
        }
        borderEdge = this.right;
        borderEdge2 = border.right;
        n2 = borderEdge == null ? 0 : borderEdge.number;
        int n6 = n = borderEdge2 == null ? 0 : borderEdge2.number;
        return n2 == n;
    }

    public int hashCode() {
        int n = 0;
        if (this.color != null) {
            n += this.color.hashCode();
        }
        if (this.top != null) {
            n += this.top.hashCode();
        }
        if (this.left != null) {
            n += this.left.hashCode();
        }
        if (this.bottom != null) {
            n += this.bottom.hashCode();
        }
        if (this.right != null) {
            n += this.right.hashCode();
        }
        return n;
    }

    public void setField(Field field) {
        this.field = field;
    }

    protected void finalize() throws Throwable {
        if (this.top != null) {
            this.top.deleteObserver(this);
        }
        if (this.left != null) {
            this.left.deleteObserver(this);
        }
        if (this.bottom != null) {
            this.bottom.deleteObserver(this);
        }
        if (this.right != null) {
            this.right.deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public BorderEdge getTop() {
        return this.top;
    }

    public void setTop(BorderEdge borderEdge) {
        if (this.top != borderEdge) {
            if (this.top != null) {
                this.top.deleteObserver(this);
            }
            this.top = borderEdge;
            if (this.top != null) {
                this.top.addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public BorderEdge getLeft() {
        return this.left;
    }

    public void setLeft(BorderEdge borderEdge) {
        if (this.left != borderEdge) {
            if (this.left != null) {
                this.left.deleteObserver(this);
            }
            this.left = borderEdge;
            if (this.left != null) {
                this.left.addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public BorderEdge getBottom() {
        return this.bottom;
    }

    public void setBottom(BorderEdge borderEdge) {
        if (this.bottom != borderEdge) {
            if (this.bottom != null) {
                this.bottom.deleteObserver(this);
            }
            this.bottom = borderEdge;
            if (this.bottom != null) {
                this.bottom.addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public BorderEdge getRight() {
        return this.right;
    }

    public void setRight(BorderEdge borderEdge) {
        if (this.right != borderEdge) {
            if (this.right != null) {
                this.right.deleteObserver(this);
            }
            this.right = borderEdge;
            if (this.right != null) {
                this.right.addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color != color) {
            this.color = color;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void eachLine(LineDrawer lineDrawer, Object object) {
        int n;
        Line line;
        Rectangle rectangle = this.field.getBounds();
        Section section = this.field.getSection();
        BorderEdge borderEdge = this.top;
        if (borderEdge != null && borderEdge.getThickness() > 0.0 && borderEdge.getNumber() > 0) {
            line = new Line(null, section, borderEdge.getThickness(), null, true, new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y));
            for (n = 0; n < borderEdge.getNumber(); ++n) {
                lineDrawer.drawLine(line, object);
                line.getPoint((int)0).y += 3.0;
                line.getPoint((int)1).y += 3.0;
            }
        }
        if ((borderEdge = this.bottom) != null && borderEdge.getThickness() > 0.0 && borderEdge.getNumber() > 0) {
            line = new Line(null, section, borderEdge.getThickness(), null, true, new Point(rectangle.x, rectangle.y + rectangle.height), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
            for (n = 0; n < borderEdge.getNumber(); ++n) {
                lineDrawer.drawLine(line, object);
                line.getPoint((int)0).y -= 3.0;
                line.getPoint((int)1).y -= 3.0;
            }
        }
        if ((borderEdge = this.left) != null && borderEdge.getThickness() > 0.0 && borderEdge.getNumber() > 0) {
            line = new Line(null, section, borderEdge.getThickness(), null, true, new Point(rectangle.x, rectangle.y), new Point(rectangle.x, rectangle.y + rectangle.height));
            for (n = 0; n < borderEdge.getNumber(); ++n) {
                lineDrawer.drawLine(line, object);
                line.getPoint((int)0).x += 3.0;
                line.getPoint((int)1).x += 3.0;
            }
        }
        if ((borderEdge = this.right) != null && borderEdge.getThickness() > 0.0 && borderEdge.getNumber() > 0) {
            line = new Line(null, section, borderEdge.getThickness(), null, true, new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
            for (n = 0; n < borderEdge.getNumber(); ++n) {
                lineDrawer.drawLine(line, object);
                line.getPoint((int)0).x -= 3.0;
                line.getPoint((int)1).x -= 3.0;
            }
        }
    }

    public boolean isEmpty() {
        return this.isEmptyEdge(this.top) && this.isEmptyEdge(this.bottom) && this.isEmptyEdge(this.left) && this.isEmptyEdge(this.right);
    }

    protected boolean isEmptyEdge(BorderEdge borderEdge) {
        return borderEdge == null || borderEdge.getNumber() == 0 || borderEdge.getThickness() == 0.0;
    }

    public void writeXML(XMLWriter xMLWriter) {
        if (this.isEmpty()) {
            return;
        }
        xMLWriter.startElement("border");
        if (this.color != null && !this.color.equals(DEFAULT_COLOR)) {
            xMLWriter.attr("color", this.color);
        }
        if (this.top != null && this.top.getNumber() != 0) {
            this.top.writeXML(xMLWriter, "top");
        }
        if (this.bottom != null && this.bottom.getNumber() != 0) {
            this.bottom.writeXML(xMLWriter, "bottom");
        }
        if (this.left != null && this.left.getNumber() != 0) {
            this.left.writeXML(xMLWriter, "left");
        }
        if (this.right != null && this.right.getNumber() != 0) {
            this.right.writeXML(xMLWriter, "right");
        }
        xMLWriter.endElement();
    }
}

