/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.field;

import java.util.HashMap;
import java.util.TreeSet;
import jimm.datavision.Formula;
import jimm.datavision.Group;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.UserColumn;
import jimm.datavision.field.AggregateFunction;
import jimm.datavision.field.Field;
import jimm.datavision.field.FormulaField;
import jimm.datavision.field.ParameterField;
import jimm.datavision.field.UserColumnField;

public class AggregateField
extends Field {
    protected static final int START_VALUES_LENGTH = 100;
    protected static HashMap functions = new HashMap();
    protected static Object[] functionNames;
    protected Group group;
    protected String functionName;
    protected AggregateFunction function;
    protected double[] values = null;
    protected int valuesIndex;
    protected Field fieldToAggregate;

    public static boolean isAggregateFunctionName(String string) {
        return functions.keySet().contains(string);
    }

    public static Object[] functionNameArray() {
        return functionNames;
    }

    public AggregateField(Long l, Report report, Section section, Object object, boolean bl, String string) {
        super(l, report, section, object, bl);
        this.setFunction(string);
    }

    protected void finalize() throws Throwable {
        if (this.fieldToAggregate != null) {
            this.fieldToAggregate.deleteObserver(this);
        }
        super.finalize();
    }

    public String getFunction() {
        return this.functionName;
    }

    public void setFunction(String string) {
        if (!(this.functionName == (string = string.toLowerCase()) || this.functionName != null && this.functionName.equals(string))) {
            this.functionName = string;
            this.function = (AggregateFunction)functions.get(this.functionName);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void initialize() {
        this.values = null;
    }

    public String dragString() {
        return this.typeString() + ":" + this.getField().getId();
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        if (this.group != group) {
            this.group = group;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Field getField() {
        if (this.fieldToAggregate == null) {
            this.fieldToAggregate = this.getReport().findField(this.value);
            this.fieldToAggregate.addObserver(this);
        }
        return this.fieldToAggregate;
    }

    public Long getFieldId() {
        return this.value instanceof Long ? (Long)this.value : new Long(this.value.toString());
    }

    public double getAggregateValue() {
        if (this.function == null) {
            return 0.0;
        }
        return this.function.aggregate(this.values, this.valuesIndex);
    }

    public String typeString() {
        return this.functionName;
    }

    public String designLabel() {
        return this.functionName + "(" + this.getField().designLabel() + ")";
    }

    public String formulaString() {
        return this.designLabel();
    }

    public boolean refersTo(Field field) {
        return this.getField() == field;
    }

    public boolean refersTo(Formula formula) {
        return this.getField() instanceof FormulaField && ((FormulaField)this.getField()).getFormula() == formula;
    }

    public boolean refersTo(UserColumn userColumn) {
        return this.getField() instanceof UserColumnField && ((UserColumnField)this.getField()).getUserColumn() == userColumn;
    }

    public boolean refersTo(Parameter parameter) {
        if (this.getField() instanceof ParameterField && ((ParameterField)this.getField()).getParameter() == parameter) {
            return true;
        }
        return this.getField() instanceof FormulaField && ((FormulaField)this.getField()).refersTo(parameter);
    }

    public boolean canBeAggregated() {
        return true;
    }

    public void updateAggregate() {
        Object object = this.getField().getValue();
        double d = 0.0;
        if (object != null) {
            d = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(object.toString());
        }
        if (this.values == null || this.group != null && this.group.isNewValue()) {
            this.values = new double[100];
            this.valuesIndex = 0;
        } else if (this.valuesIndex == this.values.length) {
            double[] dArray = new double[this.values.length * 2];
            System.arraycopy(this.values, 0, dArray, 0, this.values.length);
            this.values = dArray;
        }
        this.values[this.valuesIndex++] = d;
    }

    public Object getValue() {
        return new Double(this.getAggregateValue());
    }

    static {
        functions.put("sum", new AggregateFunction(){

            public double aggregate(double[] dArray, int n) {
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += dArray[i];
                }
                return d;
            }
        });
        functions.put("subtotal", functions.get("sum"));
        functions.put("min", new AggregateFunction(){

            public double aggregate(double[] dArray, int n) {
                double d = Double.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    if (!(dArray[i] < d)) continue;
                    d = dArray[i];
                }
                return d;
            }
        });
        functions.put("max", new AggregateFunction(){

            public double aggregate(double[] dArray, int n) {
                double d = Double.MIN_VALUE;
                for (int i = 0; i < n; ++i) {
                    if (!(dArray[i] > d)) continue;
                    d = dArray[i];
                }
                return d;
            }
        });
        functions.put("count", new AggregateFunction(){

            public double aggregate(double[] dArray, int n) {
                return n;
            }
        });
        functions.put("average", new AggregateFunction(){

            public double aggregate(double[] dArray, int n) {
                if (n == 0) {
                    return 0.0;
                }
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += dArray[i];
                }
                return d / (double)n;
            }
        });
        functions.put("stddev", new AggregateFunction(){

            public double aggregate(double[] dArray, int n) {
                if (n < 2) {
                    return 0.0;
                }
                double d = ((AggregateFunction)functions.get("average")).aggregate(dArray, n);
                double d2 = 0.0;
                for (int i = 0; i < n; ++i) {
                    d2 += (dArray[i] - d) * (dArray[i] - d);
                }
                return Math.sqrt(d2 / (double)(n - 1));
            }
        });
        TreeSet treeSet = new TreeSet(functions.keySet());
        treeSet.remove("select");
        functionNames = treeSet.toArray();
    }
}

