/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import jimm.datavision.Formula;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.UserColumn;
import jimm.datavision.Writeable;
import jimm.datavision.field.Field;
import jimm.util.XMLWriter;

public class SuppressionProc
implements Writeable {
    protected Formula formula;
    protected Report report;
    protected boolean hiding;

    public SuppressionProc(Report report) {
        this.report = report;
        this.hiding = false;
    }

    public boolean isHidden() {
        return this.hiding;
    }

    public void setHidden(boolean bl) {
        this.hiding = bl;
    }

    public Formula getFormula() {
        if (this.formula == null) {
            this.formula = new Formula(null, this.report, "");
            this.report = null;
        }
        return this.formula;
    }

    public boolean refersTo(Field field) {
        return this.formula != null && this.formula.refersTo(field);
    }

    public boolean refersTo(Formula formula) {
        return this.formula != null && (formula == this.formula || this.formula.refersTo(formula));
    }

    public boolean refersTo(UserColumn userColumn) {
        return this.formula != null && this.formula.refersTo(userColumn);
    }

    public boolean refersTo(Parameter parameter) {
        return this.formula != null && this.formula.refersTo(parameter);
    }

    public boolean suppress() {
        if (this.hiding) {
            return true;
        }
        if (this.formula == null) {
            return false;
        }
        String string = this.formula.getExpression();
        if (string == null || string.length() == 0) {
            return false;
        }
        Object object = this.formula.eval();
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public void writeXML(XMLWriter xMLWriter) {
        boolean bl;
        String string = null;
        boolean bl2 = bl = this.formula != null && (string = this.formula.getExpression()) != null && string.length() > 0;
        if (!this.hiding && !bl) {
            return;
        }
        xMLWriter.startElement("suppression-proc");
        if (this.hiding) {
            xMLWriter.attr("hide", true);
        }
        if (bl) {
            this.formula.writeXML(xMLWriter);
        }
        xMLWriter.endElement();
    }
}

