/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Identity;
import jimm.datavision.ListWriter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.source.Join;
import jimm.datavision.source.sql.SubreportQuery;
import jimm.util.StringUtils;
import jimm.util.XMLWriter;

public class Subreport
extends Report
implements Identity {
    protected Report parentReport;
    protected Long id;
    protected String cachedValue;

    public Subreport(Report report, Long l) {
        if (l == null) {
            l = report.generateNewSubreportId();
        }
        this.id = l;
        this.parentReport = report;
        this.parentReport.addSubreport(this);
    }

    public Object getId() {
        return this.id;
    }

    public Report getParentReport() {
        return this.parentReport;
    }

    public void addJoin(Join join) {
        ((SubreportQuery)this.getDataSource().getQuery()).addSubreportJoin(join);
    }

    public void addAllJoins(Collection collection) {
        ((SubreportQuery)this.getDataSource().getQuery()).addSubreportJoins(collection);
    }

    public Iterator parentColumns() {
        return ((SubreportQuery)this.getDataSource().getQuery()).parentColumns();
    }

    public void clearCache() {
        this.cachedValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        this.rset = null;
        this.cachedValue = "";
        try {
            block8: {
                try {
                    this.rset = this.getDataSource().execute();
                    if (this.rset == null) break block8;
                    this.cachedValue = StringUtils.join(this.makeRowStrings(), "\n");
                }
                catch (Exception exception) {
                    ErrorHandler.error(exception.toString());
                    Object var3_2 = null;
                    if (this.rset != null) {
                        this.rset.close();
                    }
                }
            }
            Object var3_1 = null;
            if (this.rset != null) {
                this.rset.close();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.rset != null) {
                this.rset.close();
            }
            throw throwable;
        }
        return this.cachedValue;
    }

    protected Collection makeRowStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Section section = this.getFirstSectionByArea(4);
        while (this.rset.next()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Iterator iterator = section.fields();
            while (iterator.hasNext()) {
                String string = ((Field)iterator.next()).toString();
                arrayList2.add(string == null ? "" : string);
            }
            arrayList.add(StringUtils.join(arrayList2, " "));
        }
        return arrayList;
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("subreport");
        xMLWriter.attr("id", this.id);
        this.getDataSource().getQuery().writeXML(xMLWriter);
        ListWriter.writeList(xMLWriter, this.formulas.values(), "formulas");
        ListWriter.writeList(xMLWriter, this.usercols.values(), "usercols");
        ListWriter.writeList(xMLWriter, this.details.sections(), "details");
        xMLWriter.endElement();
    }
}

