/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jimm.datavision.ListWriter;
import jimm.datavision.Section;
import jimm.datavision.SectionWalker;
import jimm.datavision.Writeable;
import jimm.util.I18N;
import jimm.util.XMLWriter;

public class SectionArea
implements Writeable {
    public static final int REPORT_HEADER = 0;
    public static final int REPORT_FOOTER = 1;
    public static final int PAGE_HEADER = 2;
    public static final int PAGE_FOOTER = 3;
    public static final int DETAIL = 4;
    public static final int GROUP_HEADER = 5;
    public static final int GROUP_FOOTER = 6;
    protected static final String[] AREA_NAME_KEYS = new String[]{"Report.report_header", "Report.report_footer", "Report.page_header", "Report.page_footer", "Report.detail", "Report.group_header", "Report.group_footer"};
    List sections;
    int area;

    public static String nameFromArea(int n) {
        return I18N.get(AREA_NAME_KEYS[n]);
    }

    public SectionArea(int n) {
        this.area = n;
        this.sections = new ArrayList();
    }

    public int getArea() {
        return this.area;
    }

    public int indexOf(Section section) {
        return this.sections.indexOf(section);
    }

    public Section get(int n) {
        return (Section)this.sections.get(n);
    }

    public Section first() {
        return (Section)this.sections.get(0);
    }

    public void add(Section section) {
        this.sections.add(section);
        this.imprint(section);
    }

    public void add(int n, Section section) {
        this.sections.add(n, section);
        this.imprint(section);
    }

    public Section insertAfter(Section section, Section section2) {
        if (section == null) {
            if (section2 != null) {
                section = new Section(section2.getReport());
            } else {
                throw new IllegalArgumentException("SectionArea.insertAfter: both section and afterThis can't be null");
            }
        }
        this.sections.add(this.sections.indexOf(section2) + 1, section);
        this.imprint(section);
        return section;
    }

    protected void imprint(Section section) {
        section.setArea(this);
    }

    public boolean isDetail() {
        return this.area == 4;
    }

    public void remove(Section section) {
        this.sections.remove(section);
        section.setArea(null);
    }

    public boolean contains(Section section) {
        return this.sections.contains(section);
    }

    public String getName() {
        return SectionArea.nameFromArea(this.area);
    }

    public List sections() {
        return Collections.unmodifiableList(this.sections);
    }

    public Iterator iterator() {
        return this.sections.iterator();
    }

    public int size() {
        return this.sections.size();
    }

    public boolean isEmpty() {
        return this.sections.isEmpty();
    }

    public void clear() {
        Iterator iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            ((Section)iterator.next()).setArea(null);
        }
        this.sections.clear();
    }

    public void withSectionsDo(SectionWalker sectionWalker) {
        Iterator iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            sectionWalker.step((Section)iterator.next());
        }
    }

    public void writeXML(XMLWriter xMLWriter) {
        ListWriter.writeList(xMLWriter, this.sections);
    }
}

