/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Formula;
import jimm.datavision.Line;
import jimm.datavision.ListWriter;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.SectionArea;
import jimm.datavision.SuppressionProc;
import jimm.datavision.UserColumn;
import jimm.datavision.Writeable;
import jimm.datavision.field.Field;
import jimm.datavision.field.FormulaField;
import jimm.util.XMLWriter;

public class Section
extends Observable
implements Writeable,
Observer {
    protected static final double DEFAULT_HEIGHT = 20.0;
    protected Report report;
    protected SectionArea area;
    protected double minHeight;
    protected ArrayList fields;
    protected ArrayList lines;
    protected SuppressionProc suppressionProc;
    protected boolean pageBreak;

    public Section(Report report) {
        this.report = report;
        this.minHeight = 20.0;
        this.fields = new ArrayList();
        this.lines = new ArrayList();
        this.suppressionProc = new SuppressionProc(this.report);
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public Report getReport() {
        return this.report;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(double d) {
        if (this.minHeight != d) {
            this.minHeight = d;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public double getOutputHeight() {
        double d = this.minHeight;
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            double d2 = field.getBounds().y + field.getOutputHeight();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getWidth() {
        return this.report.getPaperFormat().getWidth();
    }

    public SectionArea getArea() {
        return this.area;
    }

    public void setArea(SectionArea sectionArea) {
        if (sectionArea != this.area) {
            this.area = sectionArea;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String getName() {
        return this.area == null ? null : this.area.getName();
    }

    public Field findField(Object object) {
        Long l = object instanceof String ? new Long((String)object) : (Long)object;
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.getId().equals(l)) continue;
            return field;
        }
        return null;
    }

    public void addField(Field field) {
        this.fields.add(field);
        field.addObserver(this);
        field.setSection(this);
        this.setChanged();
        this.notifyObservers();
    }

    public void removeField(Field field) {
        if (this.fields.contains(field)) {
            this.fields.remove(field);
            field.deleteObserver(this);
            field.setSection(null);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Iterator fields() {
        return this.fields.iterator();
    }

    public Object[] fieldsSortedBy(Comparator comparator) {
        Object[] objectArray = this.fields.toArray();
        Arrays.sort(objectArray, comparator);
        return objectArray;
    }

    public int numFields() {
        return this.fields.size();
    }

    public void addLine(Line line) {
        this.lines.add(line);
        this.setChanged();
        this.notifyObservers();
    }

    public void removeLine(Line line) {
        this.lines.remove(line);
        this.setChanged();
        this.notifyObservers();
    }

    public Iterator lines() {
        return this.lines.iterator();
    }

    public boolean isHidden() {
        return this.suppressionProc.isHidden();
    }

    public boolean isDetail() {
        return this.area.isDetail();
    }

    public boolean hasPageBreak() {
        return this.pageBreak;
    }

    public void setPageBreak(boolean bl) {
        this.pageBreak = bl;
    }

    public SuppressionProc getSuppressionProc() {
        return this.suppressionProc;
    }

    public boolean contains(Field field) {
        return this.fields.contains(field);
    }

    public boolean containsReferenceTo(Field field) {
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            Field field2 = (Field)iterator.next();
            if (field2 != field && !field2.refersTo(field)) continue;
            return true;
        }
        return this.suppressionProc.refersTo(field);
    }

    public boolean containsReferenceTo(Formula formula) {
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.refersTo(formula)) continue;
            return true;
        }
        return this.suppressionProc.refersTo(formula);
    }

    public boolean containsReferenceTo(UserColumn userColumn) {
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.refersTo(userColumn)) continue;
            return true;
        }
        return this.suppressionProc.refersTo(userColumn);
    }

    public boolean containsReferenceTo(Parameter parameter) {
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.refersTo(parameter)) continue;
            return true;
        }
        return this.suppressionProc.refersTo(parameter);
    }

    public void evaluateFormulas() {
        Iterator iterator = this.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!(field instanceof FormulaField)) continue;
            field.getValue();
        }
    }

    public boolean isVisibleForCurrentRow() {
        return !this.suppressionProc.suppress();
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("section");
        xMLWriter.attr("height", this.minHeight);
        if (this.pageBreak) {
            xMLWriter.attr("pagebreak", this.pageBreak);
        }
        ListWriter.writeList(xMLWriter, this.fields);
        ListWriter.writeList(xMLWriter, this.lines);
        this.suppressionProc.writeXML(xMLWriter);
        xMLWriter.endElement();
    }
}

