/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jimm.datavision.Report;
import jimm.datavision.Writeable;
import jimm.util.XMLWriter;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class Scripting
implements Writeable {
    protected static final String DEFAULT_LANGUAGE = "Ruby";
    protected static final String DEFAULT_CLASS = "org.jruby.javasupport.bsf.JRubyEngine";
    protected Report report;
    protected String defaultLanguage;
    protected Map languages;
    protected Map managers;
    static /* synthetic */ Class class$jimm$datavision$Report;

    public Scripting(Report report) {
        this.report = report;
        this.defaultLanguage = DEFAULT_LANGUAGE;
        this.languages = new HashMap();
        this.languages.put(DEFAULT_LANGUAGE, DEFAULT_CLASS);
        this.managers = new HashMap();
    }

    public Map getLanguages() {
        return Collections.unmodifiableMap(this.languages);
    }

    public void addLanguage(String string, String string2) {
        this.languages.put(string, string2);
    }

    public void replaceLanguages(Map map) {
        this.languages.clear();
        this.languages.putAll(map);
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("default language may not be null");
        }
        this.defaultLanguage = string;
    }

    public boolean canFind(String string) {
        BSFManager bSFManager = new BSFManager();
        boolean bl = false;
        try {
            bSFManager.getClassLoader().loadClass(string);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return bl;
    }

    public Object eval(String string, String string2, String string3) throws BSFException {
        return this.getBsfManager(string).eval(string, string3, 1, 1, (Object)string2);
    }

    public BSFManager getBsfManager() throws BSFException {
        return this.getBsfManager(this.defaultLanguage);
    }

    public BSFManager getBsfManager(String string) throws BSFException {
        BSFManager bSFManager = (BSFManager)this.managers.get(string);
        if (bSFManager == null) {
            bSFManager = new BSFManager();
            bSFManager.declareBean("report", (Object)this.report, class$jimm$datavision$Report == null ? (class$jimm$datavision$Report = Scripting.class$("jimm.datavision.Report")) : class$jimm$datavision$Report);
            BSFManager.registerScriptingEngine((String)string, (String)((String)this.languages.get(string)), null);
            this.managers.put(string, bSFManager);
        }
        return bSFManager;
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("bean-scripting-framework");
        xMLWriter.attr("default-language", this.defaultLanguage);
        Iterator iterator = this.languages.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            xMLWriter.startElement("language");
            xMLWriter.attr("name", string);
            xMLWriter.attr("class", this.languages.get(string));
            xMLWriter.endElement();
        }
        xMLWriter.endElement();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

