/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParserFactory;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Formula;
import jimm.datavision.Group;
import jimm.datavision.Line;
import jimm.datavision.PaperFormat;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.Selectable;
import jimm.datavision.Subreport;
import jimm.datavision.SuppressionProc;
import jimm.datavision.UserCancellationException;
import jimm.datavision.UserColumn;
import jimm.datavision.field.AggregateField;
import jimm.datavision.field.Border;
import jimm.datavision.field.BorderEdge;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.source.Column;
import jimm.datavision.source.Join;
import jimm.datavision.source.charsep.CharSepSource;
import jimm.datavision.source.ncsql.NCDatabase;
import jimm.datavision.source.sql.Database;
import jimm.datavision.source.sql.SubreportDatabase;
import jimm.util.I18N;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportReader
extends DefaultHandler {
    protected static final double DEFAULT_DTD_VERSION = 0.2;
    protected static final double DTD_VERSION_FORMULA_IDS = 0.2;
    protected Stack tagNameStack;
    protected Report report;
    protected Subreport subreport;
    protected Parameter parameter;
    protected Formula formula;
    protected UserColumn usercol;
    protected Section section;
    protected Group group;
    protected Field field;
    protected String textData;
    protected Border border;
    protected Line line;
    protected double dtdVersion;
    protected HashMap formulasToConvert;
    protected int nextSectionLocation;
    protected boolean missingColumnSeen;
    protected boolean inSubreportJoins;

    public ReportReader(Report report) {
        this.report = report;
        this.tagNameStack = new Stack();
        this.dtdVersion = 0.2;
    }

    public void read(InputSource inputSource) throws Exception {
        this.removeReportSections();
        SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)this);
        this.postParse();
    }

    public void read(File file) throws Exception {
        this.removeReportSections();
        SAXParserFactory.newInstance().newSAXParser().parse(file, (DefaultHandler)this);
        this.postParse();
    }

    protected void removeReportSections() {
        this.getReport().headers().clear();
        this.getReport().pageHeaders().clear();
        this.getReport().pageFooters().clear();
        this.getReport().footers().clear();
        this.getReport().details().clear();
    }

    protected void postParse() throws SAXException {
        this.convertFormulas();
        this.ensureNotEmpty(this.report.headers());
        this.ensureNotEmpty(this.report.pageHeaders());
        this.ensureNotEmpty(this.report.details());
        this.ensureNotEmpty(this.report.footers());
        this.ensureNotEmpty(this.report.pageFooters());
        Iterator iterator = this.report.subreports();
        while (iterator.hasNext()) {
            this.ensureNotEmpty(((Subreport)iterator.next()).details());
        }
    }

    protected void ensureNotEmpty(SectionArea sectionArea) {
        if (sectionArea.isEmpty()) {
            Section section = new Section(this.report);
            section.getSuppressionProc().setHidden(true);
            sectionArea.add(section);
        }
    }

    protected Report getReport() {
        return this.subreport != null ? this.subreport : this.report;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.length() == 0) {
            string4 = string3;
        }
        String string5 = this.tagNameStack.empty() ? null : (String)this.tagNameStack.peek();
        this.tagNameStack.push(new String(string4));
        if (this.textData == null || this.textData.length() > 0) {
            this.textData = new String();
        }
        if ("report".equals(string4)) {
            this.report(attributes);
        } else if ("bean-scripting-framework".equals(string4)) {
            this.defaultLanguage(attributes);
        } else if ("language".equals(string4)) {
            this.language(attributes);
        } else if ("database".equals(string4)) {
            this.database(attributes);
        } else if ("query".equals(string4)) {
            this.query(attributes);
        } else if ("charsep".equals(string4)) {
            this.charSepSource(attributes);
        } else if ("nc-database".equals(string4)) {
            this.ncDatabaseSource(attributes);
        } else if ("column".equals(string4)) {
            this.column(attributes);
        } else if ("subreport-joins".equals(string4)) {
            this.inSubreportJoins = true;
        } else if ("join".equals(string4)) {
            this.join(attributes);
        } else if ("sort".equals(string4)) {
            this.sort(attributes);
        } else if ("subreport".equals(string4)) {
            this.subreport(attributes);
        } else if ("parameter".equals(string4)) {
            this.parameter(attributes);
        } else if ("formula".equals(string4)) {
            this.formula(string5, attributes);
        } else if ("usercol".equals(string4)) {
            this.usercol(attributes);
        } else if ("headers".equals(string4)) {
            this.header(string5);
        } else if ("footers".equals(string4)) {
            this.footer(string5);
        } else if ("group".equals(string4)) {
            this.group(attributes);
        } else if ("details".equals(string4)) {
            this.nextSectionLocation = 4;
        } else if ("section".equals(string4)) {
            this.section(attributes);
        } else if ("field".equals(string4)) {
            this.field(attributes);
        } else if ("bounds".equals(string4)) {
            this.bounds(attributes);
        } else if ("edge".equals(string4)) {
            this.edge(attributes);
        } else if ("format".equals(string4)) {
            this.format(attributes);
        } else if ("border".equals(string4)) {
            this.border(attributes);
        } else if ("line".equals(string4)) {
            this.line(attributes);
        } else if ("point".equals(string4)) {
            this.point(attributes);
        } else if ("paper".equals(string4)) {
            this.paper(attributes);
        } else if ("suppression-proc".equals(string4)) {
            this.suppressionProc(attributes);
        }
    }

    protected void header(String string) {
        if ("report".equals(string)) {
            this.nextSectionLocation = 0;
        } else if ("page".equals(string)) {
            this.nextSectionLocation = 2;
        } else if ("group".equals(string)) {
            this.nextSectionLocation = 5;
        }
    }

    protected void footer(String string) {
        if ("report".equals(string)) {
            this.nextSectionLocation = 1;
        } else if ("page".equals(string)) {
            this.nextSectionLocation = 3;
        } else if ("group".equals(string)) {
            this.nextSectionLocation = 6;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.length() == 0) {
            string4 = string3;
        }
        this.tagNameStack.pop();
        if ("description".equals(string4)) {
            this.getReport().setDescription(this.textData);
        } else if ("subreport".equals(string4)) {
            this.subreport = null;
        } else if ("subreport-joins".equals(string4)) {
            this.inSubreportJoins = false;
        } else if ("default".equals(string4) && this.parameter != null) {
            this.parameter.addDefaultValue(this.textData);
        } else if ("formula".equals(string4)) {
            FormulaConversion formulaConversion;
            this.formula.setExpression(this.textData);
            if (this.formulasToConvert != null && (formulaConversion = (FormulaConversion)this.formulasToConvert.get(this.formula.getName())) != null) {
                formulaConversion.expression = new String(this.textData);
            }
            this.formula = null;
        } else if ("usercol".equals(string4)) {
            this.usercol.setExpression(this.textData);
            this.usercol = null;
        } else if ("text".equals(string4) && this.field != null) {
            this.field.setValue(this.textData);
        } else if ("where".equals(string4)) {
            this.getReport().getDataSource().getQuery().setWhereClause(this.textData);
        } else if ("metadata-url".equals(string4)) {
            try {
                this.getReport().getDataSource().readMetadataFrom(this.textData);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.textData = this.textData + new String(cArray, n, n2);
    }

    protected void report(Attributes attributes) {
        String string = attributes.getValue("dtd-version");
        this.dtdVersion = string == null ? 0.2 : Double.parseDouble(string);
        this.getReport().setName(attributes.getValue("name"));
        this.getReport().setTitle(attributes.getValue("title"));
        this.getReport().setAuthor(attributes.getValue("author"));
    }

    protected void defaultLanguage(Attributes attributes) {
        String string = this.rubyLanguageNameHack(attributes.getValue("default-language"));
        this.getReport().getScripting().setDefaultLanguage(string);
    }

    protected void language(Attributes attributes) {
        String string = this.rubyLanguageNameHack(attributes.getValue("name"));
        this.getReport().getScripting().addLanguage(string, attributes.getValue("class"));
    }

    protected String rubyLanguageNameHack(String string) {
        return "ruby".equals(string) ? "Ruby" : string;
    }

    protected void database(Attributes attributes) {
        if (this.getReport().hasDataSource()) {
            return;
        }
        try {
            Database database = new Database(attributes.getValue("driverClassName"), attributes.getValue("connInfo"), this.getReport(), attributes.getValue("name"), attributes.getValue("username"));
            this.getReport().setDataSource(database);
        }
        catch (UserCancellationException userCancellationException) {
            throw userCancellationException;
        }
        catch (Exception exception) {
            ErrorHandler.error(I18N.get("ReportReader.db_err"), exception, I18N.get("ReportReader.db_err_title"));
        }
    }

    protected void query(Attributes attributes) {
    }

    protected void charSepSource(Attributes attributes) {
        if (this.getReport().hasDataSource()) {
            return;
        }
        CharSepSource charSepSource = new CharSepSource(this.getReport());
        String string = attributes.getValue("sep-char");
        if (string != null) {
            charSepSource.setSepChar(string.charAt(0));
        }
        this.getReport().setDataSource(charSepSource);
    }

    protected void ncDatabaseSource(Attributes attributes) {
        if (!this.getReport().hasDataSource()) {
            this.getReport().setDataSource(new NCDatabase(this.getReport()));
        }
    }

    protected void column(Attributes attributes) {
        String string = attributes.getValue("name");
        int n = Column.typeFromString(attributes.getValue("type"));
        Column column = new Column(string, string, n);
        column.setDateParseFormat(attributes.getValue("date-format"));
        this.getReport().getDataSource().addColumn(column);
    }

    protected void join(Attributes attributes) {
        Column column = this.findColumn(attributes.getValue("from"));
        Column column2 = this.findColumn(attributes.getValue("to"));
        if (column != null && column2 != null) {
            Join join = new Join(column, attributes.getValue("relation"), column2);
            if (this.inSubreportJoins) {
                ((Subreport)this.getReport()).addJoin(join);
            } else {
                this.getReport().getDataSource().getQuery().addJoin(join);
            }
        }
    }

    protected void sort(Attributes attributes) {
        String string = attributes.getValue("column");
        Selectable selectable = null;
        if (string != null) {
            selectable = this.findColumn(string.trim());
            if (selectable == null) {
                this.group = null;
                return;
            }
        } else {
            selectable = this.findSelectable(attributes.getValue("groupable-id").trim(), attributes.getValue("groupable-type").trim());
        }
        if (selectable != null) {
            String string2 = attributes.getValue("order");
            int n = string2 != null && string2.length() > 0 && string2.charAt(0) == 'd' ? 0 : 1;
            this.getReport().getDataSource().getQuery().addSort(selectable, n);
        }
    }

    protected void subreport(Attributes attributes) {
        this.subreport = new Subreport(this.report, new Long(attributes.getValue("id")));
        this.removeReportSections();
        try {
            Database database = (Database)this.report.getDataSource();
            this.subreport.setDataSource(new SubreportDatabase(database.getConnection(), this.subreport));
        }
        catch (Exception exception) {
            ErrorHandler.error(I18N.get("ReportReader.db_err"), exception, I18N.get("ReportReader.db_err_title"));
        }
    }

    protected void parameter(Attributes attributes) throws SAXException {
        this.parameter = new Parameter(new Long(attributes.getValue("id")), this.getReport(), attributes.getValue("type"), attributes.getValue("name"), attributes.getValue("question"), attributes.getValue("arity"));
        this.getReport().addParameter(this.parameter);
    }

    protected void formula(String string, Attributes attributes) throws SAXException {
        Object object;
        String string2 = attributes.getValue("id");
        String string3 = attributes.getValue("name");
        Long l = null;
        if (string2 == null) {
            if (this.dtdVersion >= 0.2) {
                String string4 = I18N.get("ReportReader.the_formula") + ' ' + string3 + ' ' + I18N.get("ReportReader.formula_missing_id_err");
                throw new SAXException(string4);
            }
        } else {
            l = new Long(string2);
        }
        if ("formulas".equals(string)) {
            this.formula = new Formula(l, this.getReport(), string3, null);
            this.getReport().addFormula(this.formula);
        } else if ("suppression-proc".equals(string)) {
            this.formula = this.section.getSuppressionProc().getFormula();
        } else {
            this.formula = new Formula(l, this.getReport(), string3, null);
            this.getReport().setStartFormula(this.formula);
        }
        if (l == null) {
            if (this.formulasToConvert == null) {
                this.formulasToConvert = new HashMap();
            }
            object = new FormulaConversion(this.formula, null);
            this.formulasToConvert.put(this.formula.getName(), object);
        }
        if ((object = attributes.getValue("language")) != null) {
            this.formula.setLanguage((String)object);
        }
    }

    protected void usercol(Attributes attributes) throws SAXException {
        this.usercol = new UserColumn(new Long(attributes.getValue("id")), this.getReport(), attributes.getValue("name"), null);
        this.getReport().addUserColumn(this.usercol);
    }

    protected void convertFormulas() throws SAXException {
        if (this.formulasToConvert != null) {
            Iterator iterator = this.formulasToConvert.values().iterator();
            while (iterator.hasNext()) {
                FormulaConversion formulaConversion = (FormulaConversion)iterator.next();
                Formula formula = formulaConversion.formula;
                try {
                    formula.setEditableExpression(formulaConversion.expression);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string = I18N.get("ReportReader.the_formula") + ' ' + formula.getName() + ' ' + I18N.get("ReportReader.formula_unknown_name");
                    throw new SAXException(string);
                }
            }
        }
    }

    protected void group(Attributes attributes) {
        String string = attributes.getValue("column");
        Selectable selectable = null;
        if (string != null) {
            selectable = this.findColumn(string.trim());
            if (selectable == null) {
                this.group = null;
                return;
            }
        } else {
            selectable = this.findSelectable(attributes.getValue("groupable-id").trim(), attributes.getValue("groupable-type").trim());
        }
        this.group = new Group(this.getReport(), selectable);
        String string2 = attributes.getValue("sort-order");
        if (string2 != null) {
            this.group.setSortOrder(Group.sortOrderStringToInt(string2.trim()));
        }
        this.getReport().groups.add(this.group);
    }

    protected void section(Attributes attributes) {
        this.section = new Section(this.getReport());
        this.section.setMinHeight(Double.parseDouble(attributes.getValue("height")));
        String string = attributes.getValue("suppressed");
        if ("true".equals(string)) {
            this.section.getSuppressionProc().setHidden(true);
        }
        string = attributes.getValue("pagebreak");
        this.section.setPageBreak("true".equals(string));
        this.addSectionToReport();
    }

    protected void addSectionToReport() {
        switch (this.nextSectionLocation) {
            case 5: {
                if (this.group == null) break;
                this.group.headers().add(this.section);
                break;
            }
            case 6: {
                if (this.group == null) break;
                this.group.footers().add(this.section);
                break;
            }
            default: {
                this.getReport().getSectionArea(this.nextSectionLocation).add(this.section);
            }
        }
    }

    protected void field(Attributes attributes) {
        Formula formula;
        if (this.section == null) {
            this.field = this.report.getDefaultField();
            return;
        }
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("type");
        Object object = attributes.getValue("value");
        String string3 = attributes.getValue("visible");
        boolean bl = true;
        if (string3 != null && (string3 = string3.trim().toLowerCase()).length() > 0) {
            bl = "true".equals(string3);
        }
        if ("column".equals(string2) && this.findColumn(object.toString()) == null) {
            this.field = null;
            return;
        }
        if ("formula".equals(string2) && this.formulasToConvert != null && object != null && (formula = ((FormulaConversion)this.formulasToConvert.get((Object)object)).formula) != null) {
            object = formula.getId();
        }
        this.field = Field.create(new Long(string), this.getReport(), this.section, string2, object, bl);
        if (this.field instanceof AggregateField && this.group != null) {
            ((AggregateField)this.field).setGroup(this.group);
        }
        this.section.addField(this.field);
    }

    protected void bounds(Attributes attributes) {
        if (this.field != null) {
            this.field.getBounds().setBounds(Double.parseDouble(attributes.getValue("x")), Double.parseDouble(attributes.getValue("y")), Double.parseDouble(attributes.getValue("width")), Double.parseDouble(attributes.getValue("height")));
        }
    }

    protected void format(Attributes attributes) {
        if (this.field == null) {
            return;
        }
        Format format = this.field.getFormat();
        String string = attributes.getValue("font");
        if (string != null) {
            format.setFontFamilyName(string);
        }
        if ((string = attributes.getValue("size")) != null) {
            format.setSize(Double.parseDouble(string));
        }
        if ((string = attributes.getValue("bold")) != null) {
            format.setBold("true".equals(string));
        }
        if ((string = attributes.getValue("italic")) != null) {
            format.setItalic("true".equals(string));
        }
        if ((string = attributes.getValue("underline")) != null) {
            format.setUnderline("true".equals(string));
        }
        if ((string = attributes.getValue("wrap")) != null) {
            format.setWrap("true".equals(string));
        }
        if ((string = attributes.getValue("align")) != null) {
            format.setAlign(Format.alignFromString(string));
        }
        if ((string = attributes.getValue("color")) != null) {
            format.setColor(this.parseColor(string));
        }
        if ((string = attributes.getValue("format")) != null) {
            format.setFormat(string);
        }
    }

    protected Color parseColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
        return new Color(n, n2, n3, n4);
    }

    protected void border(Attributes attributes) {
        if (this.field != null) {
            this.border = new Border(this.field);
            this.field.setBorder(this.border);
            String string = attributes.getValue("color");
            if (string != null) {
                this.border.setColor(this.parseColor(string));
            }
        }
    }

    protected void edge(Attributes attributes) {
        if (this.field == null) {
            return;
        }
        String string = attributes.getValue("style");
        int n = BorderEdge.styleFromString(string);
        string = attributes.getValue("thickness");
        double d = string == null ? 1.0 : Double.parseDouble(string);
        string = attributes.getValue("number");
        int n2 = string == null ? 1 : Integer.parseInt(string);
        BorderEdge borderEdge = new BorderEdge(n, d, n2);
        String string2 = attributes.getValue("location");
        if ("top".equals(string2)) {
            this.border.setTop(borderEdge);
        } else if ("bottom".equals(string2)) {
            this.border.setBottom(borderEdge);
        } else if ("left".equals(string2)) {
            this.border.setLeft(borderEdge);
        } else if ("right".equals(string2)) {
            this.border.setRight(borderEdge);
        }
    }

    protected void line(Attributes attributes) {
        String string = attributes.getValue("thickness");
        double d = string == null ? 1.0 : Double.parseDouble(string);
        Color color = null;
        string = attributes.getValue("color");
        if (string != null) {
            color = this.parseColor(string);
        }
        string = attributes.getValue("visible");
        boolean bl = true;
        if (string != null && (string = string.trim().toLowerCase()).length() > 0) {
            bl = "true".equals(string);
        }
        this.line = new Line(this.getReport(), this.section, d, color, bl);
        this.section.lines.add(this.line);
    }

    protected void point(Attributes attributes) {
        this.line.addEndPoint(Double.parseDouble(attributes.getValue("x")), Double.parseDouble(attributes.getValue("y")));
    }

    protected void paper(Attributes attributes) {
        PaperFormat paperFormat;
        int n = 0;
        String string = attributes.getValue("orientation");
        if (string != null && "landscape".equals(string.toLowerCase())) {
            n = 1;
        }
        if ((paperFormat = PaperFormat.get(n, attributes.getValue("name"))) != null) {
            this.getReport().setPaperFormat(paperFormat);
        }
    }

    protected void suppressionProc(Attributes attributes) {
        String string = attributes.getValue("hide");
        if (string != null && string.length() > 0) {
            SuppressionProc suppressionProc = this.section.getSuppressionProc();
            if ("true".equals(string = string.trim().toLowerCase())) {
                suppressionProc.setHidden(true);
            }
        }
    }

    protected Column findColumn(String string) {
        Column column = this.getReport().findColumn(string);
        if (column == null && !this.missingColumnSeen) {
            this.missingColumnSeen = true;
            ErrorHandler.error(I18N.get("ReportReader.the_column") + ' ' + string + ' ' + I18N.get("ReportReader.column_unknown"));
        }
        return column;
    }

    protected Selectable findSelectable(String string, String string2) {
        Selectable selectable = this.getReport().findSelectable(string, string2);
        if (selectable == null && !this.missingColumnSeen) {
            this.missingColumnSeen = true;
            ErrorHandler.error(I18N.get("ReportReader.the_column") + ' ' + string + " (" + string2 + ") " + I18N.get("ReportReader.column_unknown"));
        }
        return selectable;
    }

    static class FormulaConversion {
        Formula formula;
        String expression;

        FormulaConversion(Formula formula, String string) {
            this.formula = formula;
            this.expression = string;
        }
    }
}

