/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jimm.datavision.ErrorHandler;
import jimm.datavision.FieldWalker;
import jimm.datavision.Formula;
import jimm.datavision.Group;
import jimm.datavision.Identity;
import jimm.datavision.ListWriter;
import jimm.datavision.Nameable;
import jimm.datavision.PaperFormat;
import jimm.datavision.Parameter;
import jimm.datavision.ParameterReader;
import jimm.datavision.ReportReader;
import jimm.datavision.ReportSectionLoc;
import jimm.datavision.Scripting;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.SectionWalker;
import jimm.datavision.Selectable;
import jimm.datavision.Subreport;
import jimm.datavision.UserCancellationException;
import jimm.datavision.UserColumn;
import jimm.datavision.Writeable;
import jimm.datavision.field.AggregateField;
import jimm.datavision.field.Border;
import jimm.datavision.field.ColumnField;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.field.FormulaField;
import jimm.datavision.field.ParameterField;
import jimm.datavision.field.SpecialField;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.StatusDialog;
import jimm.datavision.gui.parameter.ParamAskWin;
import jimm.datavision.gui.sql.DbPasswordDialog;
import jimm.datavision.layout.LayoutEngine;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.sql.Database;
import jimm.util.I18N;
import jimm.util.XMLWriter;
import org.apache.bsf.BSFException;
import org.xml.sax.InputSource;

public class Report
implements Nameable,
Writeable {
    public static final String XML_JAVA_ENCODING = "UTF8";
    public static final String XML_ENCODING_ATTRIBUTE = "UTF-8";
    protected static final double OUTPUT_DTD_VERSION = 1.2;
    protected String name;
    protected String title;
    protected String author;
    protected String description;
    protected Formula startFormula;
    protected DataSource dataSource;
    protected HashMap formulas = new HashMap();
    protected HashMap parameters = new HashMap();
    protected HashMap usercols = new HashMap();
    protected HashMap subreports = new HashMap();
    protected ArrayList groups = new ArrayList();
    protected SectionArea reportHeaders;
    protected SectionArea reportFooters;
    protected SectionArea pageHeaders;
    protected SectionArea pageFooters;
    protected SectionArea details;
    protected DataCursor rset;
    protected LayoutEngine layoutEngine;
    protected PaperFormat paperFormat;
    protected Collection aggregateFields;
    protected String databasePassword;
    protected boolean askedForParameters = false;
    protected boolean parametersHaveValues = false;
    protected boolean paramsSetManually = false;
    protected boolean dataSourceHasFile = false;
    protected ParameterReader paramReader;
    protected boolean caseSensitiveDatabaseNames = true;
    protected Scripting scripting;
    protected Field defaultField;

    public Report() {
        this.name = I18N.get("Report.default_name");
        this.title = I18N.get("Report.default_title");
        this.paperFormat = PaperFormat.getDefault();
        this.scripting = new Scripting(this);
        this.defaultField = Field.create(new Long(0L), this, null, "text", I18N.get("Report.default_field_name"), true);
        this.defaultField.setFormat(Format.createDefaultFormat());
        this.defaultField.setBorder(new Border(this.defaultField));
        this.initializeSections();
    }

    public void initializeSections() {
        this.reportHeaders = new SectionArea(0);
        this.reportFooters = new SectionArea(1);
        this.pageHeaders = new SectionArea(2);
        this.pageFooters = new SectionArea(3);
        this.details = new SectionArea(4);
        this.reportHeaders.add(new Section(this));
        this.pageHeaders.add(new Section(this));
        this.pageFooters.add(new Section(this));
        this.reportFooters.add(new Section(this));
        this.details.add(new Section(this));
    }

    public void setLayoutEngine(LayoutEngine layoutEngine) {
        this.layoutEngine = layoutEngine;
        this.layoutEngine.setReport(this);
    }

    protected Long generateNewId(Iterator iterator) {
        long l = 0L;
        while (iterator.hasNext()) {
            Object object = ((Identity)iterator.next()).getId();
            long l2 = (Long)object;
            if (l2 <= l) continue;
            l = l2;
        }
        return new Long(l + 1L);
    }

    public Long generateNewFormulaId() {
        return this.generateNewId(this.formulas.values().iterator());
    }

    public Long generateNewParameterId() {
        return this.generateNewId(this.parameters.values().iterator());
    }

    public Long generateNewUserColumnId() {
        return this.generateNewId(this.usercols.values().iterator());
    }

    public Long generateNewSubreportId() {
        return this.generateNewId(this.subreports.values().iterator());
    }

    public Field findField(final Object object) {
        final Field[] fieldArray = new Field[]{null};
        this.withSectionsDo(new SectionWalker(){

            public void step(Section section) {
                Field field = section.findField(object);
                if (field != null) {
                    fieldArray[0] = field;
                }
            }
        });
        return fieldArray[0];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Formula getStartFormula() {
        return this.startFormula;
    }

    public void setStartFormula(Formula formula) {
        this.startFormula = formula;
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    public Object eval(String string, String string2, String string3) throws BSFException {
        return this.scripting.eval(string, string2, string3);
    }

    public Object value(String string) {
        Column column;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (string.charAt(0) == '{') {
            if (string.length() == 1) {
                return null;
            }
            int n = string.indexOf(125);
            switch (string.charAt(1)) {
                case '@': {
                    Formula formula = this.findFormulaByName(string.substring(2, n));
                    if (formula == null) {
                        return null;
                    }
                    return formula.evaluate(null);
                }
                case '?': {
                    Parameter parameter = this.findParameterByName(string.substring(2, n));
                    if (parameter == null) {
                        return null;
                    }
                    return parameter.getValue();
                }
                case '%': {
                    return SpecialField.value(null, string.substring(2, n), this);
                }
                case '!': {
                    UserColumn userColumn = this.findUserColumnByName(string.substring(2, n));
                    if (userColumn == null) {
                        return null;
                    }
                    return userColumn.getValue(this);
                }
            }
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            string = string.substring(1, string.length() - 1);
        }
        if ((column = this.findColumn(string)) == null) {
            return null;
        }
        return this.columnValue(column);
    }

    public Field getDefaultField() {
        return this.defaultField;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean hasDataSource() {
        return this.dataSource != null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseConnection(Connection connection) throws SQLException {
        this.dataSource = new Database(connection, this);
        this.databasePassword = "";
    }

    public boolean caseSensitiveDatabaseNames() {
        return this.caseSensitiveDatabaseNames;
    }

    public void setCaseSensitiveDatabaseNames(boolean bl) {
        this.caseSensitiveDatabaseNames = bl;
    }

    public void reloadColumns() {
        Iterator iterator = this.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            group.reloadSelectable(this.dataSource);
        }
        this.withFieldsDo(new FieldWalker(){

            public void step(Field field) {
                if (field instanceof ColumnField) {
                    ColumnField columnField = (ColumnField)field;
                    columnField.setColumn(Report.this.dataSource.findColumn(columnField.getColumn().getId()));
                }
            }
        });
        this.dataSource.reloadColumns();
    }

    public Column findColumn(String string) {
        return this.dataSource.findColumn(string);
    }

    public PaperFormat getPaperFormat() {
        return this.paperFormat;
    }

    public void setPaperFormat(PaperFormat paperFormat) {
        this.paperFormat = paperFormat;
    }

    public void add(Object object) {
        if (object instanceof Parameter) {
            this.addParameter((Parameter)object);
        } else if (object instanceof Formula) {
            this.addFormula((Formula)object);
        } else if (object instanceof UserColumn) {
            this.addUserColumn((UserColumn)object);
        } else if (object instanceof Group) {
            this.addGroup((Group)object);
        } else {
            ErrorHandler.error(I18N.get("Report.add_err_1") + ' ' + object.getClass().getName() + ' ' + I18N.get("Report.add_err_2"));
        }
    }

    public void remove(Object object) {
        if (object instanceof Field) {
            this.removeField((Field)object);
        } else if (object instanceof Formula) {
            this.removeFormula((Formula)object);
        } else if (object instanceof Parameter) {
            this.removeParameter((Parameter)object);
        } else if (object instanceof UserColumn) {
            this.removeUserColumn((UserColumn)object);
        } else if (object instanceof Group) {
            this.removeGroup((Group)object);
        } else if (object instanceof Section) {
            this.removeSection((Section)object);
        } else {
            ErrorHandler.error(I18N.get("Report.remove_err_1") + ' ' + object.getClass().getName() + I18N.get("Report.remove_err_2"));
        }
    }

    public Parameter findParameter(Object object) {
        if (object instanceof String) {
            object = new Long((String)object);
        }
        return (Parameter)this.parameters.get(object);
    }

    public Parameter findParameterByName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.toLowerCase();
        Iterator iterator = this.parameters.values().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!string.equals(parameter.getName().toLowerCase())) continue;
            return parameter;
        }
        return null;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.put(parameter.getId(), parameter);
    }

    public void removeParameter(Parameter parameter) {
        this.parameters.remove(parameter.getId());
    }

    public Iterator parameters() {
        return this.parameters.values().iterator();
    }

    public Formula findFormula(Object object) {
        if (object instanceof String) {
            object = new Long((String)object);
        }
        return (Formula)this.formulas.get(object);
    }

    public Formula findFormulaByName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.toLowerCase();
        Iterator iterator = this.formulas.values().iterator();
        while (iterator.hasNext()) {
            Formula formula = (Formula)iterator.next();
            if (!string.equals(formula.getName().toLowerCase())) continue;
            return formula;
        }
        return null;
    }

    public void addFormula(Formula formula) {
        this.formulas.put(formula.getId(), formula);
    }

    public void removeFormula(Formula formula) {
        this.formulas.remove(formula.getId());
    }

    public Iterator formulas() {
        return this.formulas.values().iterator();
    }

    public UserColumn findUserColumn(Object object) {
        if (object instanceof String) {
            object = new Long((String)object);
        }
        return (UserColumn)this.usercols.get(object);
    }

    public UserColumn findUserColumnByName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.toLowerCase();
        Iterator iterator = this.usercols.values().iterator();
        while (iterator.hasNext()) {
            UserColumn userColumn = (UserColumn)iterator.next();
            if (!string.equals(userColumn.getName().toLowerCase())) continue;
            return userColumn;
        }
        return null;
    }

    public void addUserColumn(UserColumn userColumn) {
        this.usercols.put(userColumn.getId(), userColumn);
    }

    public void removeUserColumn(UserColumn userColumn) {
        this.usercols.remove(userColumn.getId());
    }

    public Iterator userColumns() {
        return this.usercols.values().iterator();
    }

    public Subreport findSubreport(Object object) {
        if (object instanceof String) {
            object = new Long((String)object);
        }
        return (Subreport)this.subreports.get(object);
    }

    public void addSubreport(Subreport subreport) {
        this.subreports.put(subreport.getId(), subreport);
    }

    public void removeSubreport(Subreport subreport) {
        this.subreports.remove(subreport.getId());
    }

    public Iterator subreports() {
        return this.subreports.values().iterator();
    }

    public Selectable findSelectable(Object object, String string) {
        if ("column".equals(string)) {
            return this.findColumn(object.toString());
        }
        return this.findUserColumn(object);
    }

    public SectionArea getSectionArea(int n) {
        switch (n) {
            case 0: {
                return this.reportHeaders;
            }
            case 1: {
                return this.reportFooters;
            }
            case 2: {
                return this.pageHeaders;
            }
            case 3: {
                return this.pageFooters;
            }
            case 4: {
                return this.details;
            }
        }
        return null;
    }

    public boolean contains(Section section) {
        return section.getArea() != null;
    }

    public Section getFirstSectionByArea(int n) {
        switch (n) {
            case 5: {
                if (this.groups.isEmpty()) {
                    return null;
                }
                return ((Group)this.groups.get(0)).headers().first();
            }
            case 6: {
                if (this.groups.isEmpty()) {
                    return null;
                }
                return ((Group)this.groups.get(0)).footers().first();
            }
        }
        return this.getSectionArea(n).first();
    }

    public ReportSectionLoc getSectionLocation(Section section) {
        SectionArea sectionArea = section.getArea();
        return new ReportSectionLoc(section, sectionArea, sectionArea.indexOf(section));
    }

    public void reinsertSection(ReportSectionLoc reportSectionLoc) {
        reportSectionLoc.area.add(reportSectionLoc.index, reportSectionLoc.section);
    }

    public SectionArea headers() {
        return this.reportHeaders;
    }

    public SectionArea footers() {
        return this.reportFooters;
    }

    public SectionArea pageHeaders() {
        return this.pageHeaders;
    }

    public SectionArea pageFooters() {
        return this.pageFooters;
    }

    public SectionArea details() {
        return this.details;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
        this.dataSource.removeSort(group.getSelectable());
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public void removeAllGroups() {
        this.groups.clear();
    }

    public Iterator groups() {
        return this.groups.iterator();
    }

    public int countGroups() {
        return this.groups.size();
    }

    public boolean hasGroups() {
        return this.countGroups() > 0;
    }

    public Group innermostGroup() {
        return this.groups.size() > 0 ? (Group)this.groups.get(this.groups.size() - 1) : null;
    }

    public Iterator groupsReversed() {
        ArrayList arrayList = (ArrayList)this.groups.clone();
        Collections.reverse(arrayList);
        return arrayList.iterator();
    }

    public void removeField(Field field) {
        Section section = this.sectionContaining(field);
        if (section != null) {
            section.removeField(field);
        }
    }

    public boolean contains(Field field) {
        return this.sectionContaining(field) != null;
    }

    public Section sectionContaining(Field field) {
        Iterator iterator;
        Section section;
        Iterator iterator2 = this.reportHeaders.iterator();
        while (iterator2.hasNext()) {
            section = (Section)iterator2.next();
            if (!section.contains(field)) continue;
            return section;
        }
        iterator2 = this.pageHeaders.iterator();
        while (iterator2.hasNext()) {
            section = (Section)iterator2.next();
            if (!section.contains(field)) continue;
            return section;
        }
        iterator2 = this.groups.iterator();
        while (iterator2.hasNext()) {
            iterator = ((Group)iterator2.next()).headers().iterator();
            while (iterator.hasNext()) {
                section = (Section)iterator.next();
                if (!section.contains(field)) continue;
                return section;
            }
        }
        iterator2 = this.details.iterator();
        while (iterator2.hasNext()) {
            section = (Section)iterator2.next();
            if (!section.contains(field)) continue;
            return section;
        }
        iterator2 = this.groups.iterator();
        while (iterator2.hasNext()) {
            iterator = ((Group)iterator2.next()).footers().iterator();
            while (iterator.hasNext()) {
                section = (Section)iterator.next();
                if (!section.contains(field)) continue;
                return section;
            }
        }
        iterator2 = this.reportFooters.iterator();
        while (iterator2.hasNext()) {
            section = (Section)iterator2.next();
            if (!section.contains(field)) continue;
            return section;
        }
        iterator2 = this.pageFooters.iterator();
        while (iterator2.hasNext()) {
            section = (Section)iterator2.next();
            if (!section.contains(field)) continue;
            return section;
        }
        return null;
    }

    public boolean containsReferenceTo(final Field field) {
        if (this.startFormula != null && this.startFormula.refersTo(field)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        this.withSectionsDo(new SectionWalker(){

            public void step(Section section) {
                if (section.containsReferenceTo(field)) {
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    public boolean containsReferenceTo(final Formula formula) {
        if (this.startFormula != null && this.startFormula.refersTo(formula)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        this.withSectionsDo(new SectionWalker(){

            public void step(Section section) {
                if (section.containsReferenceTo(formula)) {
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    public boolean containsReferenceTo(final UserColumn userColumn) {
        if (this.startFormula != null && this.startFormula.refersTo(userColumn)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        this.withSectionsDo(new SectionWalker(){

            public void step(Section section) {
                if (section.containsReferenceTo(userColumn)) {
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    public boolean containsReferenceTo(final Parameter parameter) {
        if (this.startFormula != null && this.startFormula.refersTo(parameter)) {
            return true;
        }
        if (this.dataSource.containsReferenceTo(parameter)) {
            return true;
        }
        final boolean[] blArray = new boolean[]{false};
        this.withSectionsDo(new SectionWalker(){

            public void step(Section section) {
                if (section.containsReferenceTo(parameter)) {
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    protected List collectUsedParameters() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        Iterator iterator = this.parameters.values().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!this.containsReferenceTo(parameter)) continue;
            arrayList.add(parameter);
        }
        return arrayList;
    }

    public Group findGroup(Selectable selectable) {
        Iterator iterator = this.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (group.getSelectable() != selectable) continue;
            return group;
        }
        return null;
    }

    public Group findGroup(Section section) {
        Iterator iterator = this.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (!group.contains(section)) continue;
            return group;
        }
        return null;
    }

    public boolean isInsideGroup(Section section) {
        return this.findGroup(section) != null;
    }

    public boolean isUsedBySomeGroup(Selectable selectable) {
        return this.findGroup(selectable) != null;
    }

    public Section insertSectionBelow(Section section) {
        return this.insertSectionBelow(null, section);
    }

    public Section insertSectionBelow(Section section, Section section2) {
        if (section == null) {
            section = new Section(this);
        }
        if (section2 == null) {
            return this.reportHeaders.insertAfter(section, null);
        }
        if (this.reportHeaders.contains(section2)) {
            return this.reportHeaders.insertAfter(section, section2);
        }
        if (this.reportFooters.contains(section2)) {
            return this.reportFooters.insertAfter(section, section2);
        }
        if (this.pageHeaders.contains(section2)) {
            return this.pageHeaders.insertAfter(section, section2);
        }
        if (this.pageFooters.contains(section2)) {
            return this.pageFooters.insertAfter(section, section2);
        }
        if (this.details.contains(section2)) {
            return this.details.insertAfter(section, section2);
        }
        Iterator iterator = this.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (group.headers().contains(section2)) {
                return group.headers().insertAfter(section, section2);
            }
            if (!group.footers().contains(section2)) continue;
            return group.footers().insertAfter(section, section2);
        }
        return null;
    }

    public void removeSection(Section section) {
        if (this.reportHeaders.contains(section)) {
            this.reportHeaders.remove(section);
        } else if (this.reportFooters.contains(section)) {
            this.reportFooters.remove(section);
        } else if (this.pageHeaders.contains(section)) {
            this.pageHeaders.remove(section);
        } else if (this.pageFooters.contains(section)) {
            this.pageFooters.remove(section);
        } else if (this.details.contains(section)) {
            this.details.remove(section);
        } else {
            Iterator iterator = this.groups();
            while (iterator.hasNext()) {
                Group group = (Group)iterator.next();
                if (group.headers().contains(section)) {
                    group.headers().remove(section);
                    return;
                }
                if (!group.footers().contains(section)) continue;
                group.footers().remove(section);
                return;
            }
        }
    }

    public boolean hasFields() {
        final boolean[] blArray = new boolean[]{false};
        this.withFieldsDo(new FieldWalker(){

            public void step(Field field) {
                blArray[0] = true;
            }
        });
        return blArray[0];
    }

    public boolean hasParameterFields() {
        final boolean[] blArray = new boolean[]{false};
        this.withFieldsDo(new FieldWalker(){

            public void step(Field field) {
                if (field instanceof ParameterField) {
                    blArray[0] = true;
                }
            }
        });
        return blArray[0];
    }

    public boolean isOneOfAKind(Section section) {
        if (this.reportHeaders.contains(section)) {
            return this.reportHeaders.size() == 1;
        }
        if (this.reportFooters.contains(section)) {
            return this.reportFooters.size() == 1;
        }
        if (this.pageHeaders.contains(section)) {
            return this.pageHeaders.size() == 1;
        }
        if (this.pageFooters.contains(section)) {
            return this.pageFooters.size() == 1;
        }
        if (this.details.contains(section)) {
            return this.details.size() == 1;
        }
        Iterator iterator = this.groups();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (group.headers().contains(section)) {
                return group.headers().size() == 1;
            }
            if (!group.footers().contains(section)) continue;
            return group.footers().size() == 1;
        }
        return false;
    }

    public void setDatabasePassword(String string) {
        this.databasePassword = string;
    }

    public void askForPassword(Database database) {
        if (this.databasePassword != null) {
            database.setPassword(this.databasePassword);
            return;
        }
        if (ErrorHandler.usingGUI()) {
            DbPasswordDialog dbPasswordDialog = new DbPasswordDialog(this.getDesignFrame(), database.getName(), database.getUserName());
            database.setUserName(dbPasswordDialog.getUserName());
            database.setPassword(dbPasswordDialog.getPassword());
        } else {
            BufferedReader bufferedReader;
            System.out.print(I18N.get("Report.user_name") + " [" + database.getUserName() + "]: ");
            System.out.flush();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string = bufferedReader.readLine();
                if (string.length() > 0) {
                    database.setUserName(string);
                }
            }
            catch (IOException iOException) {
                ErrorHandler.error(I18N.get("Report.user_name_err"));
            }
            System.out.print(I18N.get("Report.password") + ' ' + database.getUserName() + ": ");
            System.out.flush();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                this.databasePassword = bufferedReader.readLine();
                database.setPassword(this.databasePassword);
            }
            catch (IOException iOException) {
                ErrorHandler.error(I18N.get("Report.password_err"));
            }
        }
    }

    public Object getParameterValue(Object object) {
        if (!this.askedForParameters) {
            this.askForParameters();
        }
        return this.findParameter(object).getValue();
    }

    public void parametersSetManually(boolean bl) {
        this.paramsSetManually = bl;
    }

    protected void askForParameters() throws UserCancellationException {
        List list = null;
        if (this.askedForParameters || this.paramsSetManually || (list = this.collectUsedParameters()).isEmpty()) {
            this.askedForParameters = true;
            return;
        }
        if (ErrorHandler.usingGUI()) {
            if (this.parametersHaveValues) {
                String string = I18N.get("Report.use_prev_param_vals");
                if (JOptionPane.showConfirmDialog(this.getDesignFrame(), string, I18N.get("Report.use_prev_title"), 0) == 0) {
                    this.askedForParameters = true;
                    this.parametersHaveValues = true;
                    return;
                }
            }
            if (new ParamAskWin(this.getDesignFrame(), list).userCancelled()) {
                throw new UserCancellationException(I18N.get("Report.user_cancelled"));
            }
        } else {
            if (this.paramReader == null) {
                ErrorHandler.error(I18N.get("Report.missing_param_xml_file"));
                throw new UserCancellationException(I18N.get("Report.missing_param_xml_file_short"));
            }
            try {
                this.paramReader.read();
                this.paramReader = null;
            }
            catch (Exception exception) {
                ErrorHandler.error(I18N.get("Report.param_file_err_1") + ' ' + this.paramReader.getInputName() + I18N.get("Report.param_file_err_2"), exception);
                throw new UserCancellationException(I18N.get("Report.param_file_err_short"));
            }
        }
        this.askedForParameters = true;
        this.parametersHaveValues = true;
    }

    protected void askForDataSourceFile() throws UserCancellationException, FileNotFoundException {
        String string;
        if (!this.dataSource.needsSourceFile() || !ErrorHandler.usingGUI()) {
            return;
        }
        if (this.dataSourceHasFile) {
            string = I18N.get("Report.use_prev_data_source_file");
            if (JOptionPane.showConfirmDialog(this.getDesignFrame(), string, I18N.get("Report.use_prev_data_source_title"), 0) == 0) {
                this.dataSource.reuseSourceFile();
                return;
            }
        }
        string = Designer.findWindowFor(this) == null ? null : Designer.findWindowFor(this).getFrame();
        JFileChooser jFileChooser = Designer.getChooser();
        int n = jFileChooser.showOpenDialog((Component)((Object)string));
        if (n != 0) {
            throw new UserCancellationException(I18N.get("Report.user_cancelled"));
        }
        this.dataSource.setSourceFile(jFileChooser.getSelectedFile().getPath());
        this.dataSourceHasFile = true;
    }

    public void run() {
        new Thread(new Runnable(){

            public void run() {
                Report.this.runReport();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runReport() {
        Object object;
        block38: {
            Iterator iterator;
            this.askedForParameters = false;
            try {
                this.askForDataSourceFile();
                this.askForParameters();
            }
            catch (UserCancellationException userCancellationException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            object = this.groups.iterator();
            while (object.hasNext()) {
                ((Group)object.next()).reset();
            }
            this.collectAggregateFields();
            if (this.startFormula != null) {
                this.startFormula.eval();
            }
            object = this.formulas();
            while (object.hasNext()) {
                ((Formula)object.next()).useCache();
            }
            this.resetCachedValues();
            this.rset = null;
            object = null;
            try {
                block36: {
                    block37: {
                        try {
                            if (ErrorHandler.usingGUI()) {
                                object = new StatusDialog(this.getDesignFrame(), I18N.get("Report.status_title"), true, I18N.get("Report.status_running"));
                            }
                            if (!this.layoutEngine.wantsMoreData()) {
                                Object var4_4 = null;
                                if (this.rset == null) break block36;
                                break block37;
                            }
                            this.rset = this.dataSource.execute();
                            boolean bl = false;
                            while (this.layoutEngine.wantsMoreData() && this.rset.next()) {
                                if (object != null) {
                                    if (((StatusDialog)object).isCancelled()) {
                                        throw new UserCancellationException();
                                    }
                                    ((StatusDialog)object).update(I18N.get("Report.processing_row") + ' ' + this.rowNumber());
                                }
                                if (!bl) {
                                    this.layoutEngine.start();
                                    bl = true;
                                }
                                this.processResultRow();
                            }
                            this.rset.last();
                            if (!bl) {
                                this.layoutEngine.start();
                                this.layoutEngine.end();
                                break block38;
                            } else {
                                this.layoutEngine.groupFooters(true);
                                this.layoutEngine.end();
                            }
                            break block38;
                        }
                        catch (UserCancellationException userCancellationException) {
                            this.layoutEngine.cancel();
                            Object var4_6 = null;
                            if (this.rset != null) {
                                this.rset.close();
                            }
                            this.aggregateFields = null;
                            Iterator iterator2 = this.groups.iterator();
                            while (true) {
                                if (!iterator2.hasNext()) {
                                    this.resetCachedValues();
                                    if (object == null) return;
                                    ((Window)object).dispose();
                                    return;
                                }
                                ((Group)iterator2.next()).reset();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.layoutEngine.cancel();
                            ErrorHandler.error(this.dataSource.getQuery().toString(), sQLException);
                            Object var4_7 = null;
                            if (this.rset != null) {
                                this.rset.close();
                            }
                            this.aggregateFields = null;
                            Iterator iterator3 = this.groups.iterator();
                            while (true) {
                                if (!iterator3.hasNext()) {
                                    this.resetCachedValues();
                                    if (object == null) return;
                                    ((Window)object).dispose();
                                    return;
                                }
                                ((Group)iterator3.next()).reset();
                            }
                        }
                        catch (Exception exception) {
                            this.layoutEngine.cancel();
                            ErrorHandler.error(exception);
                            Object var4_8 = null;
                            if (this.rset != null) {
                                this.rset.close();
                            }
                            this.aggregateFields = null;
                            Iterator iterator4 = this.groups.iterator();
                            while (true) {
                                if (!iterator4.hasNext()) {
                                    this.resetCachedValues();
                                    if (object == null) return;
                                    ((Window)object).dispose();
                                    return;
                                }
                                ((Group)iterator4.next()).reset();
                            }
                        }
                    }
                    this.rset.close();
                }
                this.aggregateFields = null;
                iterator = this.groups.iterator();
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                if (this.rset != null) {
                    this.rset.close();
                }
                this.aggregateFields = null;
                Iterator iterator5 = this.groups.iterator();
                while (true) {
                    if (!iterator5.hasNext()) {
                        this.resetCachedValues();
                        if (object == null) throw throwable;
                        ((Window)object).dispose();
                        throw throwable;
                    }
                    ((Group)iterator5.next()).reset();
                }
            }
            while (iterator.hasNext()) {
                ((Group)iterator.next()).reset();
            }
            this.resetCachedValues();
            if (object == null) return;
            ((Window)object).dispose();
            return;
        }
        Object var4_5 = null;
        if (this.rset != null) {
            this.rset.close();
        }
        this.aggregateFields = null;
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            ((Group)iterator.next()).reset();
        }
        this.resetCachedValues();
        if (object == null) return;
        ((Window)object).dispose();
    }

    protected Frame getDesignFrame() {
        Designer designer = Designer.findWindowFor(this);
        return designer == null ? null : designer.getFrame();
    }

    protected void processResultRow() throws SQLException {
        this.resetCachedValues();
        this.updateGroups();
        if (!this.rset.isFirst()) {
            this.rset.previous();
            this.layoutEngine.groupFooters(false);
            this.rset.next();
            this.resetCachedValues();
        }
        this.updateGroupCounters();
        this.updateAggregates();
        boolean bl = this.rset.isLast();
        this.layoutEngine.groupHeaders(bl);
        this.layoutEngine.detail(bl);
    }

    protected void resetCachedValues() {
        Iterator iterator = this.formulas();
        while (iterator.hasNext()) {
            ((Formula)iterator.next()).shouldEvaluate();
        }
        iterator = this.subreports();
        while (iterator.hasNext()) {
            ((Subreport)iterator.next()).clearCache();
        }
    }

    public void evaluateFormulasIn(Section section) {
        Iterator iterator = section.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!(field instanceof FormulaField)) continue;
            ((FormulaField)field).getValue();
        }
    }

    public Object columnValue(Selectable selectable) {
        return this.rset.getObject(this.dataSource.indexOfSelectable(selectable) + 1);
    }

    public int pageNumber() {
        return this.layoutEngine.pageNumber();
    }

    public int rowNumber() {
        return this.rset.getRow();
    }

    public DataCursor getCurrentRow() {
        return this.rset;
    }

    public void withSectionsDo(SectionWalker sectionWalker) {
        this.reportHeaders.withSectionsDo(sectionWalker);
        this.pageHeaders.withSectionsDo(sectionWalker);
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            ((Group)iterator.next()).headers().withSectionsDo(sectionWalker);
        }
        this.details.withSectionsDo(sectionWalker);
        iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            ((Group)iterator.next()).footers().withSectionsDo(sectionWalker);
        }
        this.reportFooters.withSectionsDo(sectionWalker);
        this.pageFooters.withSectionsDo(sectionWalker);
    }

    public void withFieldsDo(final FieldWalker fieldWalker) {
        this.withSectionsDo(new SectionWalker(){

            public void step(Section section) {
                Iterator iterator = section.fields();
                while (iterator.hasNext()) {
                    fieldWalker.step((Field)iterator.next());
                }
            }
        });
    }

    protected void collectAggregateFields() {
        this.aggregateFields = new ArrayList();
        this.withFieldsDo(new FieldWalker(){

            public void step(Field field) {
                if (field instanceof AggregateField) {
                    ((AggregateField)field).initialize();
                    Report.this.aggregateFields.add(field);
                }
            }
        });
    }

    public AbstractList getAggregateFieldsFor(final Field field) {
        final ArrayList arrayList = new ArrayList();
        this.withFieldsDo(new FieldWalker(){

            public void step(Field field2) {
                if (field2 instanceof AggregateField && ((AggregateField)field2).getField() == field) {
                    arrayList.add(field2);
                }
            }
        });
        return arrayList;
    }

    protected void updateAggregates() {
        Iterator iterator = this.aggregateFields.iterator();
        while (iterator.hasNext()) {
            ((AggregateField)iterator.next()).updateAggregate();
        }
    }

    protected void updateGroups() {
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            group.setValue(this);
        }
    }

    protected void updateGroupCounters() {
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            group.updateCounter();
        }
    }

    public void setParameterXMLInput(File file) {
        this.paramReader = new ParameterReader(this, file);
    }

    public void setParameterXMLInput(InputSource inputSource) {
        this.paramReader = new ParameterReader(this, inputSource);
    }

    public void read(File file) throws Exception {
        new ReportReader(this).read(file);
    }

    public void read(InputSource inputSource) throws Exception {
        new ReportReader(this).read(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new XMLWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), XML_JAVA_ENCODING));
            this.writeXML((XMLWriter)printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            ErrorHandler.error(I18N.get("Report.write_err") + ' ' + string, iOException, I18N.get("Report.write_err_title"));
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXMLDecl(xMLWriter);
        this.writeComment(xMLWriter);
        this.writeReport(xMLWriter);
    }

    protected void writeXMLDecl(XMLWriter xMLWriter) {
        xMLWriter.xmlDecl(XML_ENCODING_ATTRIBUTE);
    }

    protected void writeComment(XMLWriter xMLWriter) {
        xMLWriter.comment("Generated by DataVision version 1.0.0");
        xMLWriter.comment("http://datavision.sourceforge.net");
    }

    protected void writeReport(XMLWriter xMLWriter) {
        xMLWriter.startElement("report");
        xMLWriter.attr("dtd-version", 1.2);
        xMLWriter.attr("name", this.name);
        xMLWriter.attr("title", this.title);
        xMLWriter.attr("author", this.author);
        this.writeDescription(xMLWriter);
        this.scripting.writeXML(xMLWriter);
        this.writeStartFormula(xMLWriter);
        this.paperFormat.writeXML(xMLWriter);
        this.defaultField.writeXML(xMLWriter);
        ListWriter.writeList(xMLWriter, this.usercols.values(), "usercols");
        this.dataSource.writeXML(xMLWriter);
        ListWriter.writeList(xMLWriter, this.subreports.values(), "subreports");
        ListWriter.writeList(xMLWriter, this.parameters.values(), "parameters");
        ListWriter.writeList(xMLWriter, this.formulas.values(), "formulas");
        ListWriter.writeList(xMLWriter, this.reportHeaders.sections(), "headers");
        ListWriter.writeList(xMLWriter, this.reportFooters.sections(), "footers");
        this.writePage(xMLWriter);
        ListWriter.writeList(xMLWriter, this.groups, "groups");
        ListWriter.writeList(xMLWriter, this.details.sections(), "details");
        xMLWriter.endElement();
    }

    protected void writeDescription(XMLWriter xMLWriter) {
        xMLWriter.cdataElement("description", this.description);
    }

    protected void writeStartFormula(XMLWriter xMLWriter) {
        if (this.startFormula != null) {
            this.startFormula.writeXML(xMLWriter);
        }
    }

    protected void writePage(XMLWriter xMLWriter) {
        if (this.pageHeaders.isEmpty() && this.pageFooters.isEmpty()) {
            return;
        }
        xMLWriter.startElement("page");
        ListWriter.writeList(xMLWriter, this.pageHeaders.sections(), "headers");
        ListWriter.writeList(xMLWriter, this.pageFooters.sections(), "footers");
        xMLWriter.endElement();
    }
}

