/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.util.Observable;
import jimm.datavision.Writeable;
import jimm.util.XMLWriter;

public class Point
extends Observable
implements Writeable {
    public double x;
    public double y;

    public Point() {
        this(0.0, 0.0);
    }

    public Point(java.awt.Point point) {
        this(point.x, point.y);
    }

    public Point(Point point) {
        this(point.x, point.y);
    }

    public Point(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        if (this.x != d) {
            this.x = d;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        if (this.y != d) {
            this.y = d;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void translate(java.awt.Point point) {
        this.translate(point.x, point.y);
    }

    public void translate(Point point) {
        this.translate(point.x, point.y);
    }

    public void translate(double d, double d2) {
        if (d != 0.0 && d2 != 0.0) {
            this.x += d;
            this.y += d2;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public double distanceTo(Point point) {
        double d = point.x - this.x;
        double d2 = point.y - this.y;
        if (d == 0.0) {
            return Math.abs(d2);
        }
        if (d2 == 0.0) {
            return Math.abs(d);
        }
        return Math.sqrt(d * d + d2 * d2);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("point");
        xMLWriter.attr("x", this.x);
        xMLWriter.attr("y", this.y);
        xMLWriter.endElement();
    }
}

