/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.util.I18N;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParameterReader
extends DefaultHandler {
    protected static final double DEFAULT_DTD_VERSION = 0.1;
    protected Report report;
    protected Parameter parameter;
    protected String textData;
    protected File inFile;
    protected InputSource inInputSource;

    public ParameterReader(Report report, File file) {
        this.report = report;
        this.inFile = file;
    }

    public ParameterReader(Report report, InputSource inputSource) {
        this.report = report;
        this.inInputSource = inputSource;
    }

    public String getInputName() {
        if (this.inFile != null) {
            return this.inFile.getPath();
        }
        if (this.inInputSource != null) {
            return "org.xml.sax.InputSource";
        }
        return "?";
    }

    public void read() throws Exception {
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        if (this.inFile != null) {
            sAXParser.parse(this.inFile, (DefaultHandler)this);
        } else if (this.inInputSource != null) {
            sAXParser.parse(this.inInputSource, (DefaultHandler)this);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.length() == 0) {
            string4 = string3;
        }
        if (this.textData == null || this.textData.length() > 0) {
            this.textData = new String();
        }
        if ("parameter".equals(string4)) {
            String string5 = attributes.getValue("id");
            this.parameter = this.report.findParameter(string5);
            if (this.parameter == null) {
                ErrorHandler.error(I18N.get("ParameterReader.unknown_id") + ' ' + string5 + ' ' + I18N.get("ParameterReader.in_xml"));
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.length() == 0) {
            string4 = string3;
        }
        if ("value".equals(string4) && this.parameter != null) {
            this.parameter.addValue(this.textData);
        } else if ("parameter".equals(string4)) {
            this.parameter = null;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.textData = this.textData + new String(cArray, n, n2);
    }
}

