/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.io.StringWriter;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import jimm.datavision.Draggable;
import jimm.datavision.Identity;
import jimm.datavision.Nameable;
import jimm.datavision.Report;
import jimm.datavision.Writeable;
import jimm.util.I18N;
import jimm.util.XMLWriter;

public class Parameter
extends Observable
implements Identity,
Nameable,
Writeable,
Draggable,
Cloneable {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_NUMERIC = 2;
    public static final int TYPE_DATE = 3;
    public static final int ARITY_ONE = 0;
    public static final int ARITY_RANGE = 1;
    public static final int ARITY_LIST_SINGLE = 2;
    public static final int ARITY_LIST_MULTIPLE = 3;
    protected static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static ParsePosition parsePosition = new ParsePosition(0);
    protected Long id;
    protected Report report;
    protected String name;
    protected String question;
    protected int type;
    protected int arity;
    protected ArrayList defaultValues;
    protected ArrayList values;

    public Parameter(Long l, Report report) {
        this(l, report, "string", "", "", "single");
    }

    public Parameter(Long l, Report report, String string, String string2, String string3, String string4) {
        this.report = report;
        if (string == null || string.length() == 0) {
            String string5 = I18N.get("Parameter.param_cap") + " " + l + ": " + I18N.get("Parameter.missing_type");
            throw new IllegalArgumentException(string5);
        }
        if ("boolean".equals(string = string.toLowerCase().trim())) {
            this.type = 0;
        } else if ("string".equals(string)) {
            this.type = 1;
        } else if ("numeric".equals(string)) {
            this.type = 2;
        } else if ("date".equals(string)) {
            this.type = 3;
        } else {
            String string6 = I18N.get("Parameter.param_cap") + " " + l + ": " + I18N.get("Parameter.illegal_type");
            throw new IllegalArgumentException(string6);
        }
        this.name = string2;
        this.question = string3;
        if (string4 == null || string4.length() == 0) {
            String string7 = I18N.get("Parameter.param_cap") + l + ": " + I18N.get("Parameter.missing_arity");
            throw new IllegalArgumentException(string7);
        }
        if ("single".equals(string4 = string4.toLowerCase().trim())) {
            this.arity = 0;
        } else if ("range".equals(string4)) {
            this.arity = 1;
        } else if ("list-single".equals(string4)) {
            this.arity = 2;
        } else if ("list-multiple".equals(string4)) {
            this.arity = 3;
        } else {
            String string8 = I18N.get("Parameter.param_cap") + l + ": " + I18N.get("Parameter.illegal_arity");
            throw new IllegalArgumentException(string8);
        }
        this.initialize(l);
    }

    public Parameter(Long l, Report report, int n, String string, String string2, int n2) {
        this.report = report;
        this.type = n;
        this.name = string;
        this.question = string2;
        this.arity = n2;
        this.initialize(l);
    }

    private void initialize(Long l) {
        if (l == null) {
            l = this.report.generateNewParameterId();
        }
        this.id = l;
        switch (this.type) {
            case 0: {
                if (this.arity == 0) break;
                String string = I18N.get("Parameter.param_cap") + l + ": " + I18N.get("Parameter.yesno_single");
                throw new IllegalArgumentException(string);
            }
            case 3: {
                if (this.arity == 0 || this.arity == 1) break;
                String string = I18N.get("Parameter.param_cap") + l + ": " + I18N.get("Parameter.date_arity_err");
                throw new IllegalArgumentException(string);
            }
        }
        this.defaultValues = new ArrayList();
        this.values = new ArrayList();
    }

    public Object clone() {
        Parameter parameter = new Parameter(null, this.report, this.type, this.name, this.question, this.arity);
        Iterator iterator = this.defaultValues.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Boolean) {
                parameter.defaultValues.add(e);
                continue;
            }
            if (e instanceof String) {
                parameter.defaultValues.add(new String((String)e));
                continue;
            }
            if (e instanceof Number) {
                parameter.defaultValues.add(e);
                continue;
            }
            if (!(e instanceof Date)) continue;
            parameter.defaultValues.add(((Date)e).clone());
        }
        return parameter;
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(this.name == string || this.name != null && this.name.equals(string))) {
            this.name = string;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String string) {
        if (!(this.question == string || this.question != null && this.question.equals(string))) {
            this.question = string;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (this.type != n) {
            this.type = n;
            this.defaultValues.clear();
            this.values.clear();
            if (this.type == 0) {
                if (this.arity != 0) {
                    this.arity = 0;
                }
            } else if (this.type == 3 && (this.arity == 2 || this.arity == 3)) {
                this.arity = 0;
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isLegal(int n, int n2) {
        switch (n) {
            case 0: {
                return n2 == 0;
            }
            case 3: {
                return n2 != 2 && n2 != 3;
            }
        }
        return true;
    }

    public void setArity(int n) {
        if (this.arity != n) {
            if (this.type == 0) {
                if (n != 0) {
                    String string = I18N.get("Parameter.param_cap") + this.id + ": " + I18N.get("Parameter.yesno_single");
                    throw new IllegalArgumentException(string);
                }
            } else if (this.type == 3 && (n == 2 || n == 3)) {
                String string = I18N.get("Parameter.param_cap") + this.id + ": " + I18N.get("Parameter.date_arity_err");
                throw new IllegalArgumentException(string);
            }
            this.arity = n;
            this.defaultValues.clear();
            this.values.clear();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Iterator defaultValues() {
        return this.defaultValues.iterator();
    }

    public Object getDefaultValue(int n) {
        Object e;
        if (n < 0 || n >= this.defaultValues.size() || (e = this.defaultValues.get(n)) == null) {
            return this.getDefaultForType(this.type);
        }
        return e;
    }

    public Object getDefaultForType(int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return "";
            }
            case 2: {
                return new Integer(0);
            }
            case 3: {
                return new Date();
            }
        }
        String string = I18N.get("Paramter.illegal_type_value");
        throw new IllegalArgumentException(string + " " + n);
    }

    public void removeDefaultValues() {
        if (this.defaultValues.size() > 0) {
            this.defaultValues.clear();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void addDefaultValue(Object object) {
        object = this.convertType(object);
        this.defaultValues.add(object);
        this.setChanged();
        this.notifyObservers();
    }

    public void setDefaultValue(int n, Object object) {
        object = this.convertType(object);
        Object object2 = null;
        if (n < this.defaultValues.size()) {
            object2 = this.getDefaultValue(n);
        }
        if (!(object2 == object || object2 != null && object2.equals(object))) {
            this.defaultValues.add(n, object);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Iterator values() {
        return this.values.iterator();
    }

    public Object getValue() {
        switch (this.arity) {
            case 0: 
            case 2: {
                return this.getValue(0);
            }
            case 1: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.getValue(0));
                arrayList.add(this.getValue(1));
                return arrayList;
            }
            case 3: {
                return this.values.clone();
            }
        }
        return null;
    }

    public Object getValue(int n) {
        Object var2_2 = null;
        if (n < this.values.size()) {
            var2_2 = this.values.get(n);
        }
        if (var2_2 == null && n < this.defaultValues.size()) {
            var2_2 = this.defaultValues.get(n);
        }
        return var2_2;
    }

    public void addValue(Object object) {
        this.values.add(this.convertType(object));
        this.setChanged();
        this.notifyObservers();
    }

    public void removeValues() {
        if (this.values.size() > 0) {
            this.values.clear();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setValue(int n, Object object) {
        this.values.add(n, this.convertType(object));
        this.setChanged();
        this.notifyObservers();
    }

    protected Object convertType(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 0: {
                if (object instanceof Boolean) {
                    return object;
                }
                if (object instanceof String) {
                    if ("true".equals(object = ((String)object).toLowerCase().trim()) || "t".equals(object) || "yes".equals(object) || "y".equals(object)) {
                        return true;
                    }
                    return false;
                }
                if (object instanceof Number) {
                    return ((Number)object).doubleValue() == 0.0;
                }
                return true;
            }
            case 1: {
                return object.toString();
            }
            case 2: {
                if (object instanceof Number) {
                    return object;
                }
                String string = object.toString();
                if (string.length() == 0) {
                    return new Integer(0);
                }
                if (string.indexOf(".") == -1) {
                    return new Integer(string);
                }
                return new Double(string);
            }
            case 3: {
                if (object instanceof Date) {
                    return object;
                }
                String string = object.toString();
                if (string.length() == 0) {
                    return new Date();
                }
                parsePosition.setIndex(0);
                return formatter.parse(string, parsePosition);
            }
        }
        return null;
    }

    protected String typeString() {
        switch (this.type) {
            case 0: {
                return "boolean";
            }
            case 1: {
                return "string";
            }
            case 2: {
                return "numeric";
            }
            case 3: {
                return "date";
            }
        }
        return "unknown";
    }

    public String dragString() {
        return "parameter:" + this.getId();
    }

    public String designLabel() {
        return "{?" + this.getName() + "}";
    }

    public String formulaString() {
        return "{?" + this.getId() + "}";
    }

    public void writeXML(XMLWriter xMLWriter) {
        String string = null;
        switch (this.arity) {
            case 0: {
                string = "single";
                break;
            }
            case 1: {
                string = "range";
                break;
            }
            case 2: {
                string = "list-single";
                break;
            }
            case 3: {
                string = "list-multiple";
            }
        }
        xMLWriter.startElement("parameter");
        xMLWriter.attr("id", this.id);
        xMLWriter.attr("type", this.typeString());
        xMLWriter.attr("name", this.name);
        xMLWriter.attr("question", this.question);
        xMLWriter.attr("arity", string);
        Iterator iterator = this.defaultValues.iterator();
        while (iterator.hasNext()) {
            xMLWriter.textElement("default", iterator.next().toString());
        }
        xMLWriter.endElement();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.writeXML(new XMLWriter(stringWriter));
        return stringWriter.toString();
    }
}

