/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Nameable;
import jimm.datavision.Writeable;
import jimm.util.XMLWriter;

public class PaperFormat
extends Paper
implements Nameable,
Writeable {
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    protected static final String RESOURCE_FILE_PREFIX = "paper";
    protected static HashMap[] orientations = new HashMap[2];
    protected static TreeSet names;
    protected static PaperFormat defaultPaper;
    protected String name;
    protected int orientation;
    protected PageFormat pageFormat;
    protected String latexPaperSizeString;

    private static PaperFormat addPaper(int n, String string, double d, double d2, double d3, double d4, String string2) {
        PaperFormat paperFormat = new PaperFormat(n, string, d, d2, d3, d4, string2);
        orientations[n].put(string, paperFormat);
        return paperFormat;
    }

    public static PaperFormat get(int n, String string) {
        return (PaperFormat)orientations[n].get(string);
    }

    public static PaperFormat getDefault() {
        return defaultPaper;
    }

    public static Iterator names() {
        return names.iterator();
    }

    PaperFormat(int n, String string, double d, double d2, double d3, double d4, String string2) {
        this.orientation = n;
        this.name = string;
        this.latexPaperSizeString = string2;
        this.setSize(d, d2);
        this.setImageableArea(d3, d4, d - d3 / 2.0, d2 - d4 / 2.0);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
    }

    public String getLaTeXPaperSizeString() {
        return this.latexPaperSizeString;
    }

    public PageFormat getPageFormat() {
        if (this.pageFormat == null) {
            this.pageFormat = new PageFormat();
            if (this.orientation == 0) {
                this.pageFormat.setOrientation(1);
                this.pageFormat.setPaper(this);
            } else {
                this.pageFormat.setOrientation(0);
                this.pageFormat.setPaper(PaperFormat.get(0, this.getName()));
            }
        }
        return this.pageFormat;
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement(RESOURCE_FILE_PREFIX);
        xMLWriter.attr("name", this.name);
        xMLWriter.attr("orientation", this.orientation == 0 ? "portrait" : "landscape");
        xMLWriter.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        PaperFormat.orientations[0] = new HashMap();
        PaperFormat.orientations[1] = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_FILE_PREFIX, Locale.getDefault());
        try {
            int n = Integer.parseInt(resourceBundle.getString("num_paper_sizes"));
            for (int i = 0; i < n; ++i) {
                String string = resourceBundle.getString(RESOURCE_FILE_PREFIX + i);
                int n2 = string.indexOf(44);
                int n3 = string.indexOf(44, n2 + 1);
                int n4 = string.indexOf(44, n3 + 1);
                int n5 = string.indexOf(44, n4 + 1);
                int n6 = string.indexOf(44, n5 + 1);
                if (n2 == -1 || n3 == -1 || n4 == -1 || n5 == -1) continue;
                double d = Double.parseDouble(string.substring(n2 + 1, n3));
                double d2 = Double.parseDouble(string.substring(n3 + 1, n4));
                double d3 = Double.parseDouble(string.substring(n4 + 1, n5));
                double d4 = 0.0;
                String string2 = null;
                if (n6 == -1) {
                    d4 = Double.parseDouble(string.substring(n5 + 1));
                } else {
                    d4 = Double.parseDouble(string.substring(n5 + 1, n6));
                    string2 = string.substring(n6 + 1);
                }
                String string3 = string.substring(0, n2);
                arrayList.add(string3);
                PaperFormat paperFormat = PaperFormat.addPaper(0, string3, d, d2, d3, d4, string2);
                PaperFormat.addPaper(1, string3, d2, d, d4, d3, string2);
                if (i != 0) continue;
                defaultPaper = paperFormat;
            }
        }
        catch (Exception exception) {
            ErrorHandler.error(exception);
        }
        finally {
            names = new TreeSet(arrayList);
        }
    }
}

