/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.awt.Color;
import jimm.datavision.Element;
import jimm.datavision.Point;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.util.XMLWriter;

public class Line
extends Element {
    protected static final Color DEFAULT_COLOR = Color.black;
    protected double thickness;
    protected Point[] points;
    protected Color color;

    public Line(Report report, Section section, double d, Color color, boolean bl) {
        this(report, section, d, color, bl, null, null);
    }

    public Line(Report report, Section section, double d, Color color, boolean bl, Point point, Point point2) {
        super(report, section, bl);
        this.thickness = d;
        this.points = new Point[2];
        this.points[0] = point;
        this.points[1] = point2;
        this.color = color == null ? DEFAULT_COLOR : color;
    }

    public void addEndPoint(double d, double d2) {
        Point point = new Point(d, d2);
        if (this.points[0] == null) {
            this.points[0] = point;
        } else {
            this.points[1] = point;
        }
        point.addObserver(this);
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double d) {
        if (this.thickness != d) {
            this.thickness = d;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public Point getPoint(int n) {
        return this.points[n];
    }

    public void setPoint(Point point, int n) {
        if (this.points[n] != point) {
            if (this.points[n] != null) {
                this.points[n].deleteObserver(this);
            }
            this.points[n] = point;
            if (this.points[n] != null) {
                this.points[n].addObserver(this);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public double length() {
        return this.points[0].distanceTo(this.points[1]);
    }

    public String toString() {
        return "(" + this.points[0] + ", " + this.points[1] + ")";
    }

    public Color getColor() {
        return this.color == null ? DEFAULT_COLOR : this.color;
    }

    public void setColor(Color color) {
        this.color = color == null ? DEFAULT_COLOR : color;
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("line");
        xMLWriter.attr("thickness", this.thickness);
        if (this.color != null && !this.color.equals(DEFAULT_COLOR)) {
            xMLWriter.attr("color", this.color);
        }
        if (!this.visible) {
            xMLWriter.attr("visible", this.visible);
        }
        this.points[0].writeXML(xMLWriter);
        this.points[1].writeXML(xMLWriter);
        xMLWriter.endElement();
    }
}

