/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import jimm.datavision.ListWriter;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.Selectable;
import jimm.datavision.Writeable;
import jimm.datavision.field.Field;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.sql.SQLQuery;
import jimm.util.XMLWriter;

public class Group
implements Writeable {
    public static final int SORT_ASCENDING = 0;
    public static final int SORT_DESCENDING = 1;
    protected Report report;
    protected SectionArea headers;
    protected SectionArea footers;
    protected Selectable selectable;
    protected int sortOrder;
    protected Object value;
    protected boolean newValue;
    protected boolean firstValue;
    protected int recordCount;

    public static Group create(Report report, Selectable selectable) {
        Group group = new Group(report, selectable);
        Section section = new Section(report);
        Field field = Field.create(null, report, section, selectable.fieldTypeString(), selectable.getId(), true);
        field.getFormat().setBold(true);
        section.addField(field);
        group.headers().add(section);
        group.footers().add(new Section(report));
        return group;
    }

    public static String sortOrderIntToString(int n) {
        return n == 0 ? "asc" : "desc";
    }

    public static int sortOrderStringToInt(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return "desc".equals(string.toLowerCase()) ? 1 : 0;
    }

    public Group(Report report, Selectable selectable) {
        this.report = report;
        this.selectable = selectable;
        this.sortOrder = 0;
        this.headers = new SectionArea(5);
        this.footers = new SectionArea(6);
    }

    public Selectable getSelectable() {
        return this.selectable;
    }

    public void setSelectable(Selectable selectable) {
        this.selectable = selectable;
    }

    public void reloadSelectable(DataSource dataSource) {
        this.setSelectable(this.selectable.reloadInstance(dataSource));
    }

    public String getSelectableName() {
        return this.selectable.getDisplayName();
    }

    public String getSortString(SQLQuery sQLQuery) {
        return this.selectable.getSortString(sQLQuery);
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int n) {
        this.sortOrder = n;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Report report) {
        Object object = this.selectable.getValue(report);
        if (this.value == null) {
            this.value = object;
            this.firstValue = true;
            this.newValue = true;
        } else if (this.value.equals(object)) {
            this.newValue = false;
            this.firstValue = false;
        } else {
            this.value = object;
            this.newValue = true;
            this.firstValue = false;
        }
    }

    public void updateCounter() {
        this.recordCount = this.newValue ? 1 : ++this.recordCount;
    }

    public boolean isNewValue() {
        return this.newValue;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void forceFooterOutput() {
        this.newValue = true;
    }

    public boolean isFirstValue() {
        return this.firstValue;
    }

    public SectionArea headers() {
        return this.headers;
    }

    public SectionArea footers() {
        return this.footers;
    }

    public boolean contains(Section section) {
        return this.headers.contains(section) || this.footers.contains(section);
    }

    public void reset() {
        this.value = null;
        this.firstValue = true;
        this.newValue = true;
        this.recordCount = 1;
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("group");
        xMLWriter.attr("groupable-id", this.selectable.getId());
        xMLWriter.attr("groupable-type", this.selectable.fieldTypeString());
        xMLWriter.attr("sort-order", Group.sortOrderIntToString(this.sortOrder));
        ListWriter.writeList(xMLWriter, this.headers.sections(), "headers");
        ListWriter.writeList(xMLWriter, this.footers.sections(), "footers");
        xMLWriter.endElement();
    }
}

