/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import jimm.datavision.ErrorHandler;
import jimm.datavision.Expression;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.UserColumn;
import jimm.datavision.field.Field;
import jimm.datavision.field.SpecialField;
import jimm.datavision.source.Column;
import jimm.util.I18N;
import jimm.util.Replacer;
import jimm.util.StringUtils;
import jimm.util.XMLWriter;

public class Formula
extends Expression {
    protected String language;
    protected Object cachedEvalResult;
    protected boolean useCache;
    protected boolean shouldEvaluate;
    protected boolean showException;

    public Formula(Long l, Report report, String string) {
        this(l, report, string, null);
        this.useCache = false;
        this.shouldEvaluate = true;
        this.showException = true;
    }

    public Formula(Long l, Report report, String string, String string2) {
        super(l == null ? report.generateNewFormulaId() : l, report, string, string2, "#");
        this.language = report.getScripting().getDefaultLanguage();
    }

    public String dragString() {
        return "formula:" + this.getId();
    }

    public String designLabel() {
        return "{@" + this.getName() + "}";
    }

    public String formulaString() {
        return "{@" + this.getId() + "}";
    }

    public void useCache() {
        this.useCache = true;
    }

    public void shouldEvaluate() {
        this.shouldEvaluate = true;
    }

    public void setExpression(String string) {
        super.setExpression(string);
        this.showException = true;
    }

    public Object eval() {
        return this.eval(null);
    }

    public Object eval(Field field) {
        if (!this.useCache || this.shouldEvaluate) {
            this.cachedEvalResult = this.evaluate(field);
            this.shouldEvaluate = false;
        }
        return this.cachedEvalResult;
    }

    protected Object evaluate(final Field field) {
        String string = this.getExpression();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if ((string = StringUtils.replaceDelimited("#", "{%", "}", new Replacer(){

            public Object replace(String string) {
                Object object = SpecialField.value(field, string, Formula.this.report);
                return object == null ? "nil" : object;
            }
        }, string)) == null) {
            return null;
        }
        if ((string = StringUtils.replaceDelimited("#", "{@", "}", new Replacer(){

            public Object replace(String string) {
                Formula formula = Formula.this.report.findFormula(string);
                return formula == null ? "nil" : formula.eval(field);
            }
        }, string)) == null) {
            return null;
        }
        if ((string = StringUtils.replaceDelimited("#", "{?", "}", new Replacer(){

            public Object replace(String string) {
                Parameter parameter = Formula.this.report.findParameter(string);
                return parameter == null ? "nil" : parameter.getValue();
            }
        }, string)) == null) {
            return null;
        }
        if ((string = StringUtils.replaceDelimited("#", "{!", "}", new Replacer(){

            public Object replace(String string) {
                UserColumn userColumn = Formula.this.report.findUserColumn(string);
                return userColumn == null ? "nil" : Formula.this.report.columnValue(userColumn);
            }
        }, string)) == null) {
            return null;
        }
        if ((string = StringUtils.replaceDelimited("#", "{", "}", new Replacer(){

            public Object replace(String string) {
                Column column = Formula.this.report.findColumn(string);
                if (column == null) {
                    return "{" + string + "}";
                }
                Object object = null;
                switch (column.getType()) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        object = Formula.this.report.columnValue(column);
                        object = object == null ? "nil" : Formula.this.quoted(object);
                        break;
                    }
                    default: {
                        object = Formula.this.report.columnValue(column);
                        if (object != null) break;
                        object = "nil";
                    }
                }
                return object;
            }
        }, string)) == null || string.trim().length() == 0) {
            return null;
        }
        try {
            return this.report.eval(this.getLanguage(), string, this.getName());
        }
        catch (Exception exception) {
            if (this.showException) {
                this.showException = false;
                ErrorHandler.error(I18N.get("Formula.script_error") + " \"" + string + '\"' + ": " + exception.toString(), I18N.get("Formula.script_error_title"));
            }
            return null;
        }
    }

    public String getLanguage() {
        return this.language == null ? this.report.getScripting().getDefaultLanguage() : this.language;
    }

    public void setLanguage(String string) {
        if (string == null) {
            string = this.report.getScripting().getDefaultLanguage();
        }
        if (!this.language.equals(string)) {
            this.language = string;
            this.setChanged();
            this.notifyObservers();
        }
    }

    protected String quoted(Object object) {
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object unquoted(Object object) {
        String string;
        if (object instanceof String && (string = (String)object).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string.indexOf("\\");
            while (n2 != -1) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string.charAt(n2 + 1));
                n = n2 + 2;
                n2 = string.indexOf("\\", n);
            }
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        return object;
    }

    public void writeXML(XMLWriter xMLWriter) {
        this.writeXML(xMLWriter, "formula");
    }

    protected void writeAdditionalAttributes(XMLWriter xMLWriter) {
        if (this.language != null && this.language.length() != 0 && !this.language.equals(this.report.getScripting().getDefaultLanguage())) {
            xMLWriter.attr("language", this.language);
        }
    }
}

