/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import jimm.datavision.Draggable;
import jimm.datavision.Formula;
import jimm.datavision.Identity;
import jimm.datavision.Nameable;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.UserColumn;
import jimm.datavision.Writeable;
import jimm.datavision.field.Field;
import jimm.datavision.source.Column;
import jimm.util.I18N;
import jimm.util.Replacer;
import jimm.util.StringUtils;
import jimm.util.XMLWriter;

public abstract class Expression
extends Observable
implements Identity,
Nameable,
Writeable,
Draggable,
Observer {
    protected Long id;
    protected Report report;
    protected String name;
    protected String expr;
    protected String exceptAfter;
    protected ArrayList observedContents;

    public static String expressionToDisplay(Report report, String string) {
        if (string == null || string.length() == 0 || string.indexOf("{") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '{' && i + 1 < n) {
                switch (string.charAt(i + 1)) {
                    case '@': {
                        int n2 = i + 2;
                        int n3 = string.indexOf("}", n2);
                        if (n3 == -1) continue block5;
                        String string2 = string.substring(n2, n3);
                        stringBuffer.append("{@");
                        stringBuffer.append(report.findFormula(string2).getName());
                        stringBuffer.append("}");
                        i = n3;
                        break;
                    }
                    case '?': {
                        int n2 = i + 2;
                        int n3 = string.indexOf("}", n2);
                        if (n3 == -1) continue block5;
                        String string2 = string.substring(n2, n3);
                        stringBuffer.append("{?");
                        stringBuffer.append(report.findParameter(string2).getName());
                        stringBuffer.append("}");
                        i = n3;
                        break;
                    }
                    case '!': {
                        int n2 = i + 2;
                        int n3 = string.indexOf("}", n2);
                        if (n3 == -1) continue block5;
                        String string2 = string.substring(n2, n3);
                        stringBuffer.append("{!");
                        stringBuffer.append(report.findUserColumn(string2).getName());
                        stringBuffer.append("}");
                        i = n3;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String displayToExpression(Report report, String string) {
        if (string == null || string.length() == 0 || string.indexOf("{") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '{' && i + 1 < n) {
                switch (string.charAt(i + 1)) {
                    case '@': {
                        int n2 = i + 2;
                        int n3 = string.indexOf("}", n2);
                        if (n3 == -1) continue block5;
                        String string2 = string.substring(n2, n3);
                        stringBuffer.append("{@");
                        Observable observable = report.findFormulaByName(string2);
                        if (observable == null) {
                            string = I18N.get("Utils.in") + " \"" + string + "\": " + I18N.get("Utils.no_such_formula") + ' ' + string2;
                            throw new IllegalArgumentException(string);
                        }
                        stringBuffer.append(((Expression)observable).getId());
                        stringBuffer.append("}");
                        i = n3;
                        break;
                    }
                    case '?': {
                        int n2 = i + 2;
                        int n3 = string.indexOf("}", n2);
                        if (n3 == -1) continue block5;
                        String string2 = string.substring(n2, n3);
                        stringBuffer.append("{?");
                        Observable observable = report.findParameterByName(string2);
                        if (observable == null) {
                            string = I18N.get("Utils.in") + " \"" + string + "\": " + I18N.get("Utils.no_such_param") + ' ' + string2;
                            throw new IllegalArgumentException(string);
                        }
                        stringBuffer.append(((Parameter)observable).getId());
                        stringBuffer.append("}");
                        i = n3;
                        break;
                    }
                    case '!': {
                        int n2 = i + 2;
                        int n3 = string.indexOf("}", n2);
                        if (n3 == -1) continue block5;
                        String string2 = string.substring(n2, n3);
                        stringBuffer.append("{!");
                        Observable observable = report.findUserColumnByName(string2);
                        if (observable == null) {
                            string = I18N.get("Utils.in") + " \"" + string + "\": " + I18N.get("Utils.no_such_usercol") + ' ' + string2;
                            throw new IllegalArgumentException(string);
                        }
                        stringBuffer.append(((Expression)observable).getId());
                        stringBuffer.append("}");
                        i = n3;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected Expression(Long l, Report report, String string, String string2, String string3) {
        if (l == null) {
            throw new IllegalArgumentException("Subclasses of Expression must not pass in a null id");
        }
        this.report = report;
        this.id = l;
        this.name = string;
        this.expr = string2;
        this.exceptAfter = string3;
        this.observedContents = null;
    }

    protected void finalize() throws Throwable {
        this.stopObservingContents();
        super.finalize();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!(this.name == string || this.name != null && this.name.equals(string))) {
            this.name = string;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public String getExpression() {
        if (this.observedContents == null) {
            this.startObservingContents();
        }
        return this.expr;
    }

    public void setExpression(String string) {
        if (!(this.expr == string || this.expr != null && this.expr.equals(string))) {
            this.stopObservingContents();
            this.expr = string;
            this.setChanged();
            this.notifyObservers();
        }
    }

    protected void startObservingContents() {
        this.observedContents = new ArrayList();
        if (this.expr == null || this.expr.length() == 0) {
            return;
        }
        StringUtils.replaceDelimited(this.exceptAfter, "{@", "}", new Replacer(){

            public Object replace(String string) {
                Formula formula = Expression.this.report.findFormula(string);
                Expression.this.observedContents.add(formula);
                formula.addObserver(Expression.this);
                return "";
            }
        }, this.expr);
        StringUtils.replaceDelimited(this.exceptAfter, "{?", "}", new Replacer(){

            public Object replace(String string) {
                Parameter parameter = Expression.this.report.findParameter(string);
                Expression.this.observedContents.add(parameter);
                parameter.addObserver(Expression.this);
                return "";
            }
        }, this.expr);
        StringUtils.replaceDelimited(this.exceptAfter, "{!", "}", new Replacer(){

            public Object replace(String string) {
                UserColumn userColumn = Expression.this.report.findUserColumn(string);
                Expression.this.observedContents.add(userColumn);
                userColumn.addObserver(Expression.this);
                return "";
            }
        }, this.expr);
    }

    protected void stopObservingContents() {
        if (this.observedContents != null) {
            Iterator iterator = this.observedContents.iterator();
            while (iterator.hasNext()) {
                ((Observable)iterator.next()).deleteObserver(this);
            }
            this.observedContents = null;
        }
    }

    public String getEditableExpression() {
        return Expression.expressionToDisplay(this.report, this.getExpression());
    }

    public void setEditableExpression(String string) {
        this.setExpression(Expression.displayToExpression(this.report, string));
    }

    public abstract String dragString();

    public abstract String designLabel();

    public abstract String formulaString();

    public boolean refersTo(Field field) {
        String string = this.getExpression();
        if (string != null && string.length() > 0) {
            return string.indexOf(field.formulaString()) != -1;
        }
        return false;
    }

    public boolean refersTo(Expression expression) {
        String string = this.getExpression();
        if (string != null && string.length() > 0) {
            return string.indexOf(expression.formulaString()) != -1;
        }
        return false;
    }

    public boolean refersTo(Parameter parameter) {
        String string = this.getExpression();
        if (string != null && string.length() > 0) {
            return string.indexOf(parameter.formulaString()) != -1;
        }
        return false;
    }

    public Collection columnsUsed() {
        final ArrayList arrayList = new ArrayList();
        StringUtils.replaceDelimited(this.exceptAfter, "{", "}", new Replacer(){

            public Object replace(String string) {
                switch (string.charAt(0)) {
                    case '!': {
                        UserColumn userColumn = Expression.this.report.findUserColumn(string.substring(1));
                        if (userColumn == null) break;
                        arrayList.addAll(userColumn.columnsUsed());
                        break;
                    }
                    case '%': 
                    case '?': 
                    case '@': {
                        break;
                    }
                    default: {
                        Column column = Expression.this.report.findColumn(string);
                        if (column == null) break;
                        arrayList.add(column);
                    }
                }
                return "";
            }
        }, this.getExpression());
        return arrayList;
    }

    public Collection userColumnsUsed() {
        final ArrayList arrayList = new ArrayList();
        StringUtils.replaceDelimited(this.exceptAfter, "{!", "}", new Replacer(){

            public Object replace(String string) {
                UserColumn userColumn = Expression.this.report.findUserColumn(string);
                if (userColumn != null) {
                    arrayList.add(userColumn);
                }
                return "";
            }
        }, this.getExpression());
        return arrayList;
    }

    public abstract void writeXML(XMLWriter var1);

    protected void writeXML(XMLWriter xMLWriter, String string) {
        xMLWriter.startElement(string);
        xMLWriter.attr("id", this.id);
        xMLWriter.attr("name", this.name);
        this.writeAdditionalAttributes(xMLWriter);
        xMLWriter.cdata(this.getExpression());
        xMLWriter.endElement();
    }

    protected void writeAdditionalAttributes(XMLWriter xMLWriter) {
    }
}

