/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.gui.DesignWin;
import jimm.datavision.gui.StartupDialog;
import jimm.datavision.layout.CharSepLE;
import jimm.datavision.layout.DocBookLE;
import jimm.datavision.layout.HTMLLE;
import jimm.datavision.layout.LaTeXLE;
import jimm.datavision.layout.LayoutEngine;
import jimm.datavision.layout.XMLLE;
import jimm.datavision.layout.pdf.PDFLE;
import jimm.datavision.layout.swing.SwingLE;
import jimm.datavision.source.charsep.CharSepSource;
import jimm.util.Getopts;
import jimm.util.I18N;
import jimm.util.XMLWriter;

public class DataVision {
    protected static final String DEFAULT_CHARACTER_SEPARATOR = ",";
    char layoutEngineChoice;
    String layoutEngineFileName;
    String dbPassword;
    String paramXMLFile;
    int numReports;
    boolean usesGUI;
    String charSepFile;
    char sepChar;

    public static void main(String[] stringArray) {
        Getopts getopts = new Getopts("a:c:d:e:f:g:h:i:l:np:qr:s:wx:", stringArray);
        if (getopts.error()) {
            DataVision.usage(null);
        }
        DataVision dataVision = new DataVision();
        if (getopts.hasOption('g') || getopts.hasOption('i')) {
            I18N.setLanguage(new Locale(getopts.option('g', "").toLowerCase(), getopts.option('i', "").toUpperCase()));
        }
        dataVision.layoutEngineChoiceFromOptions(getopts);
        dataVision.dataSourceFromOptions(getopts);
        if (dataVision.hasLayoutEngine()) {
            if (dataVision.usesGUI()) {
                ErrorHandler.useGUI(true);
            } else if (!(getopts.hasOption('n') || getopts.hasOption('p') || getopts.hasOption('e'))) {
                DataVision.usage(I18N.get("DataVision.n_or_p"));
            }
        }
        dataVision.paramXMLFile = getopts.option('r', null);
        if (getopts.argc() == 0) {
            if (DataVision.startupDialog()) {
                return;
            }
            if (dataVision.hasLayoutEngine()) {
                DataVision.usage(I18N.get("DataVision.xml_req"));
            } else {
                try {
                    dataVision.designReport(getopts, null);
                }
                catch (Exception exception) {
                    ErrorHandler.error(exception);
                }
            }
        } else {
            dataVision.numReports = getopts.argc();
            for (int i = 0; i < getopts.argc(); ++i) {
                File file = new File(getopts.argv(i));
                try {
                    if (dataVision.hasLayoutEngine()) {
                        dataVision.runReport(getopts, file);
                        continue;
                    }
                    dataVision.designReport(getopts, file);
                    continue;
                }
                catch (Exception exception) {
                    ErrorHandler.error(exception);
                }
            }
        }
        if (dataVision.hasLayoutEngine() && dataVision.getLayoutEngineChoice() != 'w') {
            System.exit(0);
        }
    }

    void designReport(Getopts getopts, File file) throws FileNotFoundException {
        DesignWin designWin = new DesignWin(file, this.dbPassword);
        Report report = designWin.getReport();
        if (this.charSepFile != null) {
            CharSepSource charSepSource = (CharSepSource)report.getDataSource();
            charSepSource.setSepChar(this.sepChar);
            charSepSource.setInput(this.charSepFile);
        }
        if (getopts.hasOption('q')) {
            report.setCaseSensitiveDatabaseNames(false);
        }
    }

    static boolean startupDialog() {
        StartupDialog startupDialog = new StartupDialog();
        String string = startupDialog.getSelectedFile();
        if (string == null) {
            return true;
        }
        if (!string.equalsIgnoreCase("*StartANewReport*")) {
            String[] stringArray = new String[]{string};
            DataVision.main(stringArray);
            return true;
        }
        return false;
    }

    void runReport(Getopts getopts, File file) throws Exception {
        Report report = new Report();
        if (this.dbPassword != null) {
            report.setDatabasePassword(this.dbPassword);
        }
        report.read(file);
        if (this.paramXMLFile != null) {
            report.setParameterXMLInput(new File(this.paramXMLFile));
        }
        if (this.charSepFile != null) {
            CharSepSource charSepSource = (CharSepSource)report.getDataSource();
            charSepSource.setSepChar(this.sepChar);
            charSepSource.setInput(this.charSepFile);
        }
        if (getopts.hasOption('q')) {
            report.setCaseSensitiveDatabaseNames(false);
        }
        report.setLayoutEngine(this.createLayoutEngine(file, getopts));
        report.runReport();
    }

    boolean hasLayoutEngine() {
        return this.layoutEngineChoice != '\u0000';
    }

    char getLayoutEngineChoice() {
        return this.layoutEngineChoice;
    }

    boolean usesGUI() {
        return this.usesGUI;
    }

    void layoutEngineChoiceFromOptions(Getopts getopts) {
        String string = I18N.get("DataVision.le_one");
        this.layoutEngineChoice = '\u0000';
        if (getopts.hasOption('c')) {
            this.layoutEngineChoice = (char)99;
            this.layoutEngineFileName = getopts.option('c', null);
        }
        if (getopts.hasOption('d')) {
            if (this.layoutEngineChoice != '\u0000') {
                DataVision.usage(string);
            }
            this.layoutEngineChoice = (char)100;
            this.layoutEngineFileName = getopts.option('d', null);
        }
        if (getopts.hasOption('f')) {
            if (this.layoutEngineChoice != '\u0000') {
                DataVision.usage(string);
            }
            this.layoutEngineChoice = (char)102;
            this.layoutEngineFileName = getopts.option('f', null);
        }
        if (getopts.hasOption('h')) {
            if (this.layoutEngineChoice != '\u0000') {
                DataVision.usage(string);
            }
            this.layoutEngineChoice = (char)104;
            this.layoutEngineFileName = getopts.option('h', null);
        }
        if (getopts.hasOption('l')) {
            if (this.layoutEngineChoice != '\u0000') {
                DataVision.usage(string);
            }
            this.layoutEngineChoice = (char)108;
            this.layoutEngineFileName = getopts.option('l', null);
        }
        if (getopts.hasOption('x')) {
            if (this.layoutEngineChoice != '\u0000') {
                DataVision.usage(string);
            }
            this.layoutEngineChoice = (char)120;
            this.layoutEngineFileName = getopts.option('x', null);
        }
        if (getopts.hasOption('w')) {
            if (this.layoutEngineChoice != '\u0000') {
                DataVision.usage(string);
            }
            this.layoutEngineChoice = (char)119;
            this.usesGUI = true;
        }
    }

    LayoutEngine createLayoutEngine(File file, Getopts getopts) throws IOException {
        LayoutEngine layoutEngine = null;
        String string = file.getName();
        String string2 = null;
        if (this.layoutEngineFileName != null) {
            int n = string.lastIndexOf(46);
            string2 = n == -1 ? string : string.substring(0, n);
        }
        String string3 = null;
        PrintWriter printWriter = null;
        switch (this.layoutEngineChoice) {
            case 'c': {
                char c = getopts.option('s', DEFAULT_CHARACTER_SEPARATOR).charAt(0);
                if (this.layoutEngineFileName != null) {
                    string3 = this.layoutEngineFileName;
                } else {
                    string3 = string2 + (c == ',' ? ".csv" : ".tab");
                    if (string3.equals(string)) {
                        string3 = string2 + "_out" + (c == ',' ? ".csv" : ".tab");
                    }
                }
                printWriter = new PrintWriter(new FileWriter(string3));
                layoutEngine = new CharSepLE(printWriter, c);
                break;
            }
            case 'd': {
                if (this.layoutEngineFileName != null) {
                    string3 = this.layoutEngineFileName;
                } else {
                    string3 = string2 + ".sgml";
                    if (string3.equals(string)) {
                        string3 = string2 + "_out.sgml";
                    }
                }
                printWriter = new PrintWriter(new FileWriter(string3));
                layoutEngine = new DocBookLE(printWriter);
                break;
            }
            case 'f': {
                if (this.layoutEngineFileName != null) {
                    string3 = this.layoutEngineFileName;
                } else {
                    string3 = string2 + ".pdf";
                    if (string3.equals(string)) {
                        string3 = string2 + "_out.pdf";
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                layoutEngine = new PDFLE(fileOutputStream);
                break;
            }
            case 'h': {
                if (this.layoutEngineFileName != null) {
                    string3 = this.layoutEngineFileName;
                } else {
                    string3 = string2 + ".html";
                    if (string3.equals(string)) {
                        string3 = string2 + "_out.html";
                    }
                }
                printWriter = new PrintWriter(new FileWriter(string3));
                layoutEngine = new HTMLLE(printWriter);
                break;
            }
            case 'l': {
                if (this.layoutEngineFileName != null) {
                    string3 = this.layoutEngineFileName;
                } else {
                    string3 = string2 + ".tex";
                    if (string3.equals(string)) {
                        string3 = string2 + "_out.tex";
                    }
                }
                printWriter = new PrintWriter(new FileWriter(string3));
                layoutEngine = new LaTeXLE(printWriter);
                break;
            }
            case 'x': {
                if (this.layoutEngineFileName != null) {
                    string3 = this.layoutEngineFileName;
                } else {
                    string3 = string2 + ".xml";
                    if (string3.equals(string)) {
                        string3 = string2 + "_out.xml";
                    }
                }
                XMLWriter xMLWriter = new XMLWriter(new FileWriter(string3));
                layoutEngine = new XMLLE(xMLWriter);
                break;
            }
            case 'w': {
                layoutEngine = new SwingLE(){

                    public void close() {
                        super.close();
                        DataVision.this.swingLayoutEngineClosed();
                    }
                };
            }
        }
        return layoutEngine;
    }

    protected void swingLayoutEngineClosed() {
        if (--this.numReports == 0) {
            System.exit(0);
        }
    }

    protected void dataSourceFromOptions(Getopts getopts) {
        if (getopts.hasOption('n')) {
            if (getopts.hasOption('p') || getopts.hasOption('e')) {
                DataVision.usage(I18N.get("DataVision.n_and_p"));
            }
            this.dbPassword = "";
        } else if (getopts.hasOption('p')) {
            if (getopts.hasOption('n') || getopts.hasOption('e')) {
                DataVision.usage(I18N.get("DataVision.n_and_p"));
            }
            this.dbPassword = getopts.option('p', null);
        } else if (getopts.hasOption('e')) {
            if (getopts.hasOption('n') || getopts.hasOption('p')) {
                DataVision.usage(I18N.get("DataVision.n_and_p"));
            }
            this.charSepFile = getopts.option('e');
            this.sepChar = getopts.option('a', DEFAULT_CHARACTER_SEPARATOR).charAt(0);
        }
    }

    public String toString() {
        return "DataVision [layoutEngineChoice=" + this.layoutEngineChoice + ", dbPassword = " + this.dbPassword + ", paramXMLFile = " + this.paramXMLFile + ", numReports = " + this.numReports + ", usesGUI = " + this.usesGUI + ", charSepFile = " + this.charSepFile + ", sepChar = " + this.sepChar + "]";
    }

    public static void usage(String string) {
        if (string != null) {
            System.err.println(string);
        }
        System.err.println(I18N.get("DataVision.usage"));
        System.exit(1);
    }
}

