/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes.model;

import com.ebay.sdk.attributes.model.Error;
import com.ebay.sdk.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErrorSet {
    private static final String ERROR_SET = "ErrorSet";
    private int CSId;
    private Error[] errors = null;

    public ErrorSet() {
    }

    public ErrorSet(int csId) {
        this.CSId = csId;
    }

    public void setCSId(int CSId) {
        this.CSId = CSId;
    }

    public int getCSId() {
        return this.CSId;
    }

    public void setErrors(Error[] errors) {
        this.errors = errors;
    }

    public Error[] getErrors() {
        return this.errors;
    }

    public void addError(Error error) {
        Error[] oldErrs = this.errors;
        Error[] newErrs = new Error[(oldErrs == null ? 0 : oldErrs.length) + 1];
        int i = 0;
        if (oldErrs != null) {
            for (i = 0; i < oldErrs.length; ++i) {
                newErrs[i] = oldErrs[i];
            }
        }
        newErrs[i] = error;
        this.errors = newErrs;
    }

    public Node toXml(Document doc) {
        Element root = doc.createElement(ERROR_SET);
        String csidStr = new Integer(this.CSId).toString();
        XmlUtil.appendAttributeNode((Element)root, (String)"id", (String)csidStr);
        for (int i = 0; i < this.errors.length; ++i) {
            Node node = this.errors[i].toXml(doc);
            root.appendChild(node);
        }
        return root;
    }
}

