/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

class SimpleDate {
    private int day;
    private int month;
    private int year;
    private int type;
    static final int DT_UNKNOWN = -1;
    static final int DT_YEAR = 4;
    static final int DT_YEAR_MONTH = 7;
    static final int DT_YEARMONTHDAY = 8;
    static final int DT_YEAR_MONTH_DAY = 10;
    static final int LEN_YEAR = 4;
    static final int LEN_MONTH = 2;
    static final int LEN_DAY = 2;
    static final int IDX_DASH1 = 4;
    static final int IDX_DASH2 = 7;
    public static final int JAN = 1;
    public static final int FEB = 2;
    public static final int APR = 4;
    public static final int JUN = 6;
    public static final int SEP = 9;
    public static final int NOV = 11;
    public static final int DEC = 12;
    public static final int ONE = 1;
    public static final int THIRTY_ONE = 31;
    public static final String DASH = "-";

    public SimpleDate(String date) {
        this.init(date);
    }

    public int compare(SimpleDate dt) {
        int diff = this.year - dt.year;
        if (diff != 0) {
            return diff;
        }
        diff = this.month - dt.month;
        if (diff != 0) {
            return diff;
        }
        return this.day - dt.day;
    }

    protected void init(String date) {
        this.type = this.getDateFormat(date);
        if (this.type == -1) {
            return;
        }
        switch (this.type) {
            case 7: {
                int index = date.indexOf(DASH);
                this.year = Integer.parseInt(date.substring(0, index));
                this.month = Integer.parseInt(date.substring(index + 1));
                break;
            }
            case 8: {
                String s = date.substring(0, 4);
                this.year = Integer.parseInt(s);
                s = date.substring(4, 6);
                this.month = Integer.parseInt(s);
                s = date.substring(6, 8);
                this.day = Integer.parseInt(s);
                break;
            }
            case 10: {
                String s = date.substring(0, 4);
                this.year = Integer.parseInt(s);
                s = date.substring(5, 7);
                this.month = Integer.parseInt(s);
                s = date.substring(8);
                this.day = Integer.parseInt(s);
                break;
            }
            default: {
                this.year = Integer.parseInt(date);
            }
        }
    }

    public int getDateFormat(String date) {
        int len = date.length();
        if (len == 4) {
            return 4;
        }
        if (len == 7 && date.indexOf(DASH) == 4) {
            return 7;
        }
        if (len == 8 && date.indexOf(DASH) == -1) {
            return 8;
        }
        if (len == 10 && date.indexOf(DASH) == 4 && date.lastIndexOf(DASH) == 7) {
            return 10;
        }
        return -1;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public boolean isValidDate() {
        return this.isValidDay() && this.isValidMonth() && this.isValidYear();
    }

    public boolean isValidDay() {
        if (this.type == 4 || this.type == 7) {
            return true;
        }
        if (0 >= this.day || this.day > 31) {
            return false;
        }
        if (this.day == 31 && (this.month == 2 || this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11)) {
            return false;
        }
        return this.day != 28 || this.month == 2 && this.year % 4 == 0;
    }

    public boolean isValidMonth() {
        if (this.type == 4) {
            return true;
        }
        return 1 <= this.month && this.month <= 12;
    }

    public boolean isValidYear() {
        return 0 < this.year && this.year < 9999;
    }
}

