/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.model.IProductFinderXmlProvider;
import com.ebay.sdk.call.GetProductFinderCall;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Document;

public class ProductFinderXmlDownloader
implements IProductFinderXmlProvider {
    private ApiContext apiContext;
    private Map<int[], Document> cache = new Hashtable<int[], Document>();

    public ProductFinderXmlDownloader(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public void resetCache() {
        this.cache = new Hashtable<int[], Document>();
    }

    public synchronized Document getProductFinderXml(int[] productFinderIDList) throws SdkException, Exception {
        Document doc;
        Object obj = ProductFinderXmlDownloader.searchMap(productFinderIDList, this.cache);
        if (obj == null) {
            GetProductFinderCall gpf = new GetProductFinderCall(this.apiContext);
            gpf.setDetailLevel(new DetailLevelCodeType[]{DetailLevelCodeType.RETURN_ALL});
            gpf.setProductFinderIDs(productFinderIDList);
            String pfXml = gpf.getProductFinder();
            if (pfXml == null || pfXml.length() == 0) {
                StringBuffer ids = new StringBuffer();
                for (int i = 0; i < productFinderIDList.length; ++i) {
                    ids.append(productFinderIDList[i]).append(",");
                }
                int lastComaPos = ids.lastIndexOf(",");
                ids.deleteCharAt(lastComaPos);
                throw new SdkException("ProductFinder Data not available for product finder ids:" + ids.toString());
            }
            doc = XmlUtil.createDom((String)pfXml);
            this.cache.put(productFinderIDList, doc);
        } else {
            doc = (Document)obj;
        }
        return doc;
    }

    static Object searchMap(Object key, Map cache) {
        Object[] keys = cache.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (!(key instanceof int[] && keys[i] instanceof int[] ? ProductFinderXmlDownloader.compareIntArray((int[])keys[i], (int[])key) == 0 : (key instanceof String[] && keys[i] instanceof String[] ? ProductFinderXmlDownloader.compareStringArray((String[])keys[i], (String[])key) == 0 : key instanceof String && keys[i] instanceof String && ((String)key).equals((String)keys[i])))) continue;
            return cache.get(keys[i]);
        }
        return null;
    }

    static int compareIntArray(int[] a1, int[] a2) {
        if (a1.length != a2.length) {
            return -1;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return -1;
        }
        return 0;
    }

    static int compareStringArray(String[] a1, String[] a2) {
        if (a1.length != a2.length) {
            return -1;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i].equals(a2[i])) continue;
            return -1;
        }
        return 0;
    }
}

