/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.model.SearchAttribute;
import com.ebay.sdk.attributes.model.SearchAttributeSet;
import com.ebay.sdk.attributes.model.Value;
import java.util.Hashtable;
import java.util.Map;

abstract class ProductFinderParamParser {
    static final String PFID = "pfid";
    static final String A = "a";
    public static final String US = "_";
    public static final String USD = "_d";
    public static final String USM = "_m";
    public static final String USY = "_y";

    ProductFinderParamParser() {
    }

    static Map getPFIDList(Map request) {
        Hashtable<String, String> pfids = new Hashtable<String, String>();
        Object[] keys = request.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            if (!key.startsWith(PFID)) continue;
            String val = ((String[])request.get(key))[0];
            String skey = key.substring(PFID.length());
            if (skey.length() != 0 && skey.charAt(0) != '_') continue;
            pfids.put(skey, val);
        }
        return pfids;
    }

    private static Object findValueByStringKey(Map map, String strKey) {
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            if (!key.equals(strKey)) continue;
            return map.get(key);
        }
        return null;
    }

    private static SearchAttributeSet findAttributeSetByPFID(SearchAttributeSet[] sets, int pfid) {
        for (int i = 0; i < sets.length; ++i) {
            if (pfid != sets[i].getProductFinderID()) continue;
            return sets[i];
        }
        return null;
    }

    static SearchAttributeSet[] parseProductFinderPostData(Map request) throws SdkException, Exception {
        int i;
        Map gkey_pfid = ProductFinderParamParser.getPFIDList(request);
        if (gkey_pfid.size() == 0) {
            throw new SdkException("No product finder post data were found.");
        }
        Object[] rgPFID = gkey_pfid.values().toArray();
        SearchAttributeSet[] sets = new SearchAttributeSet[gkey_pfid.size()];
        for (i = 0; i < sets.length; ++i) {
            sets[i] = new SearchAttributeSet();
            sets[i].setProductFinderID(Integer.parseInt((String)rgPFID[i]));
        }
        Object[] keys = request.keySet().toArray();
        for (i = 0; i < keys.length; ++i) {
            String groupKey;
            String aid;
            String key = (String)keys[i];
            if (!key.startsWith(A)) continue;
            String skey = key.substring(A.length());
            int us_idx = skey.indexOf(US);
            if (us_idx != -1) {
                aid = skey.substring(0, us_idx);
                groupKey = skey.substring(us_idx);
            } else {
                aid = skey;
                groupKey = "";
            }
            String valStr = ((String[])request.get(key))[0];
            Object objPFID = ProductFinderParamParser.findValueByStringKey(gkey_pfid, groupKey);
            if (objPFID == null) {
                throw new SdkException("Invalid group key.");
            }
            SearchAttributeSet set = ProductFinderParamParser.findAttributeSetByPFID(sets, Integer.parseInt((String)objPFID));
            SearchAttribute attr = new SearchAttribute();
            attr.setAttributeID(Integer.parseInt(aid));
            Value val = new Value();
            val.setValueID(new Integer(valStr));
            attr.addValue(val);
            set.add(attr);
        }
        return sets;
    }
}

