/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.AttributesMaster;
import com.ebay.sdk.attributes.ProductFinderParamParser;
import com.ebay.sdk.attributes.model.ICategoryCSProvider;
import com.ebay.sdk.attributes.model.IProductFinderMaster;
import com.ebay.sdk.attributes.model.IProductFinderXmlProvider;
import com.ebay.sdk.attributes.model.IProductFinderXslProvider;
import com.ebay.sdk.attributes.model.SearchAttributeSet;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.CharacteristicsSetType;
import com.ebay.soap.eBLBaseComponents.ExtendedProductFinderIDType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;

public class ProductFinderMaster
implements IProductFinderMaster {
    private static final String PF_ID_TAG = "pf_sdk";
    private IProductFinderXmlProvider xmlProvider;
    private IProductFinderXslProvider xslProvider;
    private ICategoryCSProvider CategoryCSProvider = null;

    public void setXmlProvider(IProductFinderXmlProvider xmlProvider) {
        this.xmlProvider = xmlProvider;
    }

    public IProductFinderXmlProvider getXmlProvider() {
        return this.xmlProvider;
    }

    public void setXslProvider(IProductFinderXslProvider xslProvider) {
        this.xslProvider = xslProvider;
    }

    public IProductFinderXslProvider getXslProvider() {
        return this.xslProvider;
    }

    public void setCategoryCSProvider(ICategoryCSProvider CategoryCSProvider) {
        this.CategoryCSProvider = CategoryCSProvider;
    }

    public ICategoryCSProvider getCategoryCSProvider() {
        return this.CategoryCSProvider;
    }

    public String renderHtml(CategoryType[] categories, String formSubmitUrl, String submitButtonHtml) throws SdkException, Exception {
        StringBuffer sb = new StringBuffer();
        StringBuffer hidderTags = new StringBuffer();
        HashSet<Integer> pfIdSet = new HashSet<Integer>();
        for (int i = 0; i < categories.length; ++i) {
            CategoryType cat = categories[i];
            String catID = cat.getCategoryID();
            if (catID == null) {
                throw new SdkException("Category ID is not set for the category.");
            }
            CharacteristicsSetType[] sets = cat.getCharacteristicsSets();
            if (sets == null || sets.length == 0) {
                throw new SdkException("CharacteristicsSet is not set for the category.");
            }
            Integer csID = sets[0].getAttributeSetID();
            ExtendedProductFinderIDType[] prodFinders = cat.getProductFinderIDs();
            if (prodFinders != null && prodFinders.length > 0) {
                for (int k = 0; k < prodFinders.length; ++k) {
                    pfIdSet.add(prodFinders[k].getProductFinderID());
                }
            }
            AttributesMaster.addHiddenInputTag(hidderTags, PF_ID_TAG + String.valueOf(i), catID + '_' + csID.toString());
        }
        int[] pfIdList = new int[pfIdSet.size()];
        Iterator iter = pfIdSet.iterator();
        int j = 0;
        while (iter.hasNext()) {
            pfIdList[j] = (Integer)iter.next();
        }
        Document xmlDoc = null;
        try {
            xmlDoc = this.xmlProvider.getProductFinderXml(pfIdList);
        }
        catch (SdkException sdke) {
            return sdke.getMessage();
        }
        Document xslDoc = this.xslProvider.getXSL();
        String table = XmlUtil.xslTransform((Document)xmlDoc, (Document)xslDoc);
        sb.append(table);
        String html = sb.toString();
        if (formSubmitUrl != null) {
            String oldAction = "action=\"PFPage\"";
            String newAction = MessageFormat.format("action=\"{0}\"", formSubmitUrl);
            html = html.replaceAll(oldAction, newAction);
        }
        hidderTags.append("\n");
        String ns = hidderTags.toString();
        String oldSubmit = "<input type=\"submit\" value=\"Submit\">";
        ns = submitButtonHtml == null ? ns + "<input type=\"submit\" value=\"Submit\">" : ns + submitButtonHtml;
        html = html.replaceAll("<input type=\"submit\" value=\"Submit\">", ns);
        return html;
    }

    private CategoryType extractOneCat(String catCsName, Map request) throws SdkException, Exception {
        CategoryType cat = null;
        Object obj = request.get(catCsName);
        if (obj != null) {
            String cat_pf = ((String[])obj)[0];
            String[] delim = cat_pf.split("_");
            if (delim == null || delim.length != 2) {
                throw new SdkException("Invalid PF_ID_TAG tag found in the query string array.");
            }
            String pfID = delim[0];
            String catID = delim[0];
            int csID = Integer.parseInt(delim[1]);
            if (pfID.length() > 0) {
                cat = new CategoryType();
                cat.setCategoryID(catID);
                CharacteristicsSetType cs = new CharacteristicsSetType();
                cs.setAttributeSetID(new Integer(csID));
                cat.setCharacteristicsSets(new CharacteristicsSetType[]{cs});
            }
        }
        return cat;
    }

    static CategoryType findCategoryByProductFinderID(CategoryType[] cats, int pfid) {
        for (int i = 0; i < cats.length; ++i) {
            boolean hasPF;
            CategoryType cat = cats[i];
            ExtendedProductFinderIDType[] prodFinders = cat.getProductFinderIDs();
            boolean bl = hasPF = prodFinders != null && prodFinders.length > 0;
            if (!hasPF) continue;
            int j = 0;
            while (i < prodFinders.length) {
                if (prodFinders[j].getProductFinderID() == pfid) {
                    return cat;
                }
                ++j;
            }
        }
        return null;
    }

    public SearchAttributeSet[] nameValuesToAttributeSets(Map nameValues) throws SdkException, Exception {
        ArrayList<CategoryType> catsList = new ArrayList<CategoryType>();
        int ordinal = 0;
        while (true) {
            String ordStr = String.valueOf(ordinal);
            CategoryType cat = this.extractOneCat(PF_ID_TAG + ordStr, nameValues);
            if (cat == null) break;
            catsList.add(cat);
            ++ordinal;
        }
        CategoryType[] cats = new CategoryType[catsList.size()];
        for (int i = 0; i < catsList.size(); ++i) {
            cats[i] = (CategoryType)catsList.get(i);
        }
        SearchAttributeSet[] sets = ProductFinderParamParser.parseProductFinderPostData(nameValues);
        for (int i = 0; i < sets.length; ++i) {
            SearchAttributeSet set = sets[i];
            CategoryType cat = ProductFinderMaster.findCategoryByProductFinderID(cats, set.getProductFinderID());
            if (cat == null) {
                throw new SdkException("findCategoryByProductFinderID failed.");
            }
            set.setCategoryID(Integer.parseInt(cat.getCategoryID()));
            CharacteristicsSetType[] css = cat.getCharacteristicsSets();
            if (css == null || css.length <= 0) continue;
            set.setAttributeSetID(css[0].getAttributeSetID());
        }
        return sets;
    }
}

