/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.model.IAttributesXslProvider;
import com.ebay.sdk.call.GetAttributesXSLCall;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.XSLFileType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;

public class AttributesXslDownloader
implements IAttributesXslProvider {
    private ApiContext apiContext;
    private String xslFileName;
    private String xslText;
    private String currentVersion;
    private String ROOT_DIR;
    private String XSL_FILE_NAME;
    private static final String ATTR_XSL_FILE_EXTENSION = "attrxsl";

    public AttributesXslDownloader(ApiContext apiContext) throws Exception, IOException {
        this.apiContext = apiContext;
    }

    private void init() throws Exception, IOException {
        this.currentVersion = this.getCurrentFileVersion();
        String site = this.apiContext.getSite().toString();
        this.ROOT_DIR = new File(".").getCanonicalPath();
        this.XSL_FILE_NAME = this.ROOT_DIR + "/" + site + "." + this.currentVersion + "." + ATTR_XSL_FILE_EXTENSION;
        File dir = new File(this.ROOT_DIR);
        String[] dataFiles = this.getDataFiles(dir);
        boolean foundVersion = false;
        if (dataFiles != null) {
            for (int i = 0; i < dataFiles.length; ++i) {
                if (!dataFiles[i].startsWith(site + "." + this.currentVersion + ".")) continue;
                foundVersion = true;
                break;
            }
        }
        if (foundVersion) {
            try {
                this.xslText = this.loadXslFile();
            }
            catch (IOException ioe) {
                throw new SdkException("Error processing file: " + this.XSL_FILE_NAME + " : " + ioe.getMessage());
            }
        } else {
            this.xslText = this.downloadXsl();
            this.saveXslTextInFile(this.xslText);
        }
    }

    private void saveXslTextInFile(String xslText) throws IOException {
        File fl = new File(this.XSL_FILE_NAME);
        FileWriter fw = new FileWriter(fl);
        fw.write(xslText);
        fw.close();
    }

    public synchronized String getXslText() throws ApiException, SdkException, Exception {
        if (!this.validateCurrentVersion()) {
            this.init();
        }
        return this.xslText;
    }

    private String fixXslTest(String xslSource) {
        StringBuffer retval = new StringBuffer();
        String XSL_CHOOSE_START = "<xsl:choose>";
        String XSL_CHOOSE_END = "</xsl:choose>";
        String XAL_NODESET = "xal:nodeset";
        int xalPos = xslSource.indexOf("xal:nodeset");
        if (xalPos < 0) {
            return xslSource;
        }
        String firstPart = xslSource.substring(0, xalPos);
        int chooseStartPos = firstPart.lastIndexOf("<xsl:choose>");
        if (chooseStartPos < 0) {
            return xslSource;
        }
        retval.append(firstPart.substring(0, chooseStartPos - 1));
        String secondPart = xslSource.substring(chooseStartPos);
        int chooseEndPos = secondPart.indexOf("</xsl:choose>") + "</xsl:choose>".length();
        retval.append(secondPart.substring(chooseEndPos));
        return retval.toString();
    }

    public String downloadXsl(ApiContext asn) throws ApiException, SdkException, Exception {
        this.apiContext = asn;
        GetAttributesXSLCall api = new GetAttributesXSLCall(asn);
        api.addDetailLevel(DetailLevelCodeType.RETURN_ALL);
        XSLFileType[] xslFiles = api.getAttributesXSL();
        String myXslText = null;
        if (xslFiles.length > 0) {
            myXslText = xslFiles[0].getFileContent();
            this.xslFileName = xslFiles[0].getFileName();
        }
        String firstPart = this.fixXslTest(myXslText);
        this.xslText = this.fixXslTest(firstPart);
        return this.xslText;
    }

    private String getCurrentFileVersion() throws ApiException, SdkException, Exception {
        GetAttributesXSLCall api = new GetAttributesXSLCall(this.apiContext);
        api.addDetailLevel(DetailLevelCodeType.RETURN_SUMMARY);
        api.getAttributesXSL();
        return api.getXSLFile()[0].getFileVersion();
    }

    private boolean validateCurrentVersion() throws ApiException, SdkException, Exception {
        String currentFileVersion = this.getCurrentFileVersion();
        if (this.currentVersion == null) {
            this.currentVersion = currentFileVersion;
            return false;
        }
        return this.currentVersion.equals(currentFileVersion);
    }

    private String[] getDataFiles(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(AttributesXslDownloader.ATTR_XSL_FILE_EXTENSION);
            }
        };
        String[] files = dir.list(filter);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadXslFile() throws IOException {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(this.XSL_FILE_NAME));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return contents.toString();
    }

    public String getXslFileName() {
        return this.xslFileName;
    }

    public String downloadXsl() throws ApiException, SdkException, Exception {
        return this.downloadXsl(this.apiContext);
    }
}

