/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.AttrParamParser;
import com.ebay.sdk.attributes.SimpleValidator;
import com.ebay.sdk.attributes.ValidationParams;
import com.ebay.sdk.attributes.ValidationRule;
import com.ebay.sdk.attributes.model.Attribute;
import com.ebay.sdk.attributes.model.AttributeSet;
import com.ebay.sdk.attributes.model.Error;
import com.ebay.sdk.attributes.model.ErrorSet;
import com.ebay.sdk.attributes.model.IAttributesMaster;
import com.ebay.sdk.attributes.model.IAttributesXmlProvider;
import com.ebay.sdk.attributes.model.IAttributesXslProvider;
import com.ebay.sdk.attributes.model.ICategoryCSProvider;
import com.ebay.sdk.attributes.model.ValidationResult;
import com.ebay.sdk.attributes.model.Value;
import com.ebay.sdk.util.XPathUtil;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.AttributeType;
import com.ebay.soap.eBLBaseComponents.SiteWideCharacteristicsType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AttributesMaster
implements IAttributesMaster {
    private static final String CAT_CS_ID = "cat_cs_id";
    private static final String ATTRIBUTE_SET = "AttributeSet";
    private static final String ID = "id";
    private static final String ATTRIBUTE = "Attribute";
    private static final String VALUE = "Value";
    private static final String NAME = "Name";
    private static final String SELECTED_ATTRIBUTES = "SelectedAttributes";
    private static final String RETURN_POLICY = "Return Policy";
    private static final String RETURN_POLICY_PAGE_ID = "ReturnPolicy";
    private static final String PAGE_ID = "pageId";
    private Document xslDoc = null;
    private IAttributesXslProvider attrXslProvider;
    private IAttributesXmlProvider attrXmlProvider;
    private ICategoryCSProvider categoryCSProvider;

    public IAttributesXslProvider getXslProvider() {
        return this.attrXslProvider;
    }

    public void setXslProvider(IAttributesXslProvider attrXslProvider) throws Exception {
        this.attrXslProvider = attrXslProvider;
        String xslText = attrXslProvider.getXslText();
        this.xslDoc = xslText != null && xslText.length() > 0 ? XmlUtil.createDom((String)xslText) : null;
    }

    public IAttributesXmlProvider getXmlProvider() {
        return this.attrXmlProvider;
    }

    public void setXmlProvider(IAttributesXmlProvider attrXmlProvider) {
        this.attrXmlProvider = attrXmlProvider;
    }

    public ICategoryCSProvider getCategoryCSProvider() {
        return this.categoryCSProvider;
    }

    public void setCategoryCSProvider(ICategoryCSProvider categoryCSProvider) {
        this.categoryCSProvider = categoryCSProvider;
    }

    private AttributeSet extractOneCat(String catCsName, Map request) {
        AttributeSet attrSet = null;
        Object obj = request.get(catCsName);
        if (obj != null) {
            String cat_cs = ((String[])obj)[0];
            String[] delim = cat_cs.split("_");
            int catId = Integer.parseInt(delim[0]);
            int csId = Integer.parseInt(delim[1]);
            String prodId = null;
            if (delim.length > 2) {
                prodId = delim[2];
            }
            if (csId != 0) {
                attrSet = AttrParamParser.parse(csId, request);
                attrSet.setCategoryID(catId);
                attrSet.setAttributeSetID(csId);
                if (prodId != null) {
                    attrSet.setProductID(prodId);
                }
            }
        }
        return attrSet;
    }

    static AttributeSet[] attributeSetToArrayList(ArrayList al) {
        AttributeSet[] sets = new AttributeSet[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            sets[i] = (AttributeSet)((Object)al.get(i));
        }
        return sets;
    }

    public AttributeSet[] nameValuesToAttributeSets(Map nameValues) throws SdkException, Exception {
        ArrayList<AttributeSet> attrSets = new ArrayList<AttributeSet>();
        int ordinal = 0;
        while (true) {
            String ordStr = String.valueOf(ordinal);
            AttributeSet attrSet = this.extractOneCat(CAT_CS_ID + ordStr, nameValues);
            if (attrSet == null) break;
            attrSet.setCategoryOrdinal(attrSets.size());
            attrSets.add(attrSet);
            ++ordinal;
        }
        return AttributesMaster.attributeSetToArrayList(attrSets);
    }

    public AttributeSet[] getItemSpecificAttributeSetsForCategories(int[] catIds) throws SdkException, Exception {
        AttributeSet[] sets = new AttributeSet[catIds.length];
        for (int i = 0; i < catIds.length; ++i) {
            int catId = catIds[i];
            AttributeSet ast = new AttributeSet();
            int csId = this.categoryCSProvider.getVCSId(catId);
            if (csId == 0) {
                return null;
            }
            ast.setAttributeSetID(csId);
            ast.setCategoryID(catId);
            ast.setCategoryOrdinal(i);
            sets[i] = ast;
        }
        return sets;
    }

    public AttributeSet[] joinItemSpecificAndSiteWideAttributeSets(AttributeSet[] itemSpecAttrSets, AttributeSet[] swAttrSets) throws Exception {
        int i;
        if (swAttrSets == null || swAttrSets.length == 0) {
            if (itemSpecAttrSets == null || itemSpecAttrSets.length == 0) {
                return null;
            }
            return itemSpecAttrSets;
        }
        AttributeSet[] swAttrNoRetPolicySets = this.excludeReturnPolicyFromSiteWideAttributes(swAttrSets);
        if (swAttrNoRetPolicySets == null || swAttrNoRetPolicySets.length == 0) {
            return itemSpecAttrSets;
        }
        int itemSpecAttrSetsLength = itemSpecAttrSets == null ? 0 : itemSpecAttrSets.length;
        AttributeSet[] joinedAttrSet = new AttributeSet[itemSpecAttrSetsLength + swAttrNoRetPolicySets.length];
        for (i = 0; i < itemSpecAttrSetsLength; ++i) {
            joinedAttrSet[i] = itemSpecAttrSets[i];
        }
        for (i = 0; i < swAttrNoRetPolicySets.length; ++i) {
            joinedAttrSet[itemSpecAttrSetsLength + i] = swAttrNoRetPolicySets[i];
        }
        return joinedAttrSet;
    }

    private AttributeSet[] excludeReturnPolicyFromSiteWideAttributes(AttributeSet[] siteWideAttributeSet) throws Exception {
        if (siteWideAttributeSet == null) {
            return null;
        }
        AttributeSet retPolicyAttrSet = this.getReturnPolicyAttributeSet(siteWideAttributeSet);
        if (retPolicyAttrSet == null) {
            return siteWideAttributeSet;
        }
        int retPolicyAttrId = retPolicyAttrSet.getAttributeSetID();
        ArrayList<AttributeSet> attrList = new ArrayList<AttributeSet>();
        for (int i = 0; i < siteWideAttributeSet.length; ++i) {
            if (siteWideAttributeSet[i].getAttributeSetID() == retPolicyAttrId) continue;
            attrList.add(siteWideAttributeSet[i]);
        }
        AttributeSet[] attrSet = new AttributeSet[attrList.size()];
        for (int i = 0; i < attrSet.length; ++i) {
            attrSet[i] = (AttributeSet)((Object)attrList.get(i));
        }
        return attrSet;
    }

    public AttributeSet[] getSiteWideAttributeSetsForCategories(int[] catIds) throws SdkException, Exception {
        ArrayList<AttributeSet> attrSetsList = new ArrayList<AttributeSet>();
        for (int i = 0; i < catIds.length; ++i) {
            SiteWideCharacteristicsType[] swAttrSets = this.categoryCSProvider.getSiteWideCharacteristics(String.valueOf(catIds[i]));
            if (swAttrSets == null) continue;
            for (int j = 0; j < swAttrSets.length; ++j) {
                SiteWideCharacteristicsType swAttrSet = swAttrSets[j];
                AttributeSet swAst = new AttributeSet();
                swAst.setAttributeSetID((int)swAttrSet.getCharacteristicsSet().getAttributeSetID());
                swAst.setCategoryID(catIds[i]);
                swAst.setCategoryOrdinal(i);
                swAst.setName(swAttrSet.getCharacteristicsSet().getName());
                attrSetsList.add(swAst);
            }
        }
        AttributeSet[] retVal = new AttributeSet[attrSetsList.size()];
        for (int i = 0; i < attrSetsList.size(); ++i) {
            retVal[i] = (AttributeSet)((Object)attrSetsList.get(i));
        }
        return retVal;
    }

    private static Node addErrorElements(Document doc, Node eBayNode, ErrorSet[] errList) {
        Element errors = XmlUtil.appendChildNode((Document)doc, (Node)eBayNode, (String)"Errors");
        for (int i = 0; i < errList.length; ++i) {
            Node err = errList[i].toXml(doc);
            errors.appendChild(err);
        }
        return errors;
    }

    static void addHiddenInputTag(StringBuffer sb, String name, String val) {
        String str = "<input type=\"hidden\" name=\"" + name + "\" value=\"" + val + "\"/>";
        sb.append(str);
    }

    public synchronized String renderHtml(AttributeSet[] attrSets, Document xslDoc, ErrorSet[] errorList) throws SdkException, Exception {
        this.xslDoc = xslDoc;
        return this.renderHtml(attrSets, errorList);
    }

    public AttributeSet getReturnPolicyAttributeSet(AttributeSet[] siteWideAttrSets) throws SdkException, Exception {
        AttributeSet retVal = null;
        for (int i = 0; i < siteWideAttrSets.length; ++i) {
            AttributeSet attrSet = siteWideAttrSets[i];
            if (!attrSet.getName().equals(RETURN_POLICY)) continue;
            retVal = attrSet;
            break;
        }
        return retVal;
    }

    public synchronized String renderHtml(AttributeSet[] attrSets, ErrorSet[] errorList) throws SdkException, Exception {
        StringBuffer sb = new StringBuffer();
        if (attrSets == null || attrSets.length == 0) {
            return "";
        }
        for (int i = 0; i < attrSets.length; ++i) {
            AttributeSet attrSet = attrSets[i];
            if (attrSet == null) {
                return "";
            }
            String productID = attrSet.getProductID();
            if (productID == null) {
                productID = "";
            }
            AttributesMaster.addHiddenInputTag(sb, CAT_CS_ID + String.valueOf(i), String.valueOf(attrSet.getCategoryID()) + "_" + String.valueOf(attrSet.getAttributeSetID()) + "_" + productID);
        }
        Document xmlDoc = this.attrXmlProvider.getMultipleCSXml(attrSets);
        if (xmlDoc == null) {
            return sb.toString();
        }
        Node eBayNode = XPathUtil.selectSingleNode((String)"//eBay", (Node)xmlDoc);
        Element selectedAttributes = xmlDoc.createElement(SELECTED_ATTRIBUTES);
        eBayNode.appendChild(selectedAttributes);
        for (int i = 0; i < attrSets.length; ++i) {
            AttributeSet attrSet = attrSets[i];
            String attrSetName = attrSet.getName();
            if (attrSetName != null && attrSetName.equals(RETURN_POLICY)) {
                XmlUtil.appendAttributeNode((Element)selectedAttributes, (String)PAGE_ID, (String)RETURN_POLICY_PAGE_ID);
            }
            Node node = this.getSelectedAttributesXml(xmlDoc, attrSet);
            selectedAttributes.appendChild(node);
        }
        Node errNode = null;
        if (errorList != null && errorList.length != 0) {
            errNode = AttributesMaster.addErrorElements(xmlDoc, eBayNode, errorList);
        }
        String table = XmlUtil.xslTransform((Document)xmlDoc, (Document)this.xslDoc);
        sb.append(table);
        if (errNode != null) {
            eBayNode.removeChild(errNode);
        }
        eBayNode.removeChild(selectedAttributes);
        return sb.toString();
    }

    public synchronized String renderHtmlForPostback(Map nameValues, ErrorSet[] errorList) throws SdkException, Exception {
        AttributeSet[] attrSets = this.nameValuesToAttributeSets(nameValues);
        return this.renderHtml(attrSets, errorList);
    }

    private static void addDateToValueNode(Node valNode, String date) throws Exception {
        String year = "";
        String month = "";
        String day = "";
        year = date.substring(0, 4);
        month = date.substring(4, 6);
        day = date.substring(6, 8);
        Document doc = valNode.getOwnerDocument();
        XmlUtil.appendChildNode((Document)doc, (Node)valNode, (String)"Year", (String)year);
        XmlUtil.appendChildNode((Document)doc, (Node)valNode, (String)"Month", (String)month);
        XmlUtil.appendChildNode((Document)doc, (Node)valNode, (String)"Day", (String)day);
    }

    private void checkSingleValueListItem(Attribute attr) throws SdkException {
        if (attr.getValue().length != 1) {
            throw new SdkException("Invalid IAttribute object. One one value in ValueList is expected.");
        }
    }

    private Node getSelectedAttributesXml(Document doc, AttributeSet attrSet) throws Exception {
        Element attrSetNode = doc.createElement(ATTRIBUTE_SET);
        XmlUtil.appendAttributeNode((Element)attrSetNode, (String)ID, (String)String.valueOf(attrSet.getAttributeSetID()));
        AttributeType[] attrs = attrSet.getAttribute();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                int n;
                Element valueElement;
                Value val;
                Attribute attr = (Attribute)attrSet.getAttribute(i);
                Element attrNode = XmlUtil.appendChildNode((Document)doc, (Node)attrSetNode, (String)ATTRIBUTE);
                XmlUtil.appendAttributeNode((Element)attrNode, (String)ID, (int)attr.getAttributeID());
                if (attr.getType() == 0) {
                    this.checkSingleValueListItem(attr);
                    val = (Value)attr.getValue(0);
                    valueElement = XmlUtil.appendChildNode((Document)doc, (Node)attrNode, (String)VALUE);
                    XmlUtil.appendAttributeNode((Element)valueElement, (String)ID, (int)val.getValueID());
                    if (val.getValueID() != -6 || val.getValueLiteral() == null) continue;
                    Element attrOther = XmlUtil.appendChildNode((Document)doc, (Node)attrSetNode, (String)ATTRIBUTE);
                    XmlUtil.appendAttributeNode((Element)attrOther, (String)ID, (int)attr.getAttributeID());
                    Element v_e = XmlUtil.appendChildNode((Document)doc, (Node)attrOther, (String)VALUE);
                    XmlUtil.appendChildNode((Document)doc, (Node)v_e, (String)NAME, (String)val.getValueLiteral());
                    continue;
                }
                if (attr.getType() == 1) {
                    for (n = 0; n < attr.getValue().length; ++n) {
                        Value v_s = (Value)attr.getValue(n);
                        valueElement = XmlUtil.appendChildNode((Document)doc, (Node)attrNode, (String)VALUE);
                        XmlUtil.appendAttributeNode((Element)valueElement, (String)ID, (int)v_s.getValueID());
                    }
                    continue;
                }
                if (attr.getType() == 11) {
                    this.checkSingleValueListItem(attr);
                    val = (Value)attr.getValue(0);
                    valueElement = XmlUtil.appendChildNode((Document)doc, (Node)attrNode, (String)VALUE);
                    XmlUtil.appendChildNode((Document)doc, (Node)valueElement, (String)NAME, (String)val.getValueLiteral());
                    continue;
                }
                if (attr.getType() == 12) {
                    this.checkSingleValueListItem(attr);
                    val = (Value)attr.getValue(0);
                    valueElement = XmlUtil.appendChildNode((Document)doc, (Node)attrNode, (String)VALUE);
                    XmlUtil.appendAttributeNode((Element)valueElement, (String)ID, (int)val.getValueID());
                    AttributesMaster.addDateToValueNode(valueElement, val.getValueLiteral());
                    continue;
                }
                for (n = 0; n < attr.getValue().length; ++n) {
                    Value v_o = (Value)attr.getValue(n);
                    valueElement = XmlUtil.appendChildNode((Document)doc, (Node)attrNode, (String)VALUE);
                    XmlUtil.appendChildNode((Document)doc, (Node)valueElement, (String)NAME, (String)v_o.getValueLiteral());
                    if (v_o.getValueID() == null || v_o.getValueID() == 0) continue;
                    XmlUtil.appendAttributeNode((Element)valueElement, (String)ID, (String)v_o.getValueID().toString());
                }
            }
        }
        return attrSetNode;
    }

    public ErrorSet[] validate(AttributeSet[] attrSets) throws SdkException, Exception {
        int i;
        ArrayList<ErrorSet> errList = new ArrayList<ErrorSet>();
        for (i = 0; i < attrSets.length; ++i) {
            AttributeSet attrSet = attrSets[i];
            ErrorSet errSet = this.validateOneSet(attrSet);
            if (errSet == null) continue;
            errList.add(errSet);
        }
        ErrorSet[] es = new ErrorSet[errList.size()];
        for (i = 0; i < errList.size(); ++i) {
            es[i] = (ErrorSet)errList.get(i);
        }
        return es;
    }

    private String getRuleSelectString(int csId, int aId) {
        String s = "//eBay/Characteristics/CharacteristicsSet";
        String select = s + "[@id='" + csId + "']";
        select = select + "/CharacteristicsList/Initial/Attribute";
        select = select + "[@id='" + aId + "']";
        select = select + "/ValidationRules/Rule";
        return select;
    }

    private ErrorSet validateOneSet(AttributeSet attrSet) throws SAXException, IOException, ParserConfigurationException, SdkException, Exception {
        ErrorSet errSet = null;
        AttributeType[] attrs = attrSet.getAttribute();
        if (attrs == null) {
            return errSet;
        }
        Document xml = this.attrXmlProvider.getMultipleCSXml(new AttributeSet[]{attrSet});
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = (Attribute)attrSet.getAttribute(i);
            String select = this.getRuleSelectString(attrSet.getAttributeSetID(), attr.getAttributeID());
            NodeList rules = XPathUtil.selectNodes((String)select, (Node)xml);
            int rCnt = rules.getLength();
            for (int r = 0; r < rCnt; ++r) {
                Error err = this.validateAttr(attr, rules.item(r));
                if (err == null) continue;
                if (errSet == null) {
                    errSet = new ErrorSet(attrSet.getAttributeSetID());
                }
                errSet.addError(err);
            }
        }
        return errSet;
    }

    private Error validateAttr(Attribute attr, Node rule) {
        ValidationRule v = null;
        ValidationResult result = null;
        try {
            v = new ValidationRule(rule);
            Object[] vParams = ValidationParams.getValidationParams(attr, v);
            result = (ValidationResult)SimpleValidator.validate(v.name, vParams);
        }
        catch (Exception ex) {
            result = new ValidationResult();
            result.setSuccess(false);
            result.setErrorMessage(ex.getClass().getName() + ": " + ex.getMessage());
        }
        if (!result.getSuccess()) {
            Error err = new Error();
            err.setAttributeID(attr.getAttributeID());
            err.setRuleName(v.name);
            err.setMessage(result.getErrorMessage());
            return err;
        }
        return null;
    }
}

