/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.sdk.SdkException;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.CharacteristicsSetType;
import com.ebay.soap.eBLBaseComponents.FeeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;

public class eBayUtil {
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final String TIME_ZONE = "GMT";

    public static String toAPITimeString(Date date, String format, String timeZone) {
        SimpleDateFormat dateFormatterAPI = null;
        dateFormatterAPI = new SimpleDateFormat(format);
        if (timeZone != null) {
            dateFormatterAPI.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        return dateFormatterAPI.format(date);
    }

    public static String toAPITimeString(Date date) {
        return eBayUtil.toAPITimeString(date, DATE_FORMAT, TIME_ZONE);
    }

    public static Date fromAPITimeString(String strDate, String format, String timeZone) throws ParseException {
        SimpleDateFormat dateFormatterAPI = null;
        dateFormatterAPI = new SimpleDateFormat(format);
        if (timeZone != null) {
            dateFormatterAPI.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        return dateFormatterAPI.parse(strDate);
    }

    public static Date fromAPITimeString(String strDate) throws ParseException {
        return eBayUtil.fromAPITimeString(strDate, DATE_FORMAT, TIME_ZONE);
    }

    public static FeeType findFeeByName(FeeType[] fees, String feeName) {
        FeeType ft = null;
        for (int i = 0; i < fees.length; ++i) {
            if (!fees[i].getName().equals(feeName)) continue;
            ft = fees[i];
            break;
        }
        return ft;
    }

    public static String convertInputStreamToString(InputStream inStrm) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStrm));
        StringBuffer response = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            response.append(line + "\n");
        }
        return response.toString();
    }

    public static boolean isNonZeroString(String s) {
        return s != null && s.length() > 0;
    }

    public static String intToString(int i) {
        return new Integer(i).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sortCategoryArray(CategoryType[] cats, int sortBy, boolean ascending) throws Exception {
        int i;
        Hashtable<Integer, CategoryType> catsMap = new Hashtable<Integer, CategoryType>();
        for (i = 0; i < cats.length; ++i) {
            Integer t = null;
            if (sortBy == 1) {
                CharacteristicsSetType[] sets = cats[i].getCharacteristicsSets();
                if (sets == null || sets.length <= 0) throw new SdkException("No CharacteristicsSet cat be found for the category.");
                t = sets[0].getAttributeSetID();
            } else {
                t = new Integer(cats[i].getCategoryID());
            }
            catsMap.put(t, cats[i]);
        }
        Object[] cms = catsMap.entrySet().toArray();
        for (i = 0; i < cms.length - 1; ++i) {
            int ival = (Integer)((Map.Entry)cms[i]).getKey();
            for (int j = i + 1; j < cms.length; ++j) {
                boolean larger;
                Map.Entry e2 = (Map.Entry)cms[j];
                boolean bl = larger = ival > (Integer)e2.getKey();
                if ((!ascending || !larger) && (ascending || larger)) continue;
                Object c = cms[i];
                cms[i] = cms[j];
                cms[j] = c;
                ival = (Integer)e2.getKey();
            }
        }
        for (i = 0; i < cms.length; ++i) {
            cats[i] = (CategoryType)((Map.Entry)cms[i]).getValue();
        }
    }

    public static String getFullPathOfClass(Class cls) {
        URL url = cls.getProtectionDomain().getCodeSource().getLocation();
        String path = url.getPath();
        String[] dirs = cls.getName().split("\\.");
        for (int i = 0; i < dirs.length - 1; ++i) {
            path = path + dirs[i] + "/";
        }
        return path;
    }
}

