/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.sdk.util.XPathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlUtil {
    public static String getXmlStringFromSource(Source payload) {
        String result = null;
        StreamResult strResult = new StreamResult(new StringWriter());
        if (payload != null) {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
                transformer.transform(payload, strResult);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            result = strResult.getWriter().toString();
        }
        return result;
    }

    public static String getXmlStringFromDom(Document doc) {
        DOMSource payload = new DOMSource(doc.getDocumentElement());
        return XmlUtil.getXmlStringFromSource(payload);
    }

    public static Document createDom(String xml) throws SAXException, IOException, ParserConfigurationException {
        StringReader sr = new StringReader(xml);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(sr));
        return doc;
    }

    public static Document createDom() throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        return doc;
    }

    public static Document createDom(File file) throws SAXException, IOException, ParserConfigurationException {
        FileInputStream is = new FileInputStream(file);
        return XmlUtil.createDom(is);
    }

    public static Document createDom(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        return doc;
    }

    public static Document createDomByPathname(String pathname) throws SAXException, IOException, ParserConfigurationException {
        File file = new File(pathname);
        return XmlUtil.createDom(file);
    }

    public static Element appendChildNode(Document doc, Node parent, String name) {
        Element child = doc.createElement(name);
        parent.appendChild(child);
        return child;
    }

    public static Element appendChildNode(Document doc, String namespace, Node parent, String name) {
        Element child = doc.createElementNS(namespace, name);
        parent.appendChild(child);
        return child;
    }

    public static Element appendChildNode(Document doc, Node parent, String name, int value) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(new Integer(value).toString()));
        parent.appendChild(child);
        return child;
    }

    public static Element appendChildNode(Document doc, Node parent, String name, String value) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(value));
        parent.appendChild(child);
        return child;
    }

    public static Element appendChildNode(Document doc, String namespace, Node parent, String name, String value) {
        Element child = doc.createElementNS(namespace, name);
        child.appendChild(doc.createTextNode(value));
        parent.appendChild(child);
        return child;
    }

    public static void appendAttributeNode(Element parent, String name, String value) {
        parent.setAttribute(name, value);
    }

    public static void appendAttributeNode(String namespace, Element parent, String name, String value) {
        parent.setAttributeNS(namespace, name, value);
    }

    public static void appendAttributeNode(Element parent, String name, int value) {
        parent.setAttribute(name, new Integer(value).toString());
    }

    public static void appendAttributeNode(String namespace, Element parent, String name, int value) {
        parent.setAttributeNS(namespace, name, new Integer(value).toString());
    }

    public static Element appendChildNodeCDATA(Document doc, Node parent, String name, int value) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createCDATASection(new Integer(value).toString()));
        parent.appendChild(child);
        return child;
    }

    public static Element appendChildNodeCDATA(Document doc, Node parent, String name, String value) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createCDATASection(value));
        parent.appendChild(child);
        return child;
    }

    public static String getChildString(Node node, String xpath) throws TransformerException {
        Node fnd;
        XPath xp = XPathUtil.createXPath(xpath);
        NodeList nodes = XPathUtil.execute(xp, node);
        if (nodes != null && nodes.getLength() > 0 && (fnd = nodes.item(0).getFirstChild()) != null) {
            return fnd.getNodeValue();
        }
        return "";
    }

    public static String getChildStringNS(Element element, String namespace, String childName) {
        Node fnd;
        NodeList nodes = element.getElementsByTagNameNS(namespace, childName);
        if (nodes.getLength() > 0 && (fnd = nodes.item(0).getFirstChild()) != null) {
            return fnd.getNodeValue();
        }
        return "";
    }

    public static int getChildInteger(Node node, String xpath) throws TransformerException {
        int n = -1;
        String s = XmlUtil.getChildString(node, xpath).trim();
        if (s.length() > 0) {
            n = Integer.parseInt(s);
        }
        return n;
    }

    public static boolean getChildBoolean(Node node, String xpath) throws TransformerException {
        boolean b = false;
        String s = XmlUtil.getChildString(node, xpath).trim();
        if (s.equals("1")) {
            b = true;
        }
        return b;
    }

    public static double getChildDouble(Node node, String xpath) throws TransformerException {
        double d = 0.0;
        String s = XmlUtil.getChildString(node, xpath).trim();
        if (s.length() > 0) {
            d = Double.parseDouble(s);
        }
        return d;
    }

    public static Date getChildDate(Node node, String xpath) throws TransformerException, ParseException {
        Date d = new Date(0L);
        String s = XmlUtil.getChildString(node, xpath).trim();
        if (s.length() > 0) {
            DateFormat inst = DateFormat.getInstance();
            d = inst.parse(s);
        }
        return d;
    }

    public static Node findNode(Node node, String nodeName) {
        if (nodeName.equals(node.getNodeName())) {
            return node;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node ret = XmlUtil.findNode(children.item(i), nodeName);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static Node getChildByName(Node node, String nodeName) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node c = children.item(i);
            if (!c.getNodeName().equals(nodeName)) continue;
            return c;
        }
        return null;
    }

    public static String getChildStringByName(Node node, String nodeName, String errValue) {
        Node fnd;
        Node nd = XmlUtil.getChildByName(node, nodeName);
        if (nd != null && (fnd = nd.getFirstChild()) != null) {
            return fnd.getNodeValue();
        }
        return errValue;
    }

    public static int getChildIntegerByName(Node node, String nodeName, int errValue) {
        String s = XmlUtil.getChildStringByName(node, nodeName, "");
        if (s.length() > 0) {
            return Integer.parseInt(s);
        }
        return errValue;
    }

    public static boolean getChildBooleanByName(Node node, String nodeName) {
        String s = XmlUtil.getChildStringByName(node, nodeName, "");
        return s.equals("1");
    }

    public static double getChildDoubleByName(Node node, String nodeName, double errValue) {
        String s = XmlUtil.getChildStringByName(node, nodeName, "");
        if (s.length() > 0) {
            return Double.parseDouble(s);
        }
        return errValue;
    }

    public static String xslTransform(Document xmlDoc, Document xslDoc) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(xmlDoc);
        DOMSource xslSrc = new DOMSource(xslDoc);
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer transformer = xformFactory.newTransformer(xslSrc);
        StringWriter sw = new StringWriter();
        StreamResult outXml = new StreamResult(sw);
        transformer.transform(source, outXml);
        return sw.toString();
    }

    public static Node findAttribute(Node node, String name) {
        Node found = null;
        NamedNodeMap nm = node.getAttributes();
        if (nm != null) {
            for (int i = 0; i < nm.getLength(); ++i) {
                Node attr = nm.item(i);
                if (attr.getNodeName().compareToIgnoreCase(name) != 0) continue;
                found = attr;
                break;
            }
        }
        return found;
    }

    public static String getAttributeString(Node node, String name) {
        Node nd = XmlUtil.findAttribute(node, name);
        if (nd != null) {
            return nd.getNodeValue();
        }
        return null;
    }

    public static int getAttributeInteger(Node node, String name, int errValue) {
        String s = XmlUtil.getAttributeString(node, name);
        if (s != null && s.length() > 0) {
            return Integer.parseInt(s);
        }
        return errValue;
    }

    public static double getAttributeDouble(Node node, String name, double errValue) {
        String s = XmlUtil.getAttributeString(node, name);
        if (s != null && s.length() > 0) {
            return Double.parseDouble(s);
        }
        return errValue;
    }

    public static boolean getAttributeBoolean(Node node, String name) {
        String s = XmlUtil.getAttributeString(node, name);
        if (s != null && s.length() > 0) {
            return s.compareToIgnoreCase("1") == 0;
        }
        return false;
    }

    public static void setChildValue(Document doc, Node parent, String childName, String value) {
        Node node = XmlUtil.getChildByName(parent, childName);
        if (node == null) {
            node = XmlUtil.appendChildNode(doc, parent, childName);
        }
        if (node.getFirstChild() == null) {
            node.appendChild(doc.createTextNode(value));
        } else {
            node.getFirstChild().setNodeValue(value);
        }
    }

    public static void setChildValue(Document doc, Node parent, String childName, int value) {
        XmlUtil.setChildValue(doc, parent, childName, new Integer(value).toString());
    }

    public static void saveDomToFile(Document doc, String filePath) throws Exception {
        DOMSource source = new DOMSource(doc);
        File file = new File(filePath);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }
}

