/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XPathUtil {
    public static XPath createXPath(String expr) throws TransformerException {
        return XPathUtil.createXPath(expr, 0);
    }

    public static XPath createXPath(String expr, int type) throws TransformerException {
        return XPathUtil.createXPath(expr, (PrefixResolver)null, type);
    }

    public static XPath createXPath(String expr, Node contextNode, int type) throws TransformerException {
        PrefixResolverDefault resolver = new PrefixResolverDefault(contextNode);
        return XPathUtil.createXPath(expr, null, (PrefixResolver)resolver, type);
    }

    public static XPath createXPath(String expr, PrefixResolver resolver, int type) throws TransformerException {
        return XPathUtil.createXPath(expr, null, resolver, type);
    }

    public static XPath createXPath(String expr, SAXSourceLocator locator, PrefixResolver resolver, int type) throws TransformerException {
        return new XPath(expr, (SourceLocator)locator, resolver, type);
    }

    public static NodeList selectNodes(String expr, Node contextNode) throws TransformerException {
        return XPathUtil.execute(expr, contextNode, 0);
    }

    public static Node selectSingleNode(String expr, Node contextNode) throws TransformerException {
        NodeList nl = XPathUtil.execute(expr, contextNode, 0);
        if (nl.getLength() > 0) {
            return nl.item(0);
        }
        return null;
    }

    public static NodeList execute(String expr, Node contextNode, int type) throws TransformerException {
        XPathContext xpathContext;
        PrefixResolverDefault resolver = new PrefixResolverDefault(contextNode);
        XPath xpath = XPathUtil.createXPath(expr, (PrefixResolver)resolver, type);
        XObject xobj = xpath.execute(xpathContext = new XPathContext(), contextNode, (PrefixResolver)resolver);
        if (xobj != null) {
            return xobj.nodelist();
        }
        return null;
    }

    public static NodeList execute(String systemId, String expr, Node contextNode, int type) throws TransformerException {
        SAXSourceLocator locator = new SAXSourceLocator();
        locator.setSystemId(systemId);
        PrefixResolverDefault resolver = new PrefixResolverDefault(contextNode);
        XPath xpath = new XPath(expr, (SourceLocator)locator, (PrefixResolver)resolver, type);
        return XPathUtil.execute(xpath, contextNode);
    }

    public static NodeList execute(XPath xpath, Node contextNode) throws TransformerException {
        XPathContext xpathContext = new XPathContext();
        XObject xobj = xpath.execute(xpathContext, contextNode, xpathContext.getNamespaceContext());
        if (xobj != null) {
            return xobj.nodelist();
        }
        return null;
    }

    public static NodeList execute(XPathContext xpathContext, XPath xpath, Node contextNode) throws TransformerException {
        XObject xobj = xpath.execute(xpathContext, contextNode, xpathContext.getNamespaceContext());
        if (xobj != null) {
            return xobj.nodelist();
        }
        return null;
    }
}

