/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.soap.eBLBaseComponents.AttributeSetType;
import com.ebay.soap.eBLBaseComponents.AttributeType;
import com.ebay.soap.eBLBaseComponents.ValType;

public abstract class AttributeHelper {
    public static AttributeType findAttribute(AttributeSetType ast, int attributeID) {
        AttributeType[] attrs = ast.getAttribute();
        if (attrs == null) {
            return null;
        }
        for (int i = 0; i < attrs.length; ++i) {
            AttributeType attr = attrs[i];
            if (attr.getAttributeID() != attributeID) continue;
            return attr;
        }
        return null;
    }

    private static AttributeType appendNewAttribute(AttributeSetType ast) {
        AttributeType attrNew;
        AttributeType[] attrs = ast.getAttribute();
        int oldLen = attrs == null ? 0 : attrs.length;
        AttributeType[] newAttrs = new AttributeType[oldLen + 1];
        if (oldLen > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                newAttrs[i] = attrs[i];
            }
        }
        newAttrs[oldLen] = attrNew = new AttributeType();
        ast.setAttribute(newAttrs);
        return attrNew;
    }

    public static void insertToAttributeSet(AttributeSetType ast, int attributeID, int valueID, String valStr) {
        AttributeType attr = AttributeHelper.findAttribute(ast, attributeID);
        if (attr == null) {
            attr = AttributeHelper.appendNewAttribute(ast);
            attr.setAttributeID(attributeID);
        }
        ValType v = new ValType();
        if (valueID != 0) {
            v.setValueID(new Integer(valueID));
        }
        v.setValueLiteral(valStr);
        ValType[] vals = new ValType[]{v};
        attr.setValue(vals);
    }

    public static String getValueLiteral(AttributeSetType ast, int attributeID) {
        AttributeType attr = AttributeHelper.findAttribute(ast, attributeID);
        if (attr == null) {
            return null;
        }
        ValType[] vals = attr.getValue();
        if (attr != null && vals != null && vals.length > 0) {
            return vals[0].getValueLiteral();
        }
        return null;
    }

    public static int getValueID(AttributeSetType ast, int attributeID) {
        AttributeType attr = AttributeHelper.findAttribute(ast, attributeID);
        if (attr == null) {
            return 0;
        }
        ValType[] vals = attr.getValue();
        if (attr != null && vals != null && vals.length > 0) {
            Integer it = vals[0].getValueID();
            return it == null ? 0 : it;
        }
        return 0;
    }

    public static boolean removeAttribute(AttributeSetType ast, int attributeID) {
        AttributeType attr = AttributeHelper.findAttribute(ast, attributeID);
        if (attr == null) {
            return false;
        }
        AttributeType[] oldAttrs = ast.getAttribute();
        AttributeType[] newAttrs = new AttributeType[oldAttrs.length - 1];
        int n = 0;
        for (int i = 0; i < oldAttrs.length; ++i) {
            if (oldAttrs[i].getAttributeID() == attributeID) continue;
            newAttrs[n++] = oldAttrs[i];
        }
        ast.setAttribute(newAttrs);
        return true;
    }
}

