/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.util;

import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.ExceptionFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;

public abstract class ApiLoggingHelper {
    private static Log defaultLogger = null;

    private static Log getDefaultLogger() {
        if (defaultLogger == null) {
            SimpleLayout lo = new SimpleLayout();
            ConsoleAppender ca = new ConsoleAppender((Layout)lo);
            BasicConfigurator.configure((Appender)ca);
            defaultLogger = LogFactory.getLog((String)ApiLoggingHelper.class.getName());
        }
        return defaultLogger;
    }

    public static Log getLog(ApiLogging apiLogging) {
        Log log = null;
        if (ApiLoggingHelper.isLogEnabled(apiLogging) && (log = apiLogging.getOverrideLog()) == null) {
            log = ApiLoggingHelper.getDefaultLogger();
        }
        return log;
    }

    public static boolean isLogEnabled(ApiLogging apiLogging) {
        return apiLogging != null && apiLogging.getEnableLogging();
    }

    public static boolean isLogExceptions(ApiLogging apiLogging) {
        return ApiLoggingHelper.isLogEnabled(apiLogging) && apiLogging.getLogExceptions();
    }

    public static boolean isLogSOAPMessages(ApiLogging apiLogging) {
        if (!ApiLoggingHelper.isLogEnabled(apiLogging)) {
            return false;
        }
        if (apiLogging.getMessageLoggingFilter() != null) {
            return false;
        }
        return apiLogging.getLogSOAPMessages();
    }

    public static boolean isLogHTTPHeaders(ApiLogging apiLogging) {
        return ApiLoggingHelper.isLogEnabled(apiLogging) && apiLogging.getLogHTTPHeaders();
    }

    public static ExceptionFilter getExceptionFilter(ApiLogging apiLogging) {
        ExceptionFilter filter = null;
        if (apiLogging != null) {
            filter = apiLogging.getMessageLoggingFilter();
        }
        return filter;
    }

    public static boolean isLogMatched(ExceptionFilter filter, Exception callException) {
        if (filter == null) {
            return true;
        }
        return filter.matches(callException);
    }
}

