/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.pictureservice.eps;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.pictureservice.PictureInfo;
import com.ebay.sdk.pictureservice.PictureService;
import com.ebay.sdk.util.ApiLoggingHelper;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AckCodeType;
import com.ebay.soap.eBLBaseComponents.ObjectFactory;
import com.ebay.soap.eBLBaseComponents.PhotoDisplayCodeType;
import com.ebay.soap.eBLBaseComponents.PictureSetCodeType;
import com.ebay.soap.eBLBaseComponents.UploadSiteHostedPicturesRequestType;
import com.ebay.soap.eBLBaseComponents.UploadSiteHostedPicturesResponseType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class eBayPictureServiceXMLCall
implements PictureService {
    private ApiContext apiContext;
    private static final String EBAY_NAMESPACE = "urn:ebay:apis:eBLBaseComponents";
    private static final String API_CALL_NAME = "UploadSiteHostedPictures";
    private static final String BOUNDARY = "gc0p4Jq0M2Yt08jU534c0p";
    private static final String CRLF = "\r\n";

    public eBayPictureServiceXMLCall(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public boolean UpLoadSiteHostedPicture(PictureInfo picInfo, UploadSiteHostedPicturesRequestType request) {
        ApiLogging apiLogging = this.apiContext.getApiLogging();
        Log log = ApiLoggingHelper.getLog(apiLogging);
        try {
            Document doc = this.marshal(request);
            this.addAuthToken(doc);
            if (ApiLoggingHelper.isLogSOAPMessages(apiLogging)) {
                String formattedReqXmlString = XmlUtil.getXmlStringFromDom(doc);
                this.logMessage(log, "UploadSiteHostedPicturesRequest", formattedReqXmlString);
            }
            String requestXmlString = this.xmlToString(doc);
            String respString = this.sendFile(picInfo.getPictureFilePath(), requestXmlString);
            if (ApiLoggingHelper.isLogSOAPMessages(apiLogging)) {
                Document respDom = XmlUtil.createDom(respString);
                String formattedRespXmlString = XmlUtil.getXmlStringFromDom(respDom);
                this.logMessage(log, "UploadSiteHostedPicturesResponse", formattedRespXmlString);
            }
            UploadSiteHostedPicturesResponseType response = this.unmarshal(respString);
            picInfo.setReponse(response);
            if (response.getErrors() == null || response.getErrors().length == 0) {
                picInfo.setURL(response.getSiteHostedPictureDetails().getFullURL());
                return true;
            }
            if (response.getErrors().length > 0 && response.getAck() == AckCodeType.WARNING) {
                picInfo.setURL(response.getSiteHostedPictureDetails().getFullURL());
                picInfo.setErrorType("PICTURE SERVICE RESPONSE WARNING");
                picInfo.setErrorMessage(response.getErrors()[0].getShortMessage());
                if (ApiLoggingHelper.isLogExceptions(apiLogging)) {
                    log.warn((Object)"PICTURE SERVICE RESPONSE WARNING");
                    log.warn((Object)response.getErrors()[0].getShortMessage());
                }
                return true;
            }
            picInfo.setErrorType("PICTURE SERVICE RESPONSE ERROR");
            picInfo.setErrorMessage(response.getErrors()[0].getShortMessage());
            if (ApiLoggingHelper.isLogExceptions(apiLogging)) {
                log.error((Object)"PICTURE SERVICE RESPONSE ERROR");
                log.error((Object)response.getErrors()[0].getShortMessage());
            }
            return false;
        }
        catch (Exception e) {
            picInfo.setErrorType("PICTURE SERVICE UPLOAD ERROR");
            picInfo.setErrorMessage(e.getMessage());
            if (ApiLoggingHelper.isLogExceptions(apiLogging)) {
                log.error((Object)"fail to upload picture to eBay picture server!");
                log.error((Object)e.getMessage());
            }
            return false;
        }
    }

    private void logMessage(Log log, String msgName, String msgStr) {
        String reqTime = eBayUtil.toAPITimeString(Calendar.getInstance().getTime());
        log.info((Object)MessageFormat.format("[{0}][{1}][{2}]\n", msgName, reqTime, this.apiContext.getEpsServerUrl()));
        log.info((Object)msgStr);
    }

    public boolean uploadPicture(PhotoDisplayCodeType option, PictureInfo picInfo, boolean firstImage) {
        UploadSiteHostedPicturesRequestType request = new UploadSiteHostedPicturesRequestType();
        if (option.equals((Object)PhotoDisplayCodeType.SUPER_SIZE) || option.equals((Object)PhotoDisplayCodeType.PICTURE_PACK)) {
            request.setPictureSet(PictureSetCodeType.SUPERSIZE);
        }
        return this.UpLoadSiteHostedPicture(picInfo, request);
    }

    public int uploadPictures(PhotoDisplayCodeType option, PictureInfo[] picInfoList) {
        int nSuccess = 0;
        for (int i = 0; i < picInfoList.length; ++i) {
            if (!this.uploadPicture(option, picInfoList[i], i == 0)) continue;
            ++nSuccess;
        }
        return nSuccess;
    }

    private String xmlToString(Document doc) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    private Document marshal(UploadSiteHostedPicturesRequestType uploadSiteHostedPicturesRequest) throws JAXBException, ParserConfigurationException {
        JAXBContext reqContext = JAXBContext.newInstance((Class[])new Class[]{UploadSiteHostedPicturesRequestType.class});
        Marshaller marshaller = reqContext.createMarshaller();
        if (uploadSiteHostedPicturesRequest == null) {
            uploadSiteHostedPicturesRequest = new UploadSiteHostedPicturesRequestType();
        }
        JAXBElement<UploadSiteHostedPicturesRequestType> reqElement = new ObjectFactory().createUploadSiteHostedPicturesRequest(uploadSiteHostedPicturesRequest);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        marshaller.marshal(reqElement, (Node)doc);
        return doc;
    }

    private UploadSiteHostedPicturesResponseType unmarshal(String responseXmlString) throws JAXBException {
        JAXBContext respContext = JAXBContext.newInstance((Class[])new Class[]{UploadSiteHostedPicturesResponseType.class});
        Unmarshaller unmarshaller = respContext.createUnmarshaller();
        JAXBElement respElement = (JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(responseXmlString)));
        UploadSiteHostedPicturesResponseType response = (UploadSiteHostedPicturesResponseType)respElement.getValue();
        return response;
    }

    private String sendFile(String fileName, String requestXmlString) throws IOException {
        URL u = new URL(this.apiContext.getEpsServerUrl());
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        this.setConnectionProperty(c);
        String reqStr1 = "--gc0p4Jq0M2Yt08jU534c0p\r\nContent-Disposition: form-data; name=document\r\nContent-Type: text/xml; charset=\"UTF-8\"\r\n\r\n" + requestXmlString + CRLF + "--" + BOUNDARY + CRLF + "Content-Disposition: form-data; name=image; filename=image" + CRLF + "Content-Transfer-Encoding: binary" + CRLF + "Content-Type: application/octet-stream" + CRLF + CRLF;
        String reqStr2 = "\r\n--gc0p4Jq0M2Yt08jU534c0p--\r\n";
        byte[] content = this.readInFile(fileName);
        c.connect();
        OutputStream os = c.getOutputStream();
        os.write(reqStr1.getBytes());
        os.write(content);
        os.write(reqStr2.getBytes());
        os.flush();
        os.close();
        StringBuffer buf = this.readInResponse(c);
        c.disconnect();
        return buf.toString();
    }

    private StringBuffer readInResponse(HttpURLConnection c) throws IOException {
        String line;
        InputStreamReader is = new InputStreamReader(c.getInputStream());
        BufferedReader reader = new BufferedReader(is);
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buf.append(line + "\n");
        }
        is.close();
        reader.close();
        return buf;
    }

    private byte[] readInFile(String fileName) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        FileInputStream fin = new FileInputStream(file);
        byte[] content = new byte[(int)file.length()];
        fin.read(content);
        return content;
    }

    private void setConnectionProperty(HttpURLConnection c) throws ProtocolException {
        c.setRequestMethod("POST");
        c.setRequestProperty("Content-Type", "multipart/form-data, boundary=gc0p4Jq0M2Yt08jU534c0p");
        c.addRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", this.apiContext.getWSDLVersion());
        c.addRequestProperty("X-EBAY-API-CALL-NAME", API_CALL_NAME);
        c.addRequestProperty("X-EBAY-API-SITEID", String.valueOf(SiteIDUtil.toNumericalID(this.apiContext.getSite())));
        c.addRequestProperty("X-EBAY-API-DETAIL-LEVEL", "0");
        c.setUseCaches(false);
        c.setDoInput(true);
        c.setDoOutput(true);
    }

    private void addAuthToken(Document doc) throws SdkException {
        Node node = XmlUtil.getChildByName(doc, "UploadSiteHostedPicturesRequest");
        Element requesterCredentials = XmlUtil.appendChildNode(doc, EBAY_NAMESPACE, node, "RequesterCredentials");
        String tokenString = this.apiContext.getApiCredential().geteBayToken();
        if (tokenString == null || tokenString.length() == 0) {
            throw new SdkException("No Token Found!!!");
        }
        XmlUtil.appendChildNode(doc, (Node)requesterCredentials, "eBayAuthToken", tokenString);
    }
}

