/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.logging;

import com.ebay.sdk.logging.CallMetrics;
import com.ebay.sdk.logging.SingleCallMetrics;
import com.ebay.sdk.logging.ThreadLocalSingleCallMetrics;

public class MetricsLogger {
    public static final String KEY_METRICS_LOGGING_ENABLED = "com.ebay.sdk.MetricsLogging";

    public static void enableMetricsLogging() {
        System.setProperty(KEY_METRICS_LOGGING_ENABLED, "true");
    }

    public static boolean metricsLoggingEnabled() {
        String property = System.getProperty(KEY_METRICS_LOGGING_ENABLED);
        return property != null && "true".equalsIgnoreCase(property);
    }

    public static void startRecordingSingleCallMetrics(String apiName) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        ThreadLocalSingleCallMetrics.resetSingleCallMetrics();
        SingleCallMetrics metrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        metrics.setCallname(apiName);
        metrics.setApiCallStarted(System.currentTimeMillis());
    }

    public static SingleCallMetrics endRecordingSingleCallMetrics() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return null;
        }
        SingleCallMetrics metrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        metrics.setApiCallEnded(System.currentTimeMillis());
        return metrics;
    }

    public static SingleCallMetrics getSingleCallMetrics() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return null;
        }
        return ThreadLocalSingleCallMetrics.getSingleCallMetrics();
    }

    public static void collectMetrics(CallMetrics metrics) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics singleMetrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        if (null == singleMetrics) {
            return;
        }
        metrics.addCallMetrics(singleMetrics);
    }

    public static void startSdkJAXBCallInvoke() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics metrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        metrics.setSdkJAXBCallInvokeStarted(System.currentTimeMillis());
    }

    public static void recordServerProcessingTime(long l) {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics metrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        metrics.setServerProcessingTime(l);
    }

    public static void endSdkJAXBCallInvoke() {
        if (!MetricsLogger.metricsLoggingEnabled()) {
            return;
        }
        SingleCallMetrics metrics = ThreadLocalSingleCallMetrics.getSingleCallMetrics();
        metrics.setSdkJAXBCallInvokeEnded(System.currentTimeMillis());
    }
}

