/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.logging;

import com.ebay.sdk.logging.SingleCallMetrics;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CallMetrics {
    public static final int NUMBER_OF_COLUMNS = 5;
    private HashMap callMetricsTable = new HashMap();
    private static final String SPACES = "                                 ";

    static void printOneNumber(PrintStream ps, long time) {
        String timeString = String.valueOf(time);
        ps.print(timeString + SPACES.substring(0, 10 - timeString.length()));
    }

    static void printOneString(PrintStream ps, String str, int columnWidth) {
        ps.print(str + SPACES.substring(0, columnWidth - str.length()));
    }

    public synchronized void addCallMetrics(SingleCallMetrics metrics) {
        String callname = metrics.getCallname();
        Vector<SingleCallMetrics> metricsList = (Vector<SingleCallMetrics>)this.callMetricsTable.get(callname);
        if (null == metricsList) {
            metricsList = new Vector<SingleCallMetrics>();
            this.callMetricsTable.put(callname, metricsList);
        }
        metricsList.add(metrics);
    }

    public void generateReport(PrintStream ps) {
        if (this.callMetricsTable.size() == 0) {
            ps.println("No metrics data found");
            return;
        }
        for (String callName : this.callMetricsTable.keySet()) {
            List callMetricsList = (List)this.callMetricsTable.get(callName);
            ps.println("== " + callName + " ==");
            this.generateReportForSingleCallname(ps, callMetricsList);
            ps.println("\n");
        }
    }

    public void generateReportForSingleCallname(PrintStream ps, List callMetricsList) {
        ps.println("Number of calls recorded: " + callMetricsList.size());
        Collection goodSamples = this.normalize(callMetricsList);
        ps.println("Number of calls for statistics: " + goodSamples.size());
        ps.print("Total" + SPACES.substring(0, 10 - "Total".length()));
        ps.print("PreJAXB" + SPACES.substring(0, 10 - "PreJAXB".length()));
        ps.print("PostJAXB" + SPACES.substring(0, 10 - "PostJAXB".length()));
        ps.print("Network" + SPACES.substring(0, 10 - "Network".length()));
        ps.print("Server" + SPACES.substring(0, 10 - "Server".length()));
        ps.print("Start Time" + SPACES.substring(0, 10 - "Start Time".length()));
        ps.println();
        ps.println("=========================================================================");
        for (SingleCallMetrics metrics : callMetricsList) {
            metrics.generateReport(ps);
        }
        ps.println("=========================================================================");
        if (goodSamples.size() != 0) {
            long[] averages = this.generateAverage(goodSamples);
            for (int i = 0; i < averages.length; ++i) {
                CallMetrics.printOneNumber(ps, averages[i]);
            }
        }
        ps.println();
    }

    private long[] generateAverage(Collection goodSamples) {
        long[] averages = new long[5];
        for (int i = 0; i < averages.length; ++i) {
            averages[i] = 0L;
        }
        for (SingleCallMetrics metrics : goodSamples) {
            metrics.updateTotals(averages);
        }
        int i = 0;
        while (i < averages.length) {
            int n = i++;
            averages[n] = averages[n] / (long)goodSamples.size();
        }
        return averages;
    }

    private Collection normalize(List metricsList) {
        Collections.sort(metricsList, new SortByTurnAroundTime());
        int totalNumberSamples = metricsList.size();
        int numSampleToTrim = (int)(5.0 * (double)totalNumberSamples / 100.0 + 0.5);
        if (numSampleToTrim <= 0) {
            numSampleToTrim = 1;
        }
        ArrayList returnList = new ArrayList();
        Iterator iter = metricsList.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (count >= numSampleToTrim && count < totalNumberSamples - numSampleToTrim) {
                returnList.add(value);
            }
            ++count;
        }
        return returnList;
    }

    private static class SortByTurnAroundTime
    implements Comparator {
        private SortByTurnAroundTime() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof SingleCallMetrics)) {
                return 0;
            }
            SingleCallMetrics metrics1 = (SingleCallMetrics)o1;
            long turnAroundTime1 = metrics1.getTurnaroundTime();
            if (!(o2 instanceof SingleCallMetrics)) {
                return 0;
            }
            SingleCallMetrics metrics2 = (SingleCallMetrics)o2;
            long turnAroundTime2 = metrics2.getTurnaroundTime();
            if (turnAroundTime1 > turnAroundTime2) {
                return -1;
            }
            if (turnAroundTime1 < turnAroundTime2) {
                return 1;
            }
            return 0;
        }
    }
}

