/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.handler;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.handler.BaseHandler;
import com.ebay.sdk.util.ApiLoggingHelper;
import com.ebay.sdk.util.XmlUtil;
import java.text.MessageFormat;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageLoggingHandler
extends BaseHandler<SOAPMessageContext>
implements SOAPHandler<SOAPMessageContext> {
    private static final String HANDLER_NAME = "SOAPMessageLoggingHandler";

    public SOAPMessageLoggingHandler() {
        super.setHandlerName(HANDLER_NAME);
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        ApiContext apiContext = (ApiContext)smc.get((Object)"api_context");
        ApiLogging apiLogging = apiContext.getApiLogging();
        Log log = ApiLoggingHelper.getLog(apiLogging);
        String xmlStr = null;
        try {
            SOAPMessage message = smc.getMessage();
            Source payload = message.getSOAPPart().getContent();
            xmlStr = XmlUtil.getXmlStringFromSource(payload);
        }
        catch (Exception e) {
            if (ApiLoggingHelper.isLogExceptions(apiLogging)) {
                log.error((Object)"SOAPMessageLoggingHandler : fail to get xml string from SOAP message");
                log.error((Object)e.getMessage());
            } else {
                e.printStackTrace();
            }
            return true;
        }
        Boolean request = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (request.booleanValue()) {
            apiContext.setRequestXml(xmlStr);
            if (ApiLoggingHelper.isLogSOAPMessages(apiLogging)) {
                this.logMessage(log, "Request", xmlStr);
            }
        } else {
            apiContext.setResponseXml(xmlStr);
            if (ApiLoggingHelper.isLogSOAPMessages(apiLogging)) {
                this.logMessage(log, "Response", xmlStr);
            }
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext smc) {
        ApiContext apiContext = (ApiContext)smc.get((Object)"api_context");
        ApiLogging apiLogging = apiContext.getApiLogging();
        Log log = ApiLoggingHelper.getLog(apiLogging);
        String xmlStr = null;
        try {
            SOAPMessage message = smc.getMessage();
            Source payload = message.getSOAPPart().getContent();
            xmlStr = XmlUtil.getXmlStringFromSource(payload);
        }
        catch (Exception e) {
            if (ApiLoggingHelper.isLogExceptions(apiLogging)) {
                log.error((Object)"SOAPMessageLoggingHandler : fail to get xml string from SOAP message");
                log.error((Object)e.getMessage());
            } else {
                e.printStackTrace();
            }
            return true;
        }
        apiContext.setResponseXml(xmlStr);
        if (ApiLoggingHelper.isLogSOAPMessages(apiLogging)) {
            this.logMessage(log, "Response", xmlStr);
        }
        return true;
    }

    private void logMessage(Log log, String msgName, String msgStr) {
        String hs = MessageFormat.format("{0} Message: Length={1}", msgName, new Integer(msgStr.length()));
        log.info((Object)hs);
        log.info((Object)msgStr);
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

